/*
 * Decompiled with CFR 0.152.
 */
package com.github.vlachenal.sql;

import com.github.vlachenal.sql.ClausesBuilder;
import com.github.vlachenal.sql.SQLQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class UpdateBuilder {
    final StringBuilder buffer;
    final List<Object> values;

    public UpdateBuilder(String table) {
        this.buffer = new StringBuilder("UPDATE ").append(table).append(" SET ");
        this.values = new ArrayList<Object>();
    }

    public UpdateBuilder field(String column, Object value) {
        if (!this.values.isEmpty()) {
            this.buffer.append(", ");
        }
        this.buffer.append(column).append(" = ?");
        this.values.add(value);
        return this;
    }

    public UpdateBuilder field(String column, Optional<?> value) {
        value.ifPresent(o -> this.field(column, o));
        return this;
    }

    public UpdateBuilder where(ClausesBuilder clauses) {
        if (!clauses.firstClause) {
            this.buffer.append(" WHERE ").append((CharSequence)clauses.buffer);
            this.values.addAll(clauses.values);
        }
        return this;
    }

    public SQLQuery build() {
        return new SQLQuery(this.buffer.toString(), this.values);
    }
}

