/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid.hazelcast;

import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.map.IMap;
import com.hazelcast.nio.serialization.Serializer;
import io.github.bucket4j.distributed.proxy.AbstractProxyManager;
import io.github.bucket4j.distributed.proxy.ClientSideConfig;
import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.Request;
import io.github.bucket4j.distributed.serialization.InternalSerializationHelper;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.grid.hazelcast.HazelcastEntryProcessor;
import io.github.bucket4j.grid.hazelcast.SimpleBackupProcessor;
import io.github.bucket4j.grid.hazelcast.serialization.HazelcastEntryProcessorSerializer;
import io.github.bucket4j.grid.hazelcast.serialization.SimpleBackupProcessorSerializer;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class HazelcastProxyManager<K>
extends AbstractProxyManager<K> {
    private final IMap<K, byte[]> map;

    public HazelcastProxyManager(IMap<K, byte[]> map) {
        this(map, ClientSideConfig.getDefault());
    }

    public HazelcastProxyManager(IMap<K, byte[]> map, ClientSideConfig clientSideConfig) {
        super(clientSideConfig);
        this.map = Objects.requireNonNull(map);
    }

    public <T> CommandResult<T> execute(K key, Request<T> request) {
        HazelcastEntryProcessor entryProcessor = new HazelcastEntryProcessor(request);
        byte[] response = (byte[])this.map.executeOnKey(key, entryProcessor);
        Version backwardCompatibilityVersion = request.getBackwardCompatibilityVersion();
        return InternalSerializationHelper.deserializeResult((byte[])response, (Version)backwardCompatibilityVersion);
    }

    public boolean isAsyncModeSupported() {
        return true;
    }

    public <T> CompletableFuture<CommandResult<T>> executeAsync(K key, Request<T> request) {
        HazelcastEntryProcessor entryProcessor = new HazelcastEntryProcessor(request);
        CompletionStage future = this.map.submitToKey(key, entryProcessor);
        Version backwardCompatibilityVersion = request.getBackwardCompatibilityVersion();
        return (CompletableFuture)future.thenApply(bytes -> InternalSerializationHelper.deserializeResult((byte[])bytes, (Version)backwardCompatibilityVersion));
    }

    public void removeProxy(K key) {
        this.map.remove(key);
    }

    protected CompletableFuture<Void> removeAsync(K key) {
        CompletionStage hazelcastFuture = this.map.removeAsync(key);
        CompletableFuture<Void> resultFuture = new CompletableFuture<Void>();
        hazelcastFuture.whenComplete((oldState, error) -> {
            if (error == null) {
                resultFuture.complete(null);
            } else {
                resultFuture.completeExceptionally((Throwable)error);
            }
        });
        return resultFuture;
    }

    public static void addCustomSerializers(SerializationConfig serializationConfig, int typeIdBase) {
        serializationConfig.addSerializerConfig(new SerializerConfig().setImplementation((Serializer)new HazelcastEntryProcessorSerializer(typeIdBase)).setTypeClass(HazelcastEntryProcessor.class));
        serializationConfig.addSerializerConfig(new SerializerConfig().setImplementation((Serializer)new SimpleBackupProcessorSerializer(typeIdBase + 1)).setTypeClass(SimpleBackupProcessor.class));
    }
}

