/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid.ignite;

import io.github.bucket4j.Bucket;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.grid.GridBucket;
import io.github.bucket4j.grid.GridBucketState;
import io.github.bucket4j.grid.GridProxy;
import io.github.bucket4j.grid.ProxyManager;
import io.github.bucket4j.grid.ignite.IgniteProxy;
import java.io.Serializable;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.ignite.IgniteCache;

public class IgniteProxyManager<K extends Serializable>
implements ProxyManager<K> {
    private final GridProxy<K> gridProxy;

    IgniteProxyManager(IgniteCache<K, GridBucketState> cache) {
        if (cache == null) {
            throw new IllegalArgumentException("cache must not be null");
        }
        this.gridProxy = new IgniteProxy<K>(cache);
    }

    public Bucket getProxy(K key, Supplier<BucketConfiguration> supplier) {
        return GridBucket.createLazyBucket(key, supplier, this.gridProxy);
    }

    public Optional<Bucket> getProxy(K key) {
        return this.getProxyConfiguration(key).map(configuration -> GridBucket.createLazyBucket((Serializable)key, () -> configuration, this.gridProxy));
    }

    public Optional<BucketConfiguration> getProxyConfiguration(K key) {
        return this.gridProxy.getConfiguration(key);
    }
}

