/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid.infinispan.serialization;

import io.github.bucket4j.serialization.DataStreamAdapter;
import io.github.bucket4j.serialization.SerializationHandle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.infinispan.protostream.MessageMarshaller;

public class ProtobufMessageMarshaller<T>
implements MessageMarshaller<T> {
    private static DataStreamAdapter ADAPTER = new DataStreamAdapter();
    private final SerializationHandle<T> serializationHandle;
    private final String protoTypeName;

    public ProtobufMessageMarshaller(SerializationHandle<T> serializationHandle, String protoTypeName) {
        this.serializationHandle = serializationHandle;
        this.protoTypeName = protoTypeName;
    }

    public T readFrom(MessageMarshaller.ProtoStreamReader reader) throws IOException {
        byte[] bytes = reader.readBytes("data");
        try (DataInputStream inputSteam = new DataInputStream(new ByteArrayInputStream(bytes));){
            Object object = ADAPTER.readObject((DataInput)inputSteam);
            return (T)object;
        }
    }

    public void writeTo(MessageMarshaller.ProtoStreamWriter writer, T value) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(byteStream);
        ADAPTER.writeObject((DataOutput)output, value);
        output.close();
        byteStream.close();
        byte[] bytes = byteStream.toByteArray();
        writer.writeBytes("data", bytes);
    }

    public Class<T> getJavaClass() {
        return this.serializationHandle.getSerializedType();
    }

    public String getTypeName() {
        return this.protoTypeName;
    }
}

