/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid.infinispan;

import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.grid.CommandResult;
import io.github.bucket4j.grid.GridBucketState;
import io.github.bucket4j.grid.GridCommand;
import io.github.bucket4j.grid.GridProxy;
import io.github.bucket4j.grid.infinispan.SerializableFunctionAdapter;
import io.github.bucket4j.grid.jcache.JCacheEntryProcessor;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.infinispan.commons.CacheException;
import org.infinispan.functional.FunctionalMap;
import org.infinispan.util.function.SerializableFunction;

public class InfinispanProxy<K extends Serializable>
implements GridProxy<K> {
    private final FunctionalMap.ReadWriteMap<K, GridBucketState> readWriteMap;

    public InfinispanProxy(FunctionalMap.ReadWriteMap<K, GridBucketState> readWriteMap) {
        this.readWriteMap = readWriteMap;
    }

    public <T extends Serializable> CommandResult<T> execute(K key, GridCommand<T> command) {
        JCacheEntryProcessor entryProcessor = JCacheEntryProcessor.executeProcessor(command);
        return this.invokeSync(key, entryProcessor);
    }

    public void createInitialState(K key, BucketConfiguration configuration) {
        JCacheEntryProcessor entryProcessor = JCacheEntryProcessor.initStateProcessor((BucketConfiguration)configuration);
        this.invokeSync(key, entryProcessor);
    }

    public <T extends Serializable> T createInitialStateAndExecute(K key, BucketConfiguration configuration, GridCommand<T> command) {
        JCacheEntryProcessor entryProcessor = JCacheEntryProcessor.initStateAndExecuteProcessor(command, (BucketConfiguration)configuration);
        CommandResult<T> result = this.invokeSync(key, entryProcessor);
        return (T)result.getData();
    }

    public <T extends Serializable> CompletableFuture<CommandResult<T>> executeAsync(K key, GridCommand<T> command) {
        JCacheEntryProcessor entryProcessor = JCacheEntryProcessor.executeProcessor(command);
        return this.invokeAsync(key, entryProcessor);
    }

    public <T extends Serializable> CompletableFuture<T> createInitialStateAndExecuteAsync(K key, BucketConfiguration configuration, GridCommand<T> command) {
        JCacheEntryProcessor entryProcessor = JCacheEntryProcessor.initStateAndExecuteProcessor(command, (BucketConfiguration)configuration);
        CompletableFuture<CommandResult<T>> result = this.invokeAsync(key, entryProcessor);
        return result.thenApply(CommandResult::getData);
    }

    public Optional<BucketConfiguration> getConfiguration(K key) {
        try {
            SerializableFunction & Serializable findFunction = (SerializableFunction & Serializable)entry -> entry.find().orElse(null);
            GridBucketState state = (GridBucketState)this.readWriteMap.eval(key, (SerializableFunction)findFunction).get();
            if (state == null) {
                return Optional.empty();
            }
            return Optional.of(state.getConfiguration());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public boolean isAsyncModeSupported() {
        return true;
    }

    private <T extends Serializable> CommandResult<T> invokeSync(K key, JCacheEntryProcessor<K, T> entryProcessor) {
        try {
            return (CommandResult)this.readWriteMap.eval(key, new SerializableFunctionAdapter<K, T>(entryProcessor)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new CacheException((Throwable)e);
        }
    }

    private <T extends Serializable> CompletableFuture<CommandResult<T>> invokeAsync(K key, JCacheEntryProcessor<K, T> entryProcessor) {
        return this.readWriteMap.eval(key, new SerializableFunctionAdapter<K, T>(entryProcessor));
    }
}

