/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid.jcache;

import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.grid.CommandResult;
import io.github.bucket4j.grid.GridBucketState;
import io.github.bucket4j.grid.GridCommand;
import io.github.bucket4j.grid.GridProxy;
import io.github.bucket4j.grid.jcache.JCacheEntryProcessor;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.spi.CachingProvider;

public class JCacheProxy<K extends Serializable>
implements GridProxy<K> {
    private static final Map<String, String> incompatibleProviders = new HashMap<String, String>();
    private final Cache<K, GridBucketState> cache;

    public JCacheProxy(Cache<K, GridBucketState> cache) {
        this.cache = Objects.requireNonNull(cache);
        this.checkProviders(cache);
    }

    public <T extends Serializable> CommandResult<T> execute(K key, GridCommand<T> command) {
        JCacheEntryProcessor entryProcessor = JCacheEntryProcessor.executeProcessor(command);
        return (CommandResult)this.cache.invoke(key, entryProcessor, new Object[0]);
    }

    public void createInitialState(K key, BucketConfiguration configuration) {
        JCacheEntryProcessor entryProcessor = JCacheEntryProcessor.initStateProcessor(configuration);
        this.cache.invoke(key, entryProcessor, new Object[0]);
    }

    public <T extends Serializable> T createInitialStateAndExecute(K key, BucketConfiguration configuration, GridCommand<T> command) {
        JCacheEntryProcessor entryProcessor = JCacheEntryProcessor.initStateAndExecuteProcessor(command, configuration);
        CommandResult result = (CommandResult)this.cache.invoke(key, entryProcessor, new Object[0]);
        return (T)result.getData();
    }

    public <T extends Serializable> CompletableFuture<CommandResult<T>> executeAsync(K key, GridCommand<T> command) {
        throw new UnsupportedOperationException();
    }

    public <T extends Serializable> CompletableFuture<T> createInitialStateAndExecuteAsync(K key, BucketConfiguration configuration, GridCommand<T> command) {
        throw new UnsupportedOperationException();
    }

    public Optional<BucketConfiguration> getConfiguration(K key) {
        GridBucketState state = (GridBucketState)this.cache.get(key);
        if (state == null) {
            return Optional.empty();
        }
        return Optional.of(state.getConfiguration());
    }

    public boolean isAsyncModeSupported() {
        return false;
    }

    private void checkProviders(Cache<K, GridBucketState> cache) {
        CacheManager cacheManager = cache.getCacheManager();
        if (cacheManager == null) {
            return;
        }
        CachingProvider cachingProvider = cacheManager.getCachingProvider();
        if (cachingProvider == null) {
            return;
        }
        String providerClassName = cachingProvider.getClass().getName();
        incompatibleProviders.forEach((providerPrefix, recommendation) -> {
            if (providerClassName.startsWith((String)providerPrefix)) {
                String message = "The Cache provider " + providerClassName + " is incompatible with Bucket4j, " + recommendation;
                throw new UnsupportedOperationException(message);
            }
        });
    }

    static {
        incompatibleProviders.put("org.infinispan", " use module bucket4j-infinispan directly");
    }
}

