/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.redis.spring.cas;

import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.distributed.ExpirationAfterWriteStrategy;
import io.github.bucket4j.distributed.proxy.generic.compare_and_swap.AbstractCompareAndSwapBasedProxyManager;
import io.github.bucket4j.distributed.proxy.generic.compare_and_swap.AsyncCompareAndSwapOperation;
import io.github.bucket4j.distributed.proxy.generic.compare_and_swap.CompareAndSwapOperation;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.redis.AbstractRedisProxyManagerBuilder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.springframework.data.redis.connection.RedisCommands;
import org.springframework.data.redis.connection.ReturnType;

public class SpringDataRedisBasedProxyManager
extends AbstractCompareAndSwapBasedProxyManager<byte[]> {
    private final RedisCommands commands;
    private final ExpirationAfterWriteStrategy expirationStrategy;
    private final byte[] scriptSetNxPx = "return redis.call('set', KEYS[1], ARGV[1], 'nx', 'px', ARGV[2])".getBytes(StandardCharsets.UTF_8);
    private final byte[] scriptSetNx = "return redis.call('set', KEYS[1], ARGV[1], 'nx')".getBytes(StandardCharsets.UTF_8);
    private final byte[] scriptCompareAndSwapPx = "if redis.call('get', KEYS[1]) == ARGV[1] then redis.call('psetex', KEYS[1], ARGV[3], ARGV[2]); return 1; else return 0; end".getBytes(StandardCharsets.UTF_8);
    private final byte[] scriptCompareAndSwap = "if redis.call('get', KEYS[1]) == ARGV[1] then redis.call('set', KEYS[1], ARGV[2]); return 1; else return 0; end".getBytes(StandardCharsets.UTF_8);

    public static SpringDataRedisBasedProxyManagerBuilder builderFor(RedisCommands redisCommands) {
        return new SpringDataRedisBasedProxyManagerBuilder(redisCommands);
    }

    private SpringDataRedisBasedProxyManager(SpringDataRedisBasedProxyManagerBuilder builder) {
        super(builder.getClientSideConfig());
        this.commands = builder.redisCommands;
        this.expirationStrategy = builder.getNotNullExpirationStrategy();
    }

    protected CompareAndSwapOperation beginCompareAndSwapOperation(final byte[] key) {
        return new CompareAndSwapOperation(){

            public Optional<byte[]> getStateData() {
                return Optional.ofNullable(SpringDataRedisBasedProxyManager.this.commands.get(key));
            }

            public boolean compareAndSwap(byte[] originalData, byte[] newData, RemoteBucketState newState) {
                return SpringDataRedisBasedProxyManager.this.compareAndSwap(key, originalData, newData, newState);
            }
        };
    }

    protected AsyncCompareAndSwapOperation beginAsyncCompareAndSwapOperation(byte[] key) {
        throw new UnsupportedOperationException();
    }

    public void removeProxy(byte[] key) {
        this.commands.del((byte[][])new byte[][]{key});
    }

    protected CompletableFuture<Void> removeAsync(byte[] key) {
        return CompletableFuture.runAsync(() -> this.commands.del((byte[][])new byte[][]{key}));
    }

    public boolean isAsyncModeSupported() {
        return false;
    }

    private Boolean compareAndSwap(byte[] key, byte[] originalData, byte[] newData, RemoteBucketState newState) {
        long ttlMillis = this.calculateTtlMillis(newState);
        if (ttlMillis > 0L) {
            if (originalData == null) {
                byte[][] keysAndArgs = new byte[][]{key, newData, this.encodeLong(ttlMillis)};
                return (Boolean)this.commands.eval(this.scriptSetNxPx, ReturnType.BOOLEAN, 1, (byte[][])keysAndArgs);
            }
            byte[][] keysAndArgs = new byte[][]{key, originalData, newData, this.encodeLong(ttlMillis)};
            return (Boolean)this.commands.eval(this.scriptCompareAndSwapPx, ReturnType.BOOLEAN, 1, (byte[][])keysAndArgs);
        }
        if (originalData == null) {
            byte[][] keysAndArgs = new byte[][]{key, newData};
            return (Boolean)this.commands.eval(this.scriptSetNx, ReturnType.BOOLEAN, 1, (byte[][])keysAndArgs);
        }
        byte[][] keysAndArgs = new byte[][]{key, originalData, newData};
        return (Boolean)this.commands.eval(this.scriptCompareAndSwap, ReturnType.BOOLEAN, 1, (byte[][])keysAndArgs);
    }

    private byte[] encodeLong(Long value) {
        return ("" + value).getBytes(StandardCharsets.UTF_8);
    }

    private long calculateTtlMillis(RemoteBucketState state) {
        Optional clock = this.getClientSideConfig().getClientSideClock();
        long currentTimeNanos = clock.isPresent() ? ((TimeMeter)clock.get()).currentTimeNanos() : System.currentTimeMillis() * 1000000L;
        return this.expirationStrategy.calculateTimeToLiveMillis(state, currentTimeNanos);
    }

    public static class SpringDataRedisBasedProxyManagerBuilder
    extends AbstractRedisProxyManagerBuilder<SpringDataRedisBasedProxyManagerBuilder> {
        private final RedisCommands redisCommands;

        private SpringDataRedisBasedProxyManagerBuilder(RedisCommands redisCommands) {
            this.redisCommands = Objects.requireNonNull(redisCommands);
        }

        public SpringDataRedisBasedProxyManager build() {
            return new SpringDataRedisBasedProxyManager(this);
        }
    }
}

