/*
 * Decompiled with CFR 0.152.
 */
package com.github.rollingmetrics.dropwizard;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Timer;
import com.github.rollingmetrics.counter.WindowCounter;
import com.github.rollingmetrics.dropwizard.adapter.ReservoirToRollingHdrHistogramAdapter;
import com.github.rollingmetrics.dropwizard.adapter.TopMetricSet;
import com.github.rollingmetrics.histogram.hdr.RollingHdrHistogram;
import com.github.rollingmetrics.hitratio.HitRatio;
import com.github.rollingmetrics.top.Top;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class Dropwizard {
    public static Reservoir toReservoir(RollingHdrHistogram rollingHdrHistogram) {
        return new ReservoirToRollingHdrHistogramAdapter(rollingHdrHistogram);
    }

    public static Histogram toHistogram(RollingHdrHistogram rollingHdrHistogram) {
        return new Histogram(Dropwizard.toReservoir(rollingHdrHistogram));
    }

    public static Timer toTimer(RollingHdrHistogram rollingHdrHistogram) {
        return new Timer(Dropwizard.toReservoir(rollingHdrHistogram));
    }

    public static Gauge<Long> toGauge(WindowCounter counter) {
        Objects.requireNonNull(counter);
        return () -> ((WindowCounter)counter).getSum();
    }

    public static Gauge<Double> toGauge(HitRatio hitRatio) {
        Objects.requireNonNull(hitRatio);
        return () -> ((HitRatio)hitRatio).getHitRatio();
    }

    public static MetricSet toMetricSet(String name, Top top, TimeUnit latencyUnit, int digitsAfterDecimalPoint) {
        return new TopMetricSet(name, top, latencyUnit, digitsAfterDecimalPoint);
    }
}

