/*
 * Decompiled with CFR 0.152.
 */
package com.github.rollingmetrics.hitratio;

import com.github.rollingmetrics.histogram.util.Printer;
import com.github.rollingmetrics.hitratio.HitRatio;
import com.github.rollingmetrics.hitratio.HitRatioUtil;
import com.github.rollingmetrics.util.Clock;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class SmoothlyDecayingRollingHitRatio
implements HitRatio {
    static final int MAX_CHUNKS = 100;
    static final long MIN_ROLLING_WINDOW_MILLIS = 1000L;
    private static final int HIT_INDEX = 0;
    private static final int TOTAL_INDEX = 1;
    private final long intervalBetweenResettingMillis;
    private final Clock clock;
    private final long creationTimestamp;
    private final Chunk[] chunks;

    public SmoothlyDecayingRollingHitRatio(Duration rollingWindow, int numberChunks) {
        this(rollingWindow, numberChunks, Clock.defaultClock());
    }

    public Duration getRollingWindow() {
        return Duration.ofMillis((long)(this.chunks.length - 1) * this.intervalBetweenResettingMillis);
    }

    public int getChunkCount() {
        return this.chunks.length - 1;
    }

    public SmoothlyDecayingRollingHitRatio(Duration rollingWindow, int numberChunks, Clock clock) {
        if (numberChunks < 2) {
            throw new IllegalArgumentException("numberChunks should be >= 2");
        }
        if (numberChunks > 100) {
            throw new IllegalArgumentException("number of chunks should be <=100");
        }
        long rollingWindowMillis = rollingWindow.toMillis();
        if (rollingWindowMillis < 1000L) {
            throw new IllegalArgumentException("rollingWindowMillis should be >=1000");
        }
        this.intervalBetweenResettingMillis = rollingWindowMillis / (long)numberChunks;
        this.clock = clock;
        this.creationTimestamp = clock.currentTimeMillis();
        this.chunks = new Chunk[numberChunks + 1];
        for (int i = 0; i < this.chunks.length; ++i) {
            this.chunks[i] = new Chunk(i);
        }
    }

    @Override
    public void update(int hitCount, int totalCount) {
        long nowMillis = this.clock.currentTimeMillis();
        long millisSinceCreation = nowMillis - this.creationTimestamp;
        long intervalsSinceCreation = millisSinceCreation / this.intervalBetweenResettingMillis;
        int chunkIndex = (int)intervalsSinceCreation % this.chunks.length;
        this.chunks[chunkIndex].update(hitCount, totalCount, nowMillis);
    }

    @Override
    public double getHitRatio() {
        long currentTimeMillis = this.clock.currentTimeMillis();
        long millisSinceCreation = currentTimeMillis - this.creationTimestamp;
        long intervalsSinceCreation = millisSinceCreation / this.intervalBetweenResettingMillis;
        int newestChunkIndex = (int)intervalsSinceCreation % this.chunks.length;
        long[] snapshot = new long[2];
        int i = newestChunkIndex + 1;
        for (int iteration = 0; iteration < this.chunks.length; ++iteration) {
            if (i == this.chunks.length) {
                i = 0;
            }
            Chunk chunk = this.chunks[i];
            chunk.addToSnapshot(snapshot, currentTimeMillis);
            ++i;
        }
        return (double)snapshot[0] / (double)snapshot[1];
    }

    public String toString() {
        return "SmoothlyDecayingRollingHitRatio{, intervalBetweenResettingMillis=" + this.intervalBetweenResettingMillis + ", clock=" + this.clock + ", creationTimestamp=" + this.creationTimestamp + ", chunks=" + Printer.printArray(this.chunks, "chunk") + '}';
    }

    private final class Phase {
        final AtomicLong ratio = new AtomicLong();
        final long proposedInvalidationTimestamp;

        Phase(long proposedInvalidationTimestamp) {
            this.proposedInvalidationTimestamp = proposedInvalidationTimestamp;
        }

        void addToSnapshot(long[] snapshot, long currentTimeMillis) {
            long proposedInvalidationTimestamp = this.proposedInvalidationTimestamp;
            if (currentTimeMillis >= proposedInvalidationTimestamp) {
                return;
            }
            long compositeRatio = this.ratio.get();
            int hitCount = HitRatioUtil.getHitFromCompositeRatio(compositeRatio);
            int totalCount = HitRatioUtil.getTotalCountFromCompositeRatio(compositeRatio);
            if (totalCount == 0) {
                return;
            }
            long beforeInvalidateMillis = proposedInvalidationTimestamp - currentTimeMillis;
            if (beforeInvalidateMillis < SmoothlyDecayingRollingHitRatio.this.intervalBetweenResettingMillis) {
                double decayingCoefficient = (double)beforeInvalidateMillis / (double)SmoothlyDecayingRollingHitRatio.this.intervalBetweenResettingMillis;
                hitCount = (int)((double)hitCount * decayingCoefficient);
                totalCount = (int)((double)totalCount * decayingCoefficient);
            }
            snapshot[0] = snapshot[0] + (long)hitCount;
            snapshot[1] = snapshot[1] + (long)totalCount;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Phase{");
            sb.append("ratio=").append(this.ratio);
            sb.append(", proposedInvalidationTimestamp=").append(this.proposedInvalidationTimestamp);
            sb.append('}');
            return sb.toString();
        }
    }

    private final class Chunk {
        final AtomicReference<Phase> currentPhaseRef;

        Chunk(int chunkIndex) {
            long invalidationTimestamp = SmoothlyDecayingRollingHitRatio.this.creationTimestamp + (long)(SmoothlyDecayingRollingHitRatio.this.chunks.length + chunkIndex) * SmoothlyDecayingRollingHitRatio.this.intervalBetweenResettingMillis;
            this.currentPhaseRef = new AtomicReference<Phase>(new Phase(invalidationTimestamp));
        }

        void addToSnapshot(long[] snapshot, long currentTimeMillis) {
            this.currentPhaseRef.get().addToSnapshot(snapshot, currentTimeMillis);
        }

        void update(int hitCount, int totalCount, long currentTimeMillis) {
            Phase currentPhase = this.currentPhaseRef.get();
            while (currentTimeMillis >= currentPhase.proposedInvalidationTimestamp) {
                long millisSinceCreation = currentTimeMillis - SmoothlyDecayingRollingHitRatio.this.creationTimestamp;
                long intervalsSinceCreation = millisSinceCreation / SmoothlyDecayingRollingHitRatio.this.intervalBetweenResettingMillis;
                long nextProposedInvalidationTimestamp = SmoothlyDecayingRollingHitRatio.this.creationTimestamp + (intervalsSinceCreation + (long)SmoothlyDecayingRollingHitRatio.this.chunks.length) * SmoothlyDecayingRollingHitRatio.this.intervalBetweenResettingMillis;
                Phase replacement = new Phase(nextProposedInvalidationTimestamp);
                if (this.currentPhaseRef.compareAndSet(currentPhase, replacement)) {
                    currentPhase = replacement;
                    continue;
                }
                currentPhase = this.currentPhaseRef.get();
            }
            HitRatioUtil.updateRatio(currentPhase.ratio, hitCount, totalCount);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Chunk{");
            sb.append("currentPhaseRef=").append(this.currentPhaseRef);
            sb.append('}');
            return sb.toString();
        }
    }
}

