/*
 * Decompiled with CFR 0.152.
 */
package com.github.rollingmetrics.top;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.github.rollingmetrics.top.Position;
import com.github.rollingmetrics.top.Top;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class TopMetricSet
implements MetricSet {
    private final BigDecimal zero;
    private final Map<String, Metric> gauges;

    public TopMetricSet(String name, Top top, TimeUnit latencyUnit, int digitsAfterDecimalPoint) {
        if (name == null) {
            throw new IllegalArgumentException("name should not be null");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("name should not be empty");
        }
        if (top == null) {
            throw new IllegalArgumentException("top should not be null");
        }
        if (latencyUnit == null) {
            throw new IllegalArgumentException("latencyUnit should not be null");
        }
        if (digitsAfterDecimalPoint < 0) {
            throw new IllegalArgumentException("digitsAfterDecimalPoint should not be negative");
        }
        this.gauges = new HashMap<String, Metric>();
        this.gauges.put(name + ".latencyUnit", (Metric)((Gauge)latencyUnit::toString));
        this.zero = BigDecimal.ZERO.setScale(digitsAfterDecimalPoint, RoundingMode.CEILING);
        int size = top.getSize();
        for (int i = 0; i < size; ++i) {
            String latencyName = name + "." + i + "." + "latency";
            Gauge<BigDecimal> latencyGauge = this.createLatencyGauge(i, top, latencyUnit, digitsAfterDecimalPoint);
            this.gauges.put(latencyName, (Metric)latencyGauge);
            String descriptionName = name + "." + i + "." + "description";
            Gauge<String> descriptionGauge = this.createDescriptionGauge(i, top);
            this.gauges.put(descriptionName, (Metric)descriptionGauge);
        }
    }

    public Map<String, Metric> getMetrics() {
        return this.gauges;
    }

    private Gauge<BigDecimal> createLatencyGauge(int i, Top top, TimeUnit latencyUnit, int digitsAfterDecimalPoint) {
        return () -> {
            List<Position> positions = top.getPositionsInDescendingOrder();
            if (positions.size() <= i) {
                return this.zero;
            }
            double latencyNanos = positions.get(i).getLatencyInNanoseconds();
            long scale = latencyUnit.toNanos(1L);
            double result = latencyNanos / (double)scale;
            return new BigDecimal(result).setScale(digitsAfterDecimalPoint, RoundingMode.CEILING);
        };
    }

    private Gauge<String> createDescriptionGauge(int i, Top top) {
        return () -> {
            List<Position> positions = top.getPositionsInDescendingOrder();
            if (positions.size() <= i) {
                return "";
            }
            return positions.get(i).getQueryDescription();
        };
    }
}

