/*
 * Decompiled with CFR 0.152.
 */
package com.github.rollingmetrics.top.impl;

import com.github.rollingmetrics.histogram.util.Printer;
import com.github.rollingmetrics.top.Position;
import com.github.rollingmetrics.top.Top;
import com.github.rollingmetrics.top.impl.collector.PositionCollector;
import com.github.rollingmetrics.top.impl.recorder.PositionRecorder;
import com.github.rollingmetrics.top.impl.recorder.TwoPhasePositionRecorder;
import com.github.rollingmetrics.util.Clock;
import com.github.rollingmetrics.util.ResilientExecutionUtil;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class ResetByChunksTop
implements Top {
    private final Executor backgroundExecutor;
    private final long intervalBetweenResettingMillis;
    private final long creationTimestamp;
    private final ArchivedTop[] archive;
    private final boolean historySupported;
    private final Clock clock;
    private final PositionCollector temporarySnapshotCollector;
    private final Phase left;
    private final Phase right;
    private final Phase[] phases;
    private final AtomicReference<Phase> currentPhaseRef;

    public ResetByChunksTop(int size, long latencyThresholdNanos, int maxDescriptionLength, long intervalBetweenResettingMillis, int numberHistoryChunks, Clock clock, Executor backgroundExecutor) {
        this.intervalBetweenResettingMillis = intervalBetweenResettingMillis;
        this.clock = clock;
        this.creationTimestamp = clock.currentTimeMillis();
        this.backgroundExecutor = backgroundExecutor;
        Supplier<TwoPhasePositionRecorder> recorderSupplier = () -> new TwoPhasePositionRecorder(size, latencyThresholdNanos, maxDescriptionLength);
        this.left = new Phase(recorderSupplier.get(), this.creationTimestamp + intervalBetweenResettingMillis);
        this.right = new Phase(recorderSupplier.get(), Long.MAX_VALUE);
        this.phases = new Phase[]{this.left, this.right};
        this.currentPhaseRef = new AtomicReference<Phase>(this.left);
        Supplier<PositionCollector> collectorSupplier = () -> PositionCollector.createCollector(size);
        boolean bl = this.historySupported = numberHistoryChunks > 0;
        if (this.historySupported) {
            this.archive = new ArchivedTop[numberHistoryChunks];
            for (int i = 0; i < numberHistoryChunks; ++i) {
                this.archive[i] = new ArchivedTop(collectorSupplier.get(), Long.MIN_VALUE);
            }
        } else {
            this.archive = null;
        }
        this.temporarySnapshotCollector = collectorSupplier.get();
    }

    @Override
    public void update(long timestamp, long latencyTime, TimeUnit latencyUnit, Supplier<String> descriptionSupplier) {
        long currentTimeMillis = this.clock.currentTimeMillis();
        Phase currentPhase = this.currentPhaseRef.get();
        if (currentTimeMillis < currentPhase.proposedInvalidationTimestamp) {
            currentPhase.recorder.update(timestamp, latencyTime, latencyUnit, descriptionSupplier);
            return;
        }
        Phase nextPhase = currentPhase == this.left ? this.right : this.left;
        nextPhase.recorder.update(timestamp, latencyTime, latencyUnit, descriptionSupplier);
        if (!this.currentPhaseRef.compareAndSet(currentPhase, nextPhase)) {
            return;
        }
        Runnable phaseRotation = () -> this.rotate(currentTimeMillis, currentPhase, nextPhase);
        ResilientExecutionUtil.getInstance().execute(this.backgroundExecutor, phaseRotation);
    }

    @Override
    public synchronized List<Position> getPositionsInDescendingOrder() {
        this.temporarySnapshotCollector.reset();
        long currentTimeMillis = this.clock.currentTimeMillis();
        for (Phase phase : this.phases) {
            if (!phase.isNeedToBeReportedToSnapshot(currentTimeMillis)) continue;
            phase.intervalRecorder = phase.recorder.getIntervalRecorder(phase.intervalRecorder);
            phase.intervalRecorder.addInto(phase.totalsCollector);
            phase.totalsCollector.addInto(this.temporarySnapshotCollector);
        }
        if (this.historySupported) {
            for (ArchivedTop archivedTop : this.archive) {
                if (archivedTop.proposedInvalidationTimestamp <= currentTimeMillis) continue;
                archivedTop.collector.addInto(this.temporarySnapshotCollector);
            }
        }
        return this.temporarySnapshotCollector.getPositionsInDescendingOrder();
    }

    @Override
    public int getSize() {
        return this.left.intervalRecorder.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void rotate(long currentTimeMillis, Phase currentPhase, Phase nextPhase) {
        try {
            currentPhase.intervalRecorder = currentPhase.recorder.getIntervalRecorder(currentPhase.intervalRecorder);
            currentPhase.intervalRecorder.addInto(currentPhase.totalsCollector);
            if (this.historySupported) {
                long currentPhaseNumber = (currentPhase.proposedInvalidationTimestamp - this.creationTimestamp) / this.intervalBetweenResettingMillis;
                int correspondentArchiveIndex = (int)(currentPhaseNumber - 1L) % this.archive.length;
                ArchivedTop correspondentArchivedTop = this.archive[correspondentArchiveIndex];
                correspondentArchivedTop.collector.reset();
                currentPhase.totalsCollector.addInto(correspondentArchivedTop.collector);
                correspondentArchivedTop.proposedInvalidationTimestamp = currentPhase.proposedInvalidationTimestamp + (long)this.archive.length * this.intervalBetweenResettingMillis;
            }
            currentPhase.totalsCollector.reset();
        }
        finally {
            long millisSinceCreation = currentTimeMillis - this.creationTimestamp;
            long intervalsSinceCreation = millisSinceCreation / this.intervalBetweenResettingMillis;
            currentPhase.proposedInvalidationTimestamp = Long.MAX_VALUE;
            nextPhase.proposedInvalidationTimestamp = this.creationTimestamp + (intervalsSinceCreation + 1L) * this.intervalBetweenResettingMillis;
        }
    }

    public String toString() {
        return "ResetByChunksAccumulator{\nintervalBetweenResettingMillis=" + this.intervalBetweenResettingMillis + ",\n creationTimestamp=" + this.creationTimestamp + (!this.historySupported ? "" : ",\n archive=" + Printer.printArray(this.archive, "chunk")) + ",\n clock=" + this.clock + ",\n left=" + this.left + ",\n right=" + this.right + ",\n currentPhase=" + (this.currentPhaseRef.get() == this.left ? "left" : "right") + ",\n temporarySnapshotCollector=" + this.temporarySnapshotCollector + '}';
    }

    private final class Phase {
        final TwoPhasePositionRecorder recorder;
        final PositionCollector totalsCollector;
        PositionRecorder intervalRecorder;
        volatile long proposedInvalidationTimestamp;

        Phase(TwoPhasePositionRecorder recorder, long proposedInvalidationTimestamp) {
            this.recorder = recorder;
            this.intervalRecorder = recorder.getIntervalRecorder();
            this.totalsCollector = PositionCollector.createCollector(this.intervalRecorder.getSize());
            this.proposedInvalidationTimestamp = proposedInvalidationTimestamp;
        }

        public String toString() {
            return "Phase{\n, proposedInvalidationTimestamp=" + this.proposedInvalidationTimestamp + "\n, totalsCollector=" + this.totalsCollector + "\n, intervalRecorder=" + this.intervalRecorder + "\n}";
        }

        boolean isNeedToBeReportedToSnapshot(long currentTimeMillis) {
            long proposedInvalidationTimestampLocal = this.proposedInvalidationTimestamp;
            if (proposedInvalidationTimestampLocal > currentTimeMillis) {
                return true;
            }
            if (!ResetByChunksTop.this.historySupported) {
                return false;
            }
            long correspondentChunkProposedInvalidationTimestamp = proposedInvalidationTimestampLocal + (long)ResetByChunksTop.this.archive.length * ResetByChunksTop.this.intervalBetweenResettingMillis;
            return correspondentChunkProposedInvalidationTimestamp > currentTimeMillis;
        }
    }

    private final class ArchivedTop {
        private final PositionCollector collector;
        private volatile long proposedInvalidationTimestamp;

        public ArchivedTop(PositionCollector collector, long proposedInvalidationTimestamp) {
            this.collector = collector;
            this.proposedInvalidationTimestamp = proposedInvalidationTimestamp;
        }

        public String toString() {
            return "ArchivedTop{\n, proposedInvalidationTimestamp=" + this.proposedInvalidationTimestamp + "\n, collector=" + this.collector + "\n}";
        }
    }
}

