/*
 * Decompiled with CFR 0.152.
 */
package com.github.rollingmetrics.histogram.util;

import com.codahale.metrics.Snapshot;
import com.github.rollingmetrics.histogram.util.EmptySnapshot;
import java.util.function.Function;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.AtomicHistogram;
import org.HdrHistogram.ConcurrentHistogram;
import org.HdrHistogram.Histogram;

public class HistogramUtil {
    public static void reset(Histogram histogram) {
        if (histogram.getTotalCount() > 0L) {
            histogram.reset();
        }
    }

    public static void addSecondToFirst(Histogram first, Histogram second) {
        if (second.getTotalCount() > 0L) {
            first.add((AbstractHistogram)second);
        }
    }

    public static Snapshot getSnapshot(Histogram histogram, Function<Histogram, Snapshot> snapshotTaker) {
        if (histogram.getTotalCount() > 0L) {
            return snapshotTaker.apply(histogram);
        }
        return EmptySnapshot.INSTANCE;
    }

    public static Histogram createNonConcurrentCopy(Histogram source) {
        if (source instanceof ConcurrentHistogram) {
            return new Histogram(source.getNumberOfSignificantValueDigits());
        }
        if (source instanceof AtomicHistogram) {
            return new Histogram(source.getLowestDiscernibleValue(), source.getHighestTrackableValue(), source.getNumberOfSignificantValueDigits());
        }
        throw new IllegalArgumentException("Unsupported histogram class " + source.getClass());
    }
}

