/*
 * Decompiled with CFR 0.152.
 */
package com.github.rollingmetrics.top;

import com.github.rollingmetrics.top.Top;
import com.github.rollingmetrics.top.impl.ResetByChunksTop;
import com.github.rollingmetrics.top.impl.ResetOnSnapshotConcurrentTop;
import com.github.rollingmetrics.top.impl.SnapshotCachingTop;
import com.github.rollingmetrics.top.impl.UniformTop;
import com.github.rollingmetrics.util.Clock;
import com.github.rollingmetrics.util.ResilientExecutionUtil;
import java.time.Duration;
import java.util.concurrent.Executor;

public class TopBuilder {
    public static final int MAX_POSITION_COUNT = 1000;
    public static final long MIN_CHUNK_RESETTING_INTERVAL_MILLIS = 1000L;
    public static final int MAX_CHUNKS = 25;
    public static final int MIN_LENGTH_OF_QUERY_DESCRIPTION = 10;
    public static final int DEFAULT_MAX_LENGTH_OF_QUERY_DESCRIPTION = 1000;
    public static final Duration DEFAULT_LATENCY_THRESHOLD = Duration.ZERO;
    public static final Duration DEFAULT_SNAPSHOT_CACHING_DURATION = Duration.ofSeconds(1L);
    private static final Executor DEFAULT_BACKGROUND_EXECUTOR = null;
    private static final TopFactory DEFAULT_TOP_FACTORY = TopFactory.UNIFORM;
    private int size;
    private Duration latencyThreshold;
    private Duration snapshotCachingDuration;
    private int maxDescriptionLength;
    private Clock clock;
    private Executor backgroundExecutor;
    private TopFactory factory;

    private TopBuilder(int size, Duration latencyThreshold, Duration snapshotCachingDuration, int maxDescriptionLength, Clock clock, Executor backgroundExecutor, TopFactory factory) {
        this.size = size;
        this.latencyThreshold = latencyThreshold;
        this.snapshotCachingDuration = snapshotCachingDuration;
        this.maxDescriptionLength = maxDescriptionLength;
        this.clock = clock;
        this.backgroundExecutor = backgroundExecutor;
        this.factory = factory;
    }

    public Top build() {
        Top top = this.factory.create(this.size, this.latencyThreshold, this.maxDescriptionLength, this.clock);
        if (!this.snapshotCachingDuration.isZero()) {
            top = new SnapshotCachingTop(top, this.snapshotCachingDuration.toMillis(), this.clock);
        }
        return top;
    }

    public static TopBuilder newBuilder(int size) {
        TopBuilder.validateSize(size);
        return new TopBuilder(size, DEFAULT_LATENCY_THRESHOLD, DEFAULT_SNAPSHOT_CACHING_DURATION, 1000, Clock.defaultClock(), DEFAULT_BACKGROUND_EXECUTOR, DEFAULT_TOP_FACTORY);
    }

    public TopBuilder withPositionCount(int size) {
        TopBuilder.validateSize(size);
        this.size = size;
        return this;
    }

    public TopBuilder withLatencyThreshold(Duration latencyThreshold) {
        if (latencyThreshold == null) {
            throw new IllegalArgumentException("latencyThreshold should not be null");
        }
        if (latencyThreshold.isNegative()) {
            throw new IllegalArgumentException("latencyThreshold should not be negative");
        }
        this.latencyThreshold = latencyThreshold;
        return this;
    }

    public TopBuilder withSnapshotCachingDuration(Duration snapshotCachingDuration) {
        if (snapshotCachingDuration == null) {
            throw new IllegalArgumentException("snapshotCachingDuration should not be null");
        }
        if (snapshotCachingDuration.isNegative()) {
            throw new IllegalArgumentException("snapshotCachingDuration can not be negative");
        }
        this.snapshotCachingDuration = snapshotCachingDuration;
        return this;
    }

    public TopBuilder withMaxLengthOfQueryDescription(int maxLengthOfQueryDescription) {
        if (maxLengthOfQueryDescription < 10) {
            String msg = "The requested maxDescriptionLength=" + maxLengthOfQueryDescription + " is wrong " + "because of maxDescriptionLength should be >=" + 10 + "." + "How do you plan to distinguish one query from another with so short description?";
            throw new IllegalArgumentException(msg);
        }
        this.maxDescriptionLength = maxLengthOfQueryDescription;
        return this;
    }

    public TopBuilder withClock(Clock clock) {
        if (clock == null) {
            throw new IllegalArgumentException("Clock should not be null");
        }
        this.clock = clock;
        return this;
    }

    public TopBuilder withBackgroundExecutor(Executor backgroundExecutor) {
        if (backgroundExecutor == null) {
            throw new IllegalArgumentException("Clock should not be null");
        }
        this.backgroundExecutor = backgroundExecutor;
        return this;
    }

    public TopBuilder neverResetPositions() {
        this.factory = TopFactory.UNIFORM;
        return this;
    }

    public TopBuilder resetAllPositionsOnSnapshot() {
        this.factory = TopFactory.RESET_ON_SNAPSHOT;
        return this;
    }

    public TopBuilder resetAllPositionsPeriodically(Duration intervalBetweenResetting) {
        if (intervalBetweenResetting == null) {
            throw new IllegalArgumentException("intervalBetweenResetting should not be null");
        }
        if (intervalBetweenResetting.isNegative()) {
            throw new IllegalArgumentException("intervalBetweenResetting should not be negative");
        }
        long intervalBetweenResettingMillis = intervalBetweenResetting.toMillis();
        if (intervalBetweenResettingMillis < 1000L) {
            String msg = "interval between resetting one chunk should be >= 1000 millis";
            throw new IllegalArgumentException(msg);
        }
        this.factory = this.resetByChunks(intervalBetweenResettingMillis, 0);
        return this;
    }

    public TopBuilder resetPositionsPeriodicallyByChunks(Duration rollingTimeWindow, int numberChunks) {
        if (numberChunks > 25) {
            throw new IllegalArgumentException("numberChunks should be <= 25");
        }
        if (numberChunks < 2) {
            throw new IllegalArgumentException("numberChunks should be >= 1");
        }
        if (rollingTimeWindow == null) {
            throw new IllegalArgumentException("rollingTimeWindow should not be null");
        }
        if (rollingTimeWindow.isNegative()) {
            throw new IllegalArgumentException("rollingTimeWindow should not be negative");
        }
        long intervalBetweenResettingMillis = rollingTimeWindow.toMillis() / (long)numberChunks;
        if (intervalBetweenResettingMillis < 1000L) {
            String msg = "interval between resetting one chunk should be >= 1000 millis";
            throw new IllegalArgumentException(msg);
        }
        this.factory = this.resetByChunks(intervalBetweenResettingMillis, numberChunks);
        return this;
    }

    private static void validateSize(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("size should be >=1");
        }
        if (size > 1000) {
            throw new IllegalArgumentException("size should be <= 1000");
        }
    }

    private TopFactory resetByChunks(final long intervalBetweenResettingMillis, final int numberOfHistoryChunks) {
        return new TopFactory(){

            @Override
            public Top create(int size, Duration latencyThreshold, int maxDescriptionLength, Clock clock) {
                return new ResetByChunksTop(size, latencyThreshold.toNanos(), maxDescriptionLength, intervalBetweenResettingMillis, numberOfHistoryChunks, clock, TopBuilder.this.getExecutor());
            }
        };
    }

    private Executor getExecutor() {
        return this.backgroundExecutor != null ? this.backgroundExecutor : ResilientExecutionUtil.getInstance().getBackgroundExecutor();
    }

    private static interface TopFactory {
        public static final TopFactory UNIFORM = new TopFactory(){

            @Override
            public Top create(int size, Duration latencyThreshold, int maxDescriptionLength, Clock clock) {
                return new UniformTop(size, latencyThreshold.toNanos(), maxDescriptionLength);
            }
        };
        public static final TopFactory RESET_ON_SNAPSHOT = new TopFactory(){

            @Override
            public Top create(int size, Duration latencyThreshold, int maxDescriptionLength, Clock clock) {
                return new ResetOnSnapshotConcurrentTop(size, latencyThreshold.toNanos(), maxDescriptionLength);
            }
        };

        public Top create(int var1, Duration var2, int var3, Clock var4);
    }
}

