/*
 * Decompiled with CFR 0.152.
 */
package com.github.rollingmetrics.util;

import com.github.rollingmetrics.util.DaemonThreadFactory;
import com.github.rollingmetrics.util.SingleThreadExecutor;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ResilientExecutionUtil {
    private static final ThreadFactory DEFAULT_THREAD_FACTORY = new DaemonThreadFactory("metrics-core-hdr-background-worker");
    private static final ResilientExecutionUtil INSTANCE = new ResilientExecutionUtil();
    private volatile SingleThreadExecutor executorInstance;
    private ThreadFactory threadFactory = DEFAULT_THREAD_FACTORY;

    public static ResilientExecutionUtil getInstance() {
        return INSTANCE;
    }

    ResilientExecutionUtil() {
    }

    public void execute(Executor executor, Runnable task) {
        if (executor instanceof SingleThreadExecutor) {
            executor.execute(task);
            return;
        }
        AtomicBoolean alreadyExecuted = new AtomicBoolean(false);
        Runnable oneShotRunnable = () -> {
            if (alreadyExecuted.compareAndSet(false, true)) {
                task.run();
            }
        };
        try {
            executor.execute(oneShotRunnable);
        }
        catch (Throwable e) {
            oneShotRunnable.run();
        }
    }

    public Executor getBackgroundExecutor() {
        return this.getExecutorInstance();
    }

    public synchronized void shutdownBackgroundExecutor() {
        if (this.executorInstance != null) {
            this.executorInstance.stopExecutionThread();
        }
    }

    public synchronized void setThreadFactory(ThreadFactory threadFactory) {
        if (this.executorInstance != null) {
            String msg = "The executor instance already created with " + threadFactory + ", so it is impossible to replace threadFactory." + " You should call setThreadFactory strongly before first invocation of getBackgroundExecutor";
            throw new IllegalStateException(msg);
        }
        this.threadFactory = Objects.requireNonNull(threadFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SingleThreadExecutor getExecutorInstance() {
        SingleThreadExecutor executorInstance = this.executorInstance;
        if (executorInstance == null) {
            ResilientExecutionUtil resilientExecutionUtil = this;
            synchronized (resilientExecutionUtil) {
                executorInstance = this.executorInstance;
                if (executorInstance == null) {
                    this.executorInstance = executorInstance = new SingleThreadExecutor(this.threadFactory);
                }
            }
        }
        return executorInstance;
    }
}

