/*
 * Decompiled with CFR 0.152.
 */
package com.github.rollingmetrics.hitratio;

import com.github.rollingmetrics.hitratio.HitRatio;
import com.github.rollingmetrics.hitratio.HitRatioUtil;
import com.github.rollingmetrics.util.Clock;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;

public class ResetPeriodicallyHitRatio
implements HitRatio {
    private final AtomicLong ratio = new AtomicLong();
    private final long resetIntervalMillis;
    private final Clock clock;
    private final AtomicLong nextResetTimeMillisRef;

    public ResetPeriodicallyHitRatio(Duration resetInterval) {
        this(resetInterval, Clock.defaultClock());
    }

    public ResetPeriodicallyHitRatio(Duration resetInterval, Clock clock) {
        if (resetInterval.isNegative() || resetInterval.isZero()) {
            throw new IllegalArgumentException("intervalBetweenChunkResetting must be a positive duration");
        }
        this.resetIntervalMillis = resetInterval.toMillis();
        this.clock = clock;
        this.nextResetTimeMillisRef = new AtomicLong(clock.currentTimeMillis() + this.resetIntervalMillis);
    }

    @Override
    public void update(int hitCount, int totalCount) {
        long nextResetTimeMillis = this.nextResetTimeMillisRef.get();
        long currentTimeMillis = this.clock.currentTimeMillis();
        if (currentTimeMillis >= nextResetTimeMillis && this.nextResetTimeMillisRef.compareAndSet(nextResetTimeMillis, Long.MAX_VALUE)) {
            this.ratio.set(0L);
            this.nextResetTimeMillisRef.set(currentTimeMillis + this.resetIntervalMillis);
        }
        HitRatioUtil.updateRatio(this.ratio, hitCount, totalCount);
    }

    @Override
    public double getHitRatio() {
        long nextResetTimeMillis = this.nextResetTimeMillisRef.get();
        long currentTimeMillis = this.clock.currentTimeMillis();
        if (currentTimeMillis >= nextResetTimeMillis) {
            if (this.nextResetTimeMillisRef.compareAndSet(nextResetTimeMillis, Long.MAX_VALUE)) {
                this.ratio.set(0L);
                this.nextResetTimeMillisRef.set(currentTimeMillis + this.resetIntervalMillis);
            }
            return Double.NaN;
        }
        return HitRatioUtil.getRatio(this.ratio.get());
    }
}

