/*
 * Decompiled with CFR 0.152.
 */
package com.github.rollingmetrics.top;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class Position
implements Comparable<Position> {
    private final long latencyTime;
    private final TimeUnit latencyUnit;
    private final String description;
    private final long timestamp;
    private long latencyInNanoseconds;

    public Position(long timestamp, long latencyTime, TimeUnit latencyUnit, Supplier<String> descriptionSupplier, int maxDescriptionLengt) {
        this(timestamp, latencyTime, latencyUnit, Position.combineDescriptionWithLatency(latencyTime, latencyUnit, descriptionSupplier, maxDescriptionLengt));
    }

    public Position(long timestamp, long latencyTime, TimeUnit latencyUnit, String description) {
        this.latencyTime = latencyTime;
        this.latencyUnit = latencyUnit;
        this.description = description;
        this.timestamp = timestamp;
        this.latencyInNanoseconds = latencyUnit.toNanos(latencyTime);
    }

    public String getQueryDescription() {
        return this.description;
    }

    public long getLatencyTime() {
        return this.latencyTime;
    }

    public TimeUnit getLatencyUnit() {
        return this.latencyUnit;
    }

    public long getLatencyInNanoseconds() {
        return this.latencyInNanoseconds;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public int compareTo(Position other) {
        if (this.latencyInNanoseconds != other.latencyInNanoseconds) {
            return Long.compare(this.latencyInNanoseconds, other.latencyInNanoseconds);
        }
        if (this.timestamp != other.timestamp) {
            return Long.compare(this.timestamp, other.timestamp);
        }
        return this.description.compareTo(other.description);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Position position = (Position)o;
        if (this.timestamp != position.timestamp) {
            return false;
        }
        if (this.latencyInNanoseconds != position.latencyInNanoseconds) {
            return false;
        }
        return this.description.equals(position.description);
    }

    public int hashCode() {
        int result = this.description.hashCode();
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + (int)(this.latencyInNanoseconds ^ this.latencyInNanoseconds >>> 32);
        return result;
    }

    public String toString() {
        return "Position{latencyTime=" + this.latencyTime + ", latencyUnit=" + (Object)((Object)this.latencyUnit) + ", description='" + this.description + '\'' + ", timestamp=" + this.timestamp + ", latencyInNanoseconds=" + this.latencyInNanoseconds + '}';
    }

    private static String combineDescriptionWithLatency(long latencyTime, TimeUnit latencyUnit, Supplier<String> descriptionSupplier, int maxDescriptionLength) {
        String queryDescription = descriptionSupplier.get();
        if (queryDescription == null) {
            throw new IllegalArgumentException("Query queryDescription should not be null");
        }
        if (queryDescription.length() > maxDescriptionLength) {
            queryDescription = queryDescription.substring(0, maxDescriptionLength);
        }
        return queryDescription;
    }
}

