/*
 * Decompiled with CFR 0.152.
 */
package com.github.vlsi.gradle.checksum;

import com.github.vlsi.gradle.checksum.AppendPlatformLineKt;
import com.github.vlsi.gradle.checksum.ChecksumDependency;
import com.github.vlsi.gradle.checksum.ChecksumDependency$verifyDependencies$;
import com.github.vlsi.gradle.checksum.ChecksumDependencyKt;
import com.github.vlsi.gradle.checksum.ComponentArtifactIdentifierExtensionsKt;
import com.github.vlsi.gradle.checksum.Executors;
import com.github.vlsi.gradle.checksum.FailOn;
import com.github.vlsi.gradle.checksum.FileExtensionsKt;
import com.github.vlsi.gradle.checksum.ResolvableDependenciesExtensionsKt;
import com.github.vlsi.gradle.checksum.SignatureExtensionsKt;
import com.github.vlsi.gradle.checksum.Stopwatch;
import com.github.vlsi.gradle.checksum.model.ActualChecksums;
import com.github.vlsi.gradle.checksum.model.ChecksumLevel;
import com.github.vlsi.gradle.checksum.model.DependencyChecksum;
import com.github.vlsi.gradle.checksum.model.DependencyVerificationDb;
import com.github.vlsi.gradle.checksum.model.DependencyVerificationStore;
import com.github.vlsi.gradle.checksum.model.Id;
import com.github.vlsi.gradle.checksum.model.PgpLevel;
import com.github.vlsi.gradle.checksum.model.VerificationConfig;
import com.github.vlsi.gradle.checksum.pgp.KeyStore;
import com.github.vlsi.gradle.checksum.pgp.PgpKeyId;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.gradle.BuildAdapter;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyResolutionListener;
import org.gradle.api.artifacts.LenientConfiguration;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.initialization.Settings;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactIdentifier;
import org.gradle.internal.component.model.IvyArtifactName;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010@\u001a\u00020AJ\b\u0010B\u001a\u00020AH\u0002J\u0010\u0010C\u001a\u00020A2\u0006\u0010D\u001a\u00020:H\u0002J \u0010E\u001a\u00020\u00052\u0006\u0010F\u001a\u00020\t2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020JH\u0002J6\u0010K\u001a\u00060Lj\u0002`M*\u00060Lj\u0002`M2\u0006\u0010N\u001a\u00020\u00152\u0018\u0010O\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00150\u00170\u0016H\u0002R,\u0010\u0013\u001a \u0012\u0004\u0012\u00020\u0015\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00150\u00170\u00160\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00150!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010(\u001a&\u0012\f\u0012\n **\u0004\u0018\u00010\u00150\u0015 **\u0012\u0012\f\u0012\n **\u0004\u0018\u00010\u00150\u0015\u0018\u00010+0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010,\u001a&\u0012\f\u0012\n **\u0004\u0018\u00010\u00150\u0015 **\u0012\u0012\f\u0012\n **\u0004\u0018\u00010\u00150\u0015\u0018\u00010+0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010-\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u00104\u001a\u00020\u0015*\u0002058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0018\u00108\u001a\u000209*\u00020:8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<R\u0018\u0010=\u001a\u00020\u0015*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?\u00a8\u0006P"}, d2={"Lcom/github/vlsi/gradle/checksum/ChecksumDependency;", "", "settings", "Lorg/gradle/api/initialization/Settings;", "checksumUpdateRequested", "", "checksumPrintRequested", "checksumTimingsPrint", "computedChecksumFile", "Ljava/io/File;", "keyStore", "Lcom/github/vlsi/gradle/checksum/pgp/KeyStore;", "verificationDb", "Lcom/github/vlsi/gradle/checksum/model/DependencyVerificationDb;", "failOn", "Lcom/github/vlsi/gradle/checksum/FailOn;", "executors", "Lcom/github/vlsi/gradle/checksum/Executors;", "(Lorg/gradle/api/initialization/Settings;ZZZLjava/io/File;Lcom/github/vlsi/gradle/checksum/pgp/KeyStore;Lcom/github/vlsi/gradle/checksum/model/DependencyVerificationDb;Lcom/github/vlsi/gradle/checksum/FailOn;Lcom/github/vlsi/gradle/checksum/Executors;)V", "allViolations", "", "", "", "Lkotlin/Pair;", "Lcom/github/vlsi/gradle/checksum/model/DependencyChecksum;", "buildListener", "Lorg/gradle/BuildAdapter;", "getBuildListener", "()Lorg/gradle/BuildAdapter;", "checksumComputationTimer", "Lcom/github/vlsi/gradle/checksum/Stopwatch;", "keyResolutionTimer", "knownGoodArtifacts", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/github/vlsi/gradle/checksum/model/Id;", "lock", "Ljava/lang/Object;", "overhead", "pgpBytesSkipped", "Ljava/util/concurrent/atomic/AtomicLong;", "receivedSignatures", "", "kotlin.jvm.PlatformType", "", "requestedSignatures", "resolutionListener", "Lorg/gradle/api/artifacts/DependencyResolutionListener;", "getResolutionListener", "()Lorg/gradle/api/artifacts/DependencyResolutionListener;", "sha512BytesSkipped", "signatureResolutionTimer", "signatureVerificationTimer", "artifactKey", "Lorg/gradle/api/artifacts/component/ComponentArtifactIdentifier;", "getArtifactKey", "(Lorg/gradle/api/artifacts/component/ComponentArtifactIdentifier;)Ljava/lang/String;", "configurationContainer", "Lorg/gradle/api/artifacts/ConfigurationContainer;", "Lorg/gradle/api/artifacts/ResolvableDependencies;", "getConfigurationContainer", "(Lorg/gradle/api/artifacts/ResolvableDependencies;)Lorg/gradle/api/artifacts/ConfigurationContainer;", "lastModifiedKey", "getLastModifiedKey", "(Ljava/io/File;)Ljava/lang/String;", "buildFinishedDependencies", "", "reportViolations", "verifyDependencies", "dependencies", "verifySignature", "file", "sign", "Lorg/bouncycastle/openpgp/PGPSignature;", "publicKey", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "appendViolations", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "name", "violations", "checksum-dependency-plugin"})
public final class ChecksumDependency {
    private final ConcurrentHashMap<Id, String> knownGoodArtifacts;
    private final Map<String, List<Pair<DependencyChecksum, String>>> allViolations;
    private final Set<String> requestedSignatures;
    private final Set<String> receivedSignatures;
    private final Stopwatch checksumComputationTimer;
    private final Stopwatch keyResolutionTimer;
    private final Stopwatch signatureVerificationTimer;
    private final Stopwatch signatureResolutionTimer;
    private final AtomicLong sha512BytesSkipped;
    private final AtomicLong pgpBytesSkipped;
    private final Stopwatch overhead;
    private final Object lock;
    @NotNull
    private final DependencyResolutionListener resolutionListener;
    @NotNull
    private final BuildAdapter buildListener;
    private final Settings settings;
    private final boolean checksumUpdateRequested;
    private final boolean checksumPrintRequested;
    private final boolean checksumTimingsPrint;
    private final File computedChecksumFile;
    private final KeyStore keyStore;
    private final DependencyVerificationDb verificationDb;
    private final FailOn failOn;
    private final Executors executors;

    private final String getLastModifiedKey(File $this$lastModifiedKey) {
        return "" + $this$lastModifiedKey.length() + '_' + $this$lastModifiedKey.lastModified() + '_' + $this$lastModifiedKey.toString();
    }

    @NotNull
    public final DependencyResolutionListener getResolutionListener() {
        return this.resolutionListener;
    }

    private final ConfigurationContainer getConfigurationContainer(ResolvableDependencies $this$configurationContainer) {
        ConfigurationContainer configurationContainer2;
        boolean $i$f$debug;
        Logger $this$debug$iv;
        CharSequence charSequence;
        String string;
        Project project;
        Project rootProject;
        String string2 = $this$configurationContainer.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"path");
        String path = string2;
        configurationContainer.1 $fun$toStr$1 = configurationContainer.1.INSTANCE;
        if (!StringsKt.startsWith$default((String)path, (String)":", (boolean)false, (int)2, null)) {
            Logger logger = ChecksumDependencyKt.access$getLogger$p();
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
            Logger $this$debug$iv2 = logger;
            boolean $i$f$debug2 = false;
            if ($this$debug$iv2.isDebugEnabled()) {
                Logger logger2 = $this$debug$iv2;
                boolean bl = false;
                StringBuilder stringBuilder = new StringBuilder().append("Will resolve checksums from ").append(path).append(" via settings.buildscript (");
                ScriptHandler scriptHandler = this.settings.getBuildscript();
                Intrinsics.checkExpressionValueIsNotNull((Object)scriptHandler, (String)"settings.buildscript");
                RepositoryHandler repositoryHandler = scriptHandler.getRepositories();
                Intrinsics.checkExpressionValueIsNotNull((Object)repositoryHandler, (String)"settings.buildscript.repositories");
                String string3 = stringBuilder.append(configurationContainer.1.INSTANCE.invoke(repositoryHandler)).append(')').toString();
                logger2.debug(string3);
            }
            ScriptHandler scriptHandler = this.settings.getBuildscript();
            Intrinsics.checkExpressionValueIsNotNull((Object)scriptHandler, (String)"settings.buildscript");
            ConfigurationContainer configurationContainer3 = scriptHandler.getConfigurations();
            Intrinsics.checkExpressionValueIsNotNull((Object)configurationContainer3, (String)"settings.buildscript.configurations");
            return configurationContainer3;
        }
        Gradle gradle = this.settings.getGradle();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"settings.gradle");
        Project project2 = gradle.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"settings.gradle.rootProject");
        Project project3 = rootProject = project2;
        CharSequence bl = StringsKt.removeSuffix((String)path, (CharSequence)(':' + $this$configurationContainer.getName()));
        boolean bl2 = false;
        if (StringsKt.isBlank((CharSequence)bl)) {
            project = project3;
            boolean bl3 = false;
            string = ":";
            project3 = project;
            charSequence = string;
        } else {
            charSequence = bl;
        }
        Project project4 = project3.project((String)charSequence);
        Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"rootProject.project(path\u2026:$name\").ifBlank { \":\" })");
        Project prj = project4;
        ScriptHandler scriptHandler = prj.getBuildscript();
        Intrinsics.checkExpressionValueIsNotNull((Object)scriptHandler, (String)"prj.buildscript");
        ConfigurationContainer configurationContainer4 = scriptHandler.getConfigurations();
        Intrinsics.checkExpressionValueIsNotNull((Object)configurationContainer4, (String)"prj.buildscript.configurations");
        String string4 = $this$configurationContainer.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"name");
        if (ChecksumDependencyKt.access$hasConfiguration(configurationContainer4, string4)) {
            Logger logger = ChecksumDependencyKt.access$getLogger$p();
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
            $this$debug$iv = logger;
            $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                project = $this$debug$iv;
                boolean bl4 = false;
                StringBuilder stringBuilder = new StringBuilder().append("Will resolve checksums from ").append(path).append(" via ").append(prj).append(".buildscript.repositories = ");
                ScriptHandler scriptHandler2 = prj.getBuildscript();
                Intrinsics.checkExpressionValueIsNotNull((Object)scriptHandler2, (String)"prj.buildscript");
                RepositoryHandler repositoryHandler = scriptHandler2.getRepositories();
                Intrinsics.checkExpressionValueIsNotNull((Object)repositoryHandler, (String)"prj.buildscript.repositories");
                string = stringBuilder.append(configurationContainer.1.INSTANCE.invoke(repositoryHandler)).toString();
                project.debug(string);
            }
            ScriptHandler scriptHandler3 = prj.getBuildscript();
            Intrinsics.checkExpressionValueIsNotNull((Object)scriptHandler3, (String)"prj.buildscript");
            ConfigurationContainer configurationContainer5 = scriptHandler3.getConfigurations();
            configurationContainer2 = configurationContainer5;
            Intrinsics.checkExpressionValueIsNotNull((Object)configurationContainer5, (String)"prj.buildscript.configurations");
        } else {
            Logger logger = ChecksumDependencyKt.access$getLogger$p();
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
            $this$debug$iv = logger;
            $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                project = $this$debug$iv;
                boolean bl5 = false;
                StringBuilder stringBuilder = new StringBuilder().append("Will resolve checksums from ").append(path).append(" via ").append(prj).append(".repositories = ");
                RepositoryHandler repositoryHandler = prj.getRepositories();
                Intrinsics.checkExpressionValueIsNotNull((Object)repositoryHandler, (String)"prj.repositories");
                string = stringBuilder.append(configurationContainer.1.INSTANCE.invoke(repositoryHandler)).toString();
                project.debug(string);
            }
            ConfigurationContainer configurationContainer6 = prj.getConfigurations();
            configurationContainer2 = configurationContainer6;
            Intrinsics.checkExpressionValueIsNotNull((Object)configurationContainer6, (String)"prj.configurations");
        }
        return configurationContainer2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void verifyDependencies(ResolvableDependencies dependencies) {
        Collection collection;
        boolean bl;
        Configuration pgpConfiguration;
        Object object;
        Object object2;
        Logger logger = ChecksumDependencyKt.access$getLogger$p();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
        Logger $this$debug$iv = logger;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            object2 = $this$debug$iv;
            boolean bl2 = false;
            object = "beforeResolve " + dependencies.getPath() + '@' + dependencies.hashCode();
            object2.debug((String)object);
        }
        Gradle gradle = this.settings.getGradle();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"settings.gradle");
        Project project = gradle.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"settings.gradle.rootProject");
        DependencyHandler dependencyHandler = project.getDependencies();
        Intrinsics.checkExpressionValueIsNotNull((Object)dependencyHandler, (String)"settings.gradle.rootProject.dependencies");
        DependencyHandler dependencyFactory = dependencyHandler;
        Configuration configuration = this.getConfigurationContainer(dependencies).detachedConfiguration(new Dependency[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"dependencies.configurati\u2026r.detachedConfiguration()");
        Configuration bl2 = pgpConfiguration = configuration;
        boolean bl3 = false;
        boolean bl4 = false;
        Configuration $this$apply = bl2;
        boolean bl5 = false;
        pgpConfiguration.setCanBeConsumed(false);
        $this$apply.attributes((Action)new Action<AttributeContainer>(pgpConfiguration, dependencies){
            final /* synthetic */ Configuration $pgpConfiguration$inlined;
            final /* synthetic */ ResolvableDependencies $dependencies$inlined;
            {
                this.$pgpConfiguration$inlined = configuration;
                this.$dependencies$inlined = resolvableDependencies;
            }

            public final void execute(@NotNull AttributeContainer $this$attributes) {
                Intrinsics.checkParameterIsNotNull((Object)$this$attributes, (String)"$receiver");
                for (Attribute attrKey : this.$dependencies$inlined.getAttributes().keySet()) {
                    if (attrKey == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.attributes.Attribute<kotlin.Any>");
                    }
                    Object object = this.$dependencies$inlined.getAttributes().getAttribute(attrKey);
                    if (object == null) {
                        Intrinsics.throwNpe();
                    }
                    $this$attributes.attribute(attrKey, object);
                }
            }
        });
        Logger logger2 = ChecksumDependencyKt.access$getLogger$p();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"logger");
        Logger $this$debug$iv2 = logger2;
        boolean $i$f$debug2 = false;
        if ($this$debug$iv2.isDebugEnabled()) {
            object2 = $this$debug$iv2;
            bl = false;
            object = "afterResolve of " + this + ", " + this.hashCode() + ", will resolve signatures via" + ' ' + pgpConfiguration + '@' + pgpConfiguration.hashCode();
            object2.debug((String)object);
        }
        ArtifactView artifactView = dependencies.artifactView((Action)verifyDependencies.originalArtifacts.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactView, (String)"dependencies.artifactVie\u2026ient = true\n            }");
        ArtifactCollection artifactCollection = artifactView.getArtifacts();
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactCollection, (String)"dependencies.artifactVie\u2026e\n            }.artifacts");
        ArtifactCollection originalArtifacts2 = artifactCollection;
        bl = false;
        Map originalFiles = new LinkedHashMap();
        ActualChecksums actualChecksums = new ActualChecksums();
        bl5 = false;
        List sha512Tasks = new ArrayList();
        Iterator iterator = originalArtifacts2.iterator();
        while (iterator.hasNext()) {
            Logger $this$debug$iv3;
            ResolvedArtifactResult artifact;
            ResolvedArtifactResult resolvedArtifactResult = artifact = (ResolvedArtifactResult)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifactResult, (String)"artifact");
            ComponentArtifactIdentifier componentArtifactIdentifier = resolvedArtifactResult.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)componentArtifactIdentifier, (String)"artifact.id");
            String dependencyNotation = ComponentArtifactIdentifierExtensionsKt.getSignatureDependency(componentArtifactIdentifier);
            ComponentArtifactIdentifier componentArtifactIdentifier2 = artifact.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)componentArtifactIdentifier2, (String)"artifact.id");
            Id dependencyId = ComponentArtifactIdentifierExtensionsKt.getArtifactDependencyId(componentArtifactIdentifier2);
            File file = artifact.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"artifact.file");
            if (file.isDirectory()) {
                ChecksumDependencyKt.access$getLogger$p().warn("Resolved directory for artifact, so will skip checksum verification for it. Artifact " + dependencyId.getDependencyNotation() + ", directory: artifact.file");
                continue;
            }
            VerificationConfig verificationConfig = this.verificationDb.getConfigFor(dependencyId);
            Intrinsics.checkExpressionValueIsNotNull((Object)ChecksumDependencyKt.access$getLogger$p(), (String)"logger");
            boolean $i$f$debug3 = false;
            if ($this$debug$iv3.isDebugEnabled()) {
                object2 = $this$debug$iv3;
                boolean bl6 = false;
                object = "Adding " + dependencyNotation + " to " + pgpConfiguration;
                object2.debug((String)object);
            }
            File file2 = artifact.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"artifact.file");
            File prevFile = originalFiles.put(dependencyId, file2);
            if (prevFile != null) {
                ChecksumDependencyKt.access$getLogger$p().warn("Multiple files present for artifact " + dependencyId.getDependencyNotation() + ": " + prevFile + " and " + artifact.getFile());
            } else {
                long fileLength = artifact.getFile().length();
                File file3 = artifact.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"artifact.file");
                if (Intrinsics.areEqual((Object)this.knownGoodArtifacts.get(dependencyId), (Object)this.getLastModifiedKey(file3))) {
                    Logger logger3 = ChecksumDependencyKt.access$getLogger$p();
                    Intrinsics.checkExpressionValueIsNotNull((Object)logger3, (String)"logger");
                    if (logger3.isDebugEnabled()) {
                        ChecksumDependencyKt.access$getLogger$p().debug("Checksum/PGP verification for {} is skipped since it has already been verified in during this build, and its last modification date is still the same, file {}", (Object)dependencyId.getDependencyNotation(), (Object)artifact.getFile());
                    }
                    this.sha512BytesSkipped.addAndGet(fileLength);
                    if (verificationConfig.getPgp() == PgpLevel.NONE) continue;
                    this.pgpBytesSkipped.addAndGet(fileLength);
                    continue;
                }
                DependencyChecksum dependencyChecksum = new DependencyChecksum(dependencyId);
                boolean bl7 = false;
                boolean bl8 = false;
                DependencyChecksum dependencyChecksum2 = dependencyChecksum;
                object = dependencyId;
                object2 = actualChecksums.getDependencies();
                boolean bl9 = false;
                if (verificationConfig.getChecksum() == ChecksumLevel.NONE) {
                    this.sha512BytesSkipped.addAndGet(fileLength);
                } else {
                    void $this$apply2;
                    collection = sha512Tasks;
                    Future<?> future = this.executors.getCpu().submit(new Runnable((DependencyChecksum)$this$apply2, this, verificationConfig, fileLength, sha512Tasks, artifact, dependencyId){
                        final /* synthetic */ DependencyChecksum $this_apply;
                        final /* synthetic */ ChecksumDependency this$0;
                        final /* synthetic */ VerificationConfig $verificationConfig$inlined;
                        final /* synthetic */ long $fileLength$inlined;
                        final /* synthetic */ List $sha512Tasks$inlined;
                        final /* synthetic */ ResolvedArtifactResult $artifact$inlined;
                        final /* synthetic */ Id $dependencyId$inlined;
                        {
                            this.$this_apply = dependencyChecksum;
                            this.this$0 = checksumDependency;
                            this.$verificationConfig$inlined = verificationConfig;
                            this.$fileLength$inlined = l;
                            this.$sha512Tasks$inlined = list;
                            this.$artifact$inlined = resolvedArtifactResult;
                            this.$dependencyId$inlined = id;
                        }

                        public final void run() {
                            String checksum2 = (String)ChecksumDependency.access$getChecksumComputationTimer$p(this.this$0).invoke(this.$fileLength$inlined, (Function0)new Function0<String>(this){
                                final /* synthetic */ verifyDependencies$$inlined$apply$lambda$2 this$0;
                                {
                                    this.this$0 = var1_1;
                                    super(0);
                                }

                                @NotNull
                                public final String invoke() {
                                    ResolvedArtifactResult resolvedArtifactResult = this.this$0.$artifact$inlined;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifactResult, (String)"artifact");
                                    File file = resolvedArtifactResult.getFile();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"artifact.file");
                                    return FileExtensionsKt.sha512(file);
                                }
                            });
                            Logger logger = ChecksumDependencyKt.access$getLogger$p();
                            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
                            Logger $this$debug$iv = logger;
                            boolean $i$f$debug = false;
                            if ($this$debug$iv.isDebugEnabled()) {
                                Logger logger2 = $this$debug$iv;
                                boolean bl = false;
                                String string = "Computed SHA-512(" + this.$dependencyId$inlined.getDependencyNotation() + ") = " + checksum2;
                                logger2.debug(string);
                            }
                            this.$this_apply.getSha512().add(checksum2);
                        }
                    });
                    boolean bl10 = false;
                    collection.add(future);
                }
                Unit unit = Unit.INSTANCE;
                object2.put(object, dependencyChecksum);
            }
            if (verificationConfig.getPgp() == PgpLevel.NONE) continue;
            this.requestedSignatures.add(dependencyNotation);
            pgpConfiguration.getDependencies().add((Object)dependencyFactory.create((Object)dependencyNotation));
        }
        ResolvedConfiguration resolvedConfiguration = pgpConfiguration.getResolvedConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolvedConfiguration, (String)"pgpConfiguration.resolvedConfiguration");
        LenientConfiguration lenientConfiguration = resolvedConfiguration.getLenientConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)lenientConfiguration, (String)"pgpConfiguration.resolve\u2026tion.lenientConfiguration");
        LenientConfiguration resolve = lenientConfiguration;
        Logger logger4 = ChecksumDependencyKt.access$getLogger$p();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger4, (String)"logger");
        Logger $this$debug$iv4 = logger4;
        boolean $i$f$debug4 = false;
        if ($this$debug$iv4.isDebugEnabled()) {
            object2 = $this$debug$iv4;
            boolean bl11 = false;
            object = "Resolve " + pgpConfiguration + '@' + pgpConfiguration.hashCode();
            object2.debug((String)object);
        }
        Object object3 = Stopwatch.invoke$default(this.signatureResolutionTimer, 0L, (Function0)new Function0<Set<ResolvedArtifact>>(resolve){
            final /* synthetic */ LenientConfiguration $resolve;

            @NotNull
            public final Set<ResolvedArtifact> invoke() {
                return this.$resolve.getArtifacts();
            }
            {
                this.$resolve = lenientConfiguration;
                super(0);
            }
        }, 1, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"signatureResolutionTimer { resolve.artifacts }");
        Set checksumArtifacts2 = (Set)object3;
        Logger logger5 = ChecksumDependencyKt.access$getLogger$p();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger5, (String)"logger");
        Logger $this$debug$iv5 = logger5;
        boolean $i$f$debug5 = false;
        if ($this$debug$iv5.isDebugEnabled()) {
            object2 = $this$debug$iv5;
            boolean bl12 = false;
            object = "Resolved " + checksumArtifacts2.size() + " checksums";
            object2.debug((String)object);
        }
        $i$f$debug5 = false;
        Map keysToVerify = new LinkedHashMap();
        Iterator bl12 = checksumArtifacts2.iterator();
        while (bl12.hasNext()) {
            ResolvedArtifact art;
            ResolvedArtifact resolvedArtifact = art = (ResolvedArtifact)bl12.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifact, (String)"art");
            File file = resolvedArtifact.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"art.file");
            PGPSignatureList signatures = SignatureExtensionsKt.toSignatureList(file);
            keysToVerify.put(art, signatures);
            Iterator bl6 = signatures.iterator();
            while (bl6.hasNext()) {
                PGPSignature sign;
                PGPSignature pGPSignature = sign = (PGPSignature)bl6.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)pGPSignature, (String)"sign");
                PgpKeyId.Short signKey = SignatureExtensionsKt.getPgpShortKeyId(pGPSignature);
                if (!this.verificationDb.isIgnored(signKey)) continue;
                Logger logger6 = ChecksumDependencyKt.access$getLogger$p();
                StringBuilder stringBuilder = new StringBuilder().append("Public key ").append(signKey).append(" is ignored via <ignored-keys>, so ");
                ComponentArtifactIdentifier componentArtifactIdentifier = art.getId();
                Intrinsics.checkExpressionValueIsNotNull((Object)componentArtifactIdentifier, (String)"art.id");
                logger6.debug(stringBuilder.append(ComponentArtifactIdentifierExtensionsKt.getArtifactDependency(componentArtifactIdentifier)).append(" is assumed to be not signed with that key").toString());
            }
        }
        Stopwatch.invoke$default(this.keyResolutionTimer, 0L, (Function0)new Function0<Unit>(this, checksumArtifacts2, actualChecksums, originalFiles){
            final /* synthetic */ ChecksumDependency this$0;
            final /* synthetic */ Set $checksumArtifacts;
            final /* synthetic */ ActualChecksums $actualChecksums;
            final /* synthetic */ Map $originalFiles;

            public final void invoke() {
                boolean bl = false;
                List verifyPgpTasks = new ArrayList<E>();
                for (ResolvedArtifact art : this.$checksumArtifacts) {
                    Logger $this$debug$iv;
                    Map<Id, DependencyChecksum> map = this.$actualChecksums.getDependencies();
                    ResolvedArtifact resolvedArtifact = art;
                    Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifact, (String)"art");
                    ComponentArtifactIdentifier componentArtifactIdentifier = resolvedArtifact.getId();
                    Intrinsics.checkExpressionValueIsNotNull((Object)componentArtifactIdentifier, (String)"art.id");
                    if (map.get(ComponentArtifactIdentifierExtensionsKt.getArtifactDependencyId(componentArtifactIdentifier)) == null) {
                        Intrinsics.throwNpe();
                    }
                    ComponentArtifactIdentifier componentArtifactIdentifier2 = art.getId();
                    Intrinsics.checkExpressionValueIsNotNull((Object)componentArtifactIdentifier2, (String)"art.id");
                    String signatureDependency = ComponentArtifactIdentifierExtensionsKt.getSignatureDependency(componentArtifactIdentifier2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)ChecksumDependencyKt.access$getLogger$p(), (String)"logger");
                    boolean $i$f$debug = false;
                    if ($this$debug$iv.isDebugEnabled()) {
                        Logger logger = $this$debug$iv;
                        boolean bl2 = false;
                        String string = "Resolved signature " + signatureDependency;
                        logger.debug(string);
                    }
                    ChecksumDependency.access$getReceivedSignatures$p(this.this$0).add(signatureDependency);
                    File file = art.getFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"art.file");
                    Iterator iterator = SignatureExtensionsKt.toSignatureList(file).iterator();
                    while (iterator.hasNext()) {
                        DependencyChecksum dependencyChecksum;
                        CompletionStage verifySignature2;
                        PGPSignature sign;
                        PGPSignature pGPSignature = sign = (PGPSignature)iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)pGPSignature, (String)"sign");
                        PgpKeyId.Short signKey = SignatureExtensionsKt.getPgpShortKeyId(pGPSignature);
                        if (ChecksumDependency.access$getVerificationDb$p(this.this$0).isIgnored(signKey)) {
                            Logger logger = ChecksumDependencyKt.access$getLogger$p();
                            StringBuilder stringBuilder = new StringBuilder().append("Public key ").append(signKey).append(" is ignored via <ignored-keys>, so ");
                            ComponentArtifactIdentifier componentArtifactIdentifier3 = art.getId();
                            Intrinsics.checkExpressionValueIsNotNull((Object)componentArtifactIdentifier3, (String)"art.id");
                            logger.debug(stringBuilder.append(ComponentArtifactIdentifierExtensionsKt.getArtifactDependency(componentArtifactIdentifier3)).append(" is assumed to be not signed with that key").toString());
                            continue;
                        }
                        CompletionStage completionStage = verifySignature2 = ChecksumDependency.access$getKeyStore$p(this.this$0).getKeyAsync(signKey, signatureDependency, ChecksumDependency.access$getExecutors$p(this.this$0)).thenAcceptAsync(new Consumer<List<? extends PGPPublicKey>>(this, signKey, art, dependencyChecksum, sign){
                            final /* synthetic */ verifyDependencies.8 this$0;
                            final /* synthetic */ PgpKeyId.Short $signKey;
                            final /* synthetic */ ResolvedArtifact $art;
                            final /* synthetic */ DependencyChecksum $dependencyChecksum;
                            final /* synthetic */ PGPSignature $sign;

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * WARNING - void declaration
                             */
                            public final void accept(List<? extends PGPPublicKey> publicKeys) {
                                if (publicKeys.isEmpty()) {
                                    Logger logger = ChecksumDependencyKt.access$getLogger$p();
                                    StringBuilder stringBuilder = new StringBuilder().append("Public key ").append(this.$signKey).append(" is not found. The key was used to sign ");
                                    ResolvedArtifact resolvedArtifact = this.$art;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifact, (String)"art");
                                    ComponentArtifactIdentifier componentArtifactIdentifier = resolvedArtifact.getId();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)componentArtifactIdentifier, (String)"art.id");
                                    logger.warn(stringBuilder.append(ComponentArtifactIdentifierExtensionsKt.getArtifactDependency(componentArtifactIdentifier)).append('.').append(" Please ask dependency author to publish the PGP key otherwise signature verification is not possibles").toString());
                                    ChecksumDependency.access$getVerificationDb$p(this.this$0.this$0).ignoreKey(this.$signKey);
                                    return;
                                }
                                for (PGPPublicKey pGPPublicKey : publicKeys) {
                                    void $this$log$iv;
                                    String string;
                                    Logger logger;
                                    Logger $this$debug$iv;
                                    PgpKeyId.Full fullKeyId = SignatureExtensionsKt.getPgpFullKeyId(pGPPublicKey);
                                    Intrinsics.checkExpressionValueIsNotNull((Object)ChecksumDependencyKt.access$getLogger$p(), (String)"logger");
                                    boolean $i$f$debug = false;
                                    if ($this$debug$iv.isDebugEnabled()) {
                                        logger = $this$debug$iv;
                                        boolean bl = false;
                                        StringBuilder stringBuilder = new StringBuilder().append("Verifying signature ").append(fullKeyId).append(" for ");
                                        ResolvedArtifact resolvedArtifact = this.$art;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifact, (String)"art");
                                        ComponentArtifactIdentifier componentArtifactIdentifier = resolvedArtifact.getId();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)componentArtifactIdentifier, (String)"art.id");
                                        string = stringBuilder.append(ComponentArtifactIdentifierExtensionsKt.getArtifactDependency(componentArtifactIdentifier)).toString();
                                        logger.debug(string);
                                    }
                                    V v = this.this$0.$originalFiles.get(this.$dependencyChecksum.getId());
                                    if (v == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    File file = (File)v;
                                    boolean validSignature2 = (Boolean)ChecksumDependency.access$getSignatureVerificationTimer$p(this.this$0.this$0).invoke(file.length(), (Function0)new Function0<Boolean>(this, file, pGPPublicKey){
                                        final /* synthetic */ verifyDependencies.verifySignature.1 this$0;
                                        final /* synthetic */ File $file;
                                        final /* synthetic */ PGPPublicKey $publicKey;

                                        public final boolean invoke() {
                                            ChecksumDependency checksumDependency = this.this$0.this$0.this$0;
                                            PGPSignature pGPSignature = this.this$0.$sign;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)pGPSignature, (String)"sign");
                                            return ChecksumDependency.access$verifySignature(checksumDependency, this.$file, pGPSignature, this.$publicKey);
                                        }
                                        {
                                            this.this$0 = var1_1;
                                            this.$file = file;
                                            this.$publicKey = pGPPublicKey;
                                            super(0);
                                        }
                                    });
                                    if (validSignature2) {
                                        DependencyChecksum bl = this.$dependencyChecksum;
                                        boolean bl2 = false;
                                        boolean bl3 = false;
                                        synchronized (bl) {
                                            boolean bl4 = false;
                                            Collection collection = this.$dependencyChecksum.getPgpKeys();
                                            PgpKeyId.Full full = fullKeyId;
                                            boolean bl5 = false;
                                            collection.add(full);
                                            Unit unit = Unit.INSTANCE;
                                        }
                                    }
                                    Intrinsics.checkExpressionValueIsNotNull((Object)ChecksumDependencyKt.access$getLogger$p(), (String)"logger");
                                    LogLevel level$iv = validSignature2 ? LogLevel.DEBUG : LogLevel.LIFECYCLE;
                                    boolean $i$f$log = false;
                                    if (!$this$log$iv.isEnabled(level$iv)) continue;
                                    string = level$iv;
                                    logger = $this$log$iv;
                                    boolean bl = false;
                                    StringBuilder stringBuilder = new StringBuilder().append(validSignature2 ? "OK" : "KO").append(": verification of ");
                                    ResolvedArtifact resolvedArtifact = this.$art;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifact, (String)"art");
                                    ComponentArtifactIdentifier componentArtifactIdentifier = resolvedArtifact.getId();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)componentArtifactIdentifier, (String)"art.id");
                                    String string2 = stringBuilder.append(ComponentArtifactIdentifierExtensionsKt.getArtifactDependency(componentArtifactIdentifier)).append(" via ").append(fullKeyId).toString();
                                    logger.log((LogLevel)string, string2);
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                this.$signKey = shortVal;
                                this.$art = resolvedArtifact;
                                this.$dependencyChecksum = dependencyChecksum;
                                this.$sign = pGPSignature;
                            }
                        }, (Executor)ChecksumDependency.access$getExecutors$p(this.this$0).getCpu());
                        Intrinsics.checkExpressionValueIsNotNull((Object)completionStage, (String)"verifySignature");
                        verifyPgpTasks.add(completionStage);
                    }
                }
                Throwable ex = null;
                for (CompletableFuture task : verifyPgpTasks) {
                    try {
                        task.join();
                    }
                    catch (CompletionException e) {
                        if (ex == null) {
                            ex = e;
                            continue;
                        }
                        ExceptionsKt.addSuppressed((Throwable)ex, (Throwable)e);
                    }
                }
                if (ex != null) {
                    throw ex;
                }
            }
            {
                this.this$0 = checksumDependency;
                this.$checksumArtifacts = set;
                this.$actualChecksums = actualChecksums;
                this.$originalFiles = map;
                super(0);
            }
        }, 1, null);
        for (Future sha512Task : sha512Tasks) {
            sha512Task.get();
        }
        Iterable $this$forEach$iv = actualChecksums.getDependencies().values();
        boolean $i$f$forEach222 = false;
        for (Object element$iv2 : $this$forEach$iv) {
            Logger $this$debug$iv6;
            DependencyChecksum it = (DependencyChecksum)element$iv2;
            boolean bl13 = false;
            if (!it.getPgpKeys().isEmpty() || !it.getSha512().isEmpty()) continue;
            Object v = originalFiles.get(it.getId());
            if (v == null) {
                Intrinsics.throwNpe();
            }
            File file = (File)v;
            String checksum2 = (String)this.checksumComputationTimer.invoke(file.length(), (Function0)new Function0<String>(file){
                final /* synthetic */ File $file;

                @NotNull
                public final String invoke() {
                    return FileExtensionsKt.sha512(this.$file);
                }
                {
                    this.$file = file;
                    super(0);
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)ChecksumDependencyKt.access$getLogger$p(), (String)"logger");
            boolean $i$f$debug6 = false;
            if ($this$debug$iv6.isDebugEnabled()) {
                collection = $this$debug$iv6;
                boolean bl14 = false;
                String string = "Computed SHA-512(" + it.getId().getDependencyNotation() + ") = " + checksum2;
                collection.debug(string);
            }
            it.getSha512().add(checksum2);
        }
        for (UnresolvedDependency unresolved : resolve.getUnresolvedModuleDependencies()) {
            Logger logger7 = ChecksumDependencyKt.access$getLogger$p();
            String string = "Unable to resolve PGP signature for " + unresolved;
            UnresolvedDependency unresolvedDependency = unresolved;
            Intrinsics.checkExpressionValueIsNotNull((Object)unresolvedDependency, (String)"unresolved");
            logger7.lifecycle(string, unresolvedDependency.getProblem());
        }
        List<Pair<DependencyChecksum, String>> violations = this.verificationDb.verify(actualChecksums);
        Pair<DependencyChecksum, String> $i$f$forEach222 = violations;
        boolean signatures = false;
        if (!$i$f$forEach222.isEmpty()) {
            $i$f$forEach222 = this.lock;
            signatures = false;
            boolean element$iv2 = false;
            synchronized ($i$f$forEach222) {
                Object object4;
                void $this$getOrPut$iv;
                boolean bl15 = false;
                Map<String, List<Pair<DependencyChecksum, String>>> bl13 = this.allViolations;
                String string = dependencies.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dependencies.path");
                String key$iv = string;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl16 = false;
                    boolean bl17 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object4 = answer$iv;
                } else {
                    object4 = value$iv;
                }
                ((List)object4).addAll((Collection)violations);
                if (this.failOn == FailOn.FIRST_ERROR) {
                    this.reportViolations();
                }
                Unit element$iv2 = Unit.INSTANCE;
            }
            for (Pair<DependencyChecksum, String> $i$f$forEach222 : violations) {
                DependencyChecksum dependencyChecksum = (DependencyChecksum)$i$f$forEach222.component1();
                actualChecksums.getDependencies().remove(dependencyChecksum.getId());
            }
        }
        Map<Id, DependencyChecksum> $this$forEach$iv2 = actualChecksums.getDependencies();
        boolean $i$f$forEach = false;
        Map<Id, DependencyChecksum> map = $this$forEach$iv2;
        boolean bl18 = false;
        Iterator<Map.Entry<Id, DependencyChecksum>> iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Id, DependencyChecksum> element$iv;
            Map.Entry<Id, DependencyChecksum> $dstr$id$_u24__u24 = element$iv = iterator2.next();
            boolean bl19 = false;
            Map.Entry<Id, DependencyChecksum> entry = $dstr$id$_u24__u24;
            boolean bl20 = false;
            Id id = entry.getKey();
            Map map2 = this.knownGoodArtifacts;
            Object v = originalFiles.get(id);
            if (v == null) {
                Intrinsics.throwNpe();
            }
            map2.put(id, this.getLastModifiedKey((File)v));
        }
    }

    private final boolean verifySignature(File file, PGPSignature sign, PGPPublicKey publicKey) {
        try {
            sign.init((PGPContentVerifierBuilderProvider)new BcPGPContentVerifierBuilderProvider(), publicKey);
        }
        catch (Throwable e) {
            ExceptionsKt.addSuppressed((Throwable)e, (Throwable)new Throwable("Verifying " + file + " with key " + SignatureExtensionsKt.getPgpFullKeyId(publicKey) + ", sign " + SignatureExtensionsKt.getPgpShortKeyId(sign)));
            throw e;
        }
        FilesKt.forEachBlock((File)file, (Function2)((Function2)new Function2<byte[], Integer, Unit>(sign){
            final /* synthetic */ PGPSignature $sign;

            public final void invoke(@NotNull byte[] block, int size) {
                Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
                this.$sign.update(block, 0, size);
            }
            {
                this.$sign = pGPSignature;
                super(2);
            }
        }));
        return sign.verify();
    }

    /*
     * WARNING - void declaration
     */
    private final StringBuilder appendViolations(StringBuilder $this$appendViolations, String name, List<Pair<DependencyChecksum, String>> violations) {
        Object value$iv$iv;
        boolean $i$f$getOrPut;
        Map.Entry<String, List> $this$getOrPut$iv$iv;
        void $this$groupByTo$iv;
        Object object = $this$appendViolations;
        boolean bl = false;
        if (object.length() > 0) {
            $this$appendViolations.append("\n");
        }
        StringBuilder stringBuilder = $this$appendViolations.append("Checksum/PGP violations detected on resolving configuration ");
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"append(\"Checksum/PGP vio\u2026esolving configuration \")");
        AppendPlatformLineKt.appendPlatformLine(stringBuilder, name);
        object = violations;
        Map destination$iv = new TreeMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv : $this$groupByTo$iv) {
            Object object2;
            Pair it = (Pair)element$iv;
            boolean bl2 = false;
            String key$iv = (String)it.getSecond();
            $this$getOrPut$iv$iv = destination$iv;
            $i$f$getOrPut = false;
            value$iv$iv = $this$getOrPut$iv$iv.get(key$iv);
            if (value$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv.put(key$iv, answer$iv$iv);
                object2 = answer$iv$iv;
            } else {
                object2 = value$iv$iv;
            }
            List list$iv = (List)object2;
            it = (Pair)element$iv;
            List list = list$iv;
            boolean bl4 = false;
            DependencyChecksum dependencyChecksum = (DependencyChecksum)it.getFirst();
            list.add(dependencyChecksum);
        }
        Map $this$forEach$iv = destination$iv;
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        boolean bl5 = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void violation;
            Map.Entry<String, List> element$iv;
            Map.Entry<String, List> $dstr$violation$artifacts = element$iv = iterator.next();
            boolean bl6 = false;
            $this$getOrPut$iv$iv = $dstr$violation$artifacts;
            $i$f$getOrPut = false;
            value$iv$iv = (String)$this$getOrPut$iv$iv.getKey();
            $this$getOrPut$iv$iv = $dstr$violation$artifacts;
            $i$f$getOrPut = false;
            List artifacts = (List)$this$getOrPut$iv$iv.getValue();
            StringBuilder stringBuilder2 = $this$appendViolations.append("  ").append((String)violation);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(\"  \").append(violation)");
            AppendPlatformLineKt.appendPlatformLine(stringBuilder2, ":");
            Sequence $this$forEach$iv2 = SequencesKt.sorted((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)artifacts), (Function1)appendViolations.3.1.INSTANCE));
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl7 = false;
                StringBuilder stringBuilder3 = $this$appendViolations.append("    ");
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3, (String)"append(\"    \")");
                AppendPlatformLineKt.appendPlatformLine(stringBuilder3, it);
            }
        }
        return $this$appendViolations;
    }

    /*
     * WARNING - void declaration
     */
    private final void reportViolations() {
        if (this.allViolations.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        Map<String, List<Pair<DependencyChecksum, String>>> $this$forEach$iv = this.allViolations;
        boolean $i$f$forEach = false;
        Map<String, List<Pair<DependencyChecksum, String>>> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, List<Pair<DependencyChecksum, String>>>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void configuration;
            Map.Entry<String, List<Pair<DependencyChecksum, String>>> element$iv;
            Map.Entry<String, List<Pair<DependencyChecksum, String>>> $dstr$configuration$violations = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<String, List<Pair<DependencyChecksum, String>>> entry = $dstr$configuration$violations;
            boolean bl3 = false;
            String string = entry.getKey();
            entry = $dstr$configuration$violations;
            bl3 = false;
            List<Pair<DependencyChecksum, String>> violations = entry.getValue();
            this.appendViolations(sb, (String)configuration, violations);
        }
        if (this.failOn == FailOn.FIRST_ERROR) {
            AppendPlatformLineKt.appendPlatformLine(sb, "\nThere might be more checksum violations, however, current configuration specifies the build to fail on the first violation.");
            sb.append("You might use the following properties:\n  * -PchecksumIgnore temporary disables checksum-dependency-plugin (e.g. to try new dependencies)");
            if (!this.checksumUpdateRequested) {
                sb.append("\n  * -PchecksumUpdate updates checksum.xml and it will fail after the first violation so you can review the diff");
            }
            AppendPlatformLineKt.appendPlatformLine(sb, "\n  * -PchecksumUpdateAll (insecure) updates checksum.xml with all the new discovered checksums\n  * -PchecksumFailOn=build_finish (insecure) It will postpone the failure till the build finish");
            sb.append("It will collect all the violations, however untrusted code might be executed (e.g. from a plugin)");
        }
        sb.append("\nYou can find updated checksum.xml file at " + this.computedChecksumFile + '.');
        if (!this.checksumUpdateRequested) {
            sb.append("\nYou might add -PchecksumUpdate to update root checksum.xml file.");
        }
        throw (Throwable)new GradleException(sb.toString());
    }

    @NotNull
    public final BuildAdapter getBuildListener() {
        return this.buildListener;
    }

    public final void buildFinishedDependencies() {
        LogLevel logLevel;
        buildFinishedDependencies.1 $fun$mib$1 = buildFinishedDependencies.1.INSTANCE;
        long sha512Time = this.checksumComputationTimer.getElapsed();
        long keyTime = this.keyResolutionTimer.getElapsed();
        long ascTime = this.signatureResolutionTimer.getElapsed();
        long pgpTime = this.signatureVerificationTimer.getElapsed();
        long overheadTime = this.overhead.getElapsed();
        boolean showProfile = overheadTime > (long)1000 || this.checksumTimingsPrint;
        boolean printDetailedTimings = overheadTime > (long)20000 || this.checksumTimingsPrint;
        ChecksumDependencyKt.access$getLogger$p().log(showProfile ? LogLevel.LIFECYCLE : LogLevel.INFO, "checksum-dependency elapsed time: " + overheadTime + "ms, configurations processed: " + this.overhead.getStarts() / 2 + (!printDetailedTimings ? " (add -PchecksumTimingsPrint to print detailed timings)" : ""));
        ChecksumDependencyKt.access$getLogger$p().log(printDetailedTimings ? LogLevel.LIFECYCLE : LogLevel.DEBUG, "    SHA-512 computation time: " + sha512Time + "ms (goes in parallel, it might exceed wall-clock time), files processed: " + this.checksumComputationTimer.getStarts() + ", processed: " + $fun$mib$1.invoke(this.checksumComputationTimer.getBytes()) + "MiB, skipped: " + $fun$mib$1.invoke(this.sha512BytesSkipped.get()) + "MiB");
        ChecksumDependencyKt.access$getLogger$p().log(printDetailedTimings ? LogLevel.LIFECYCLE : LogLevel.DEBUG, "    PGP signature resolution time: " + ascTime + "ms (wall-clock), resolution requests: " + this.signatureResolutionTimer.getStarts() + ", signatures resolved: " + this.receivedSignatures.size());
        ChecksumDependencyKt.access$getLogger$p().log(printDetailedTimings ? LogLevel.LIFECYCLE : LogLevel.DEBUG, "    PGP key resolution time: " + keyTime + "ms (wall-clock), resolution requests: " + this.keyResolutionTimer.getStarts() + ", download time: " + this.keyStore.getDownloadTimer().getElapsed() + "ms (goes in parallel, it might exceed wall-clock time), keys downloaded: " + this.keyStore.getDownloadTimer().getStarts());
        ChecksumDependencyKt.access$getLogger$p().log(printDetailedTimings ? LogLevel.LIFECYCLE : LogLevel.DEBUG, "        PGP signature verification time: " + pgpTime + "ms (goes in parallel, it might exceed wall-clock time), files processed: " + this.signatureVerificationTimer.getStarts() + ", processed: " + $fun$mib$1.invoke(this.signatureVerificationTimer.getBytes()) + "MiB, skipped: " + $fun$mib$1.invoke(this.pgpBytesSkipped.get()) + "MiB");
        File file = this.computedChecksumFile.getParentFile();
        if (file != null) {
            file.mkdirs();
        }
        LogLevel logLevel2 = logLevel = this.checksumUpdateRequested ? LogLevel.LIFECYCLE : LogLevel.INFO;
        if (this.verificationDb.getHasUpdates() || !this.checksumUpdateRequested) {
            ChecksumDependencyKt.access$getLogger$p().log(logLevel, "Saving updated checksum.xml as {}", new Object[]{this.computedChecksumFile.getAbsolutePath()});
            DependencyVerificationStore.save(this.computedChecksumFile, this.verificationDb.getUpdatedVerification());
        } else {
            ChecksumDependencyKt.access$getLogger$p().log(logLevel, "{} is up to date", new Object[]{this.computedChecksumFile.getAbsolutePath()});
        }
        if (this.checksumPrintRequested && this.verificationDb.getHasUpdates()) {
            ChecksumDependencyKt.access$getLogger$p().lifecycle("Updated " + this.computedChecksumFile.getName() + " is\n" + FilesKt.readText$default((File)this.computedChecksumFile, null, (int)1, null));
        }
    }

    private final String getArtifactKey(ComponentArtifactIdentifier $this$artifactKey) {
        String id = StringsKt.replace$default((String)$this$artifactKey.getComponentIdentifier().toString(), (char)':', (char)'/', (boolean)false, (int)4, null);
        if (!($this$artifactKey instanceof DefaultModuleComponentArtifactIdentifier)) {
            return id;
        }
        IvyArtifactName ivyArtifactName = ((DefaultModuleComponentArtifactIdentifier)$this$artifactKey).getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)ivyArtifactName, (String)"name");
        if (ivyArtifactName.getClassifier() == null) {
            IvyArtifactName ivyArtifactName2 = ((DefaultModuleComponentArtifactIdentifier)$this$artifactKey).getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)ivyArtifactName2, (String)"name");
            if (Intrinsics.areEqual((Object)ivyArtifactName2.getExtension(), (Object)"jar")) {
                return id;
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(id).append('/');
        IvyArtifactName ivyArtifactName3 = ((DefaultModuleComponentArtifactIdentifier)$this$artifactKey).getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)ivyArtifactName3, (String)"name");
        String string = ivyArtifactName3.getClassifier();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            sb.append(it);
        }
        IvyArtifactName ivyArtifactName4 = ((DefaultModuleComponentArtifactIdentifier)$this$artifactKey).getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)ivyArtifactName4, (String)"name");
        if (Intrinsics.areEqual((Object)ivyArtifactName4.getExtension(), (Object)"jar") ^ true) {
            StringBuilder stringBuilder = sb.append('/');
            IvyArtifactName ivyArtifactName5 = ((DefaultModuleComponentArtifactIdentifier)$this$artifactKey).getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)ivyArtifactName5, (String)"name");
            stringBuilder.append(ivyArtifactName5.getExtension());
        }
        String string3 = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"sb.toString()");
        return string3;
    }

    public ChecksumDependency(@NotNull Settings settings, boolean checksumUpdateRequested, boolean checksumPrintRequested, boolean checksumTimingsPrint, @NotNull File computedChecksumFile, @NotNull KeyStore keyStore, @NotNull DependencyVerificationDb verificationDb, @NotNull FailOn failOn2, @NotNull Executors executors) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        Intrinsics.checkParameterIsNotNull((Object)computedChecksumFile, (String)"computedChecksumFile");
        Intrinsics.checkParameterIsNotNull((Object)keyStore, (String)"keyStore");
        Intrinsics.checkParameterIsNotNull((Object)verificationDb, (String)"verificationDb");
        Intrinsics.checkParameterIsNotNull((Object)((Object)failOn2), (String)"failOn");
        Intrinsics.checkParameterIsNotNull((Object)executors, (String)"executors");
        this.settings = settings;
        this.checksumUpdateRequested = checksumUpdateRequested;
        this.checksumPrintRequested = checksumPrintRequested;
        this.checksumTimingsPrint = checksumTimingsPrint;
        this.computedChecksumFile = computedChecksumFile;
        this.keyStore = keyStore;
        this.verificationDb = verificationDb;
        this.failOn = failOn2;
        this.executors = executors;
        this.knownGoodArtifacts = new ConcurrentHashMap();
        boolean bl = false;
        this.allViolations = new LinkedHashMap();
        bl = false;
        this.requestedSignatures = Collections.synchronizedSet(new LinkedHashSet());
        bl = false;
        this.receivedSignatures = Collections.synchronizedSet(new LinkedHashSet());
        this.checksumComputationTimer = new Stopwatch();
        this.keyResolutionTimer = new Stopwatch();
        this.signatureVerificationTimer = new Stopwatch();
        this.signatureResolutionTimer = new Stopwatch();
        this.sha512BytesSkipped = new AtomicLong();
        this.pgpBytesSkipped = new AtomicLong();
        this.overhead = new Stopwatch();
        this.lock = new Object();
        this.resolutionListener = new DependencyResolutionListener(this){
            final /* synthetic */ ChecksumDependency this$0;

            public void beforeResolve(@NotNull ResolvableDependencies dependencies) {
                String string;
                Logger logger;
                Intrinsics.checkParameterIsNotNull((Object)dependencies, (String)"dependencies");
                Logger logger2 = ChecksumDependencyKt.access$getLogger$p();
                Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"logger");
                Logger $this$debug$iv = logger2;
                boolean $i$f$debug = false;
                if ($this$debug$iv.isDebugEnabled()) {
                    logger = $this$debug$iv;
                    boolean bl = false;
                    string = "beforeResolve " + dependencies.getPath() + '@' + dependencies.hashCode();
                    logger.debug(string);
                }
                if (((Boolean)Stopwatch.invoke$default(ChecksumDependency.access$getOverhead$p(this.this$0), 0L, (Function0)new Function0<Boolean>(dependencies){
                    final /* synthetic */ ResolvableDependencies $dependencies;

                    public final boolean invoke() {
                        return ResolvableDependenciesExtensionsKt.getContainOnlySignatures(this.$dependencies);
                    }
                    {
                        this.$dependencies = resolvableDependencies;
                        super(0);
                    }
                }, 1, null)).booleanValue()) {
                    Logger logger3 = ChecksumDependencyKt.access$getLogger$p();
                    Intrinsics.checkExpressionValueIsNotNull((Object)logger3, (String)"logger");
                    $this$debug$iv = logger3;
                    $i$f$debug = false;
                    if ($this$debug$iv.isDebugEnabled()) {
                        logger = $this$debug$iv;
                        boolean bl = false;
                        string = "The set of resolved dependencies " + dependencies.getPath() + " includes only .asc artifacts, so the resolution is implicitly trusted";
                        logger.debug(string);
                    }
                    return;
                }
                dependencies.afterResolve((Action)new Action<ResolvableDependencies>(this, dependencies){
                    final /* synthetic */ resolutionListener.1 this$0;
                    final /* synthetic */ ResolvableDependencies $dependencies;

                    public final void execute(@NotNull ResolvableDependencies $this$afterResolve) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$afterResolve, (String)"$receiver");
                        Stopwatch.invoke$default(ChecksumDependency.access$getOverhead$p(this.this$0.this$0), 0L, (Function0)new Function0<Unit>(this){
                            final /* synthetic */ resolutionListener.beforeResolve.4 this$0;

                            public final void invoke() {
                                ChecksumDependency.access$verifyDependencies(this.this$0.this$0.this$0, this.this$0.$dependencies);
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        }, 1, null);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$dependencies = resolvableDependencies;
                    }
                });
            }

            public void afterResolve(@NotNull ResolvableDependencies dependencies) {
                Intrinsics.checkParameterIsNotNull((Object)dependencies, (String)"dependencies");
            }
            {
                this.this$0 = this$0;
            }
        };
        this.buildListener = new BuildAdapter(this){
            final /* synthetic */ ChecksumDependency this$0;

            public void buildFinished(@NotNull BuildResult result) {
                String it;
                boolean $i$f$forEach;
                Iterable $this$forEach$iv;
                boolean bl;
                String string;
                Logger logger;
                Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
                this.this$0.buildFinishedDependencies();
                if (ChecksumDependency.access$getRequestedSignatures$p(this.this$0).size() == ChecksumDependency.access$getReceivedSignatures$p(this.this$0).size()) {
                    Logger logger2 = ChecksumDependencyKt.access$getLogger$p();
                    Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"logger");
                    Logger $this$debug$iv = logger2;
                    boolean $i$f$debug = false;
                    if ($this$debug$iv.isDebugEnabled()) {
                        logger = $this$debug$iv;
                        boolean bl2 = false;
                        string = "Resolved " + ChecksumDependency.access$getReceivedSignatures$p(this.this$0).size() + " of " + ChecksumDependency.access$getRequestedSignatures$p(this.this$0).size() + " signatures";
                        logger.debug(string);
                    }
                } else {
                    Logger logger3 = ChecksumDependencyKt.access$getLogger$p();
                    Intrinsics.checkExpressionValueIsNotNull((Object)logger3, (String)"logger");
                    Logger $this$info$iv = logger3;
                    boolean $i$f$info = false;
                    if ($this$info$iv.isInfoEnabled()) {
                        logger = $this$info$iv;
                        bl = false;
                        string = "Resolved " + ChecksumDependency.access$getReceivedSignatures$p(this.this$0).size() + " of " + ChecksumDependency.access$getRequestedSignatures$p(this.this$0).size() + " signatures";
                        logger.info(string);
                    }
                }
                Set set = ChecksumDependency.access$getRequestedSignatures$p(this.this$0);
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"requestedSignatures");
                Set set2 = ChecksumDependency.access$getReceivedSignatures$p(this.this$0);
                Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"receivedSignatures");
                Set missing = SetsKt.minus((Set)set, (Iterable)set2);
                Collection $i$f$info = missing;
                bl = false;
                if (!$i$f$info.isEmpty()) {
                    Logger logger4 = ChecksumDependencyKt.access$getLogger$p();
                    Intrinsics.checkExpressionValueIsNotNull((Object)logger4, (String)"logger");
                    Logger $this$info$iv = logger4;
                    boolean $i$f$info2 = false;
                    if ($this$info$iv.isInfoEnabled()) {
                        logger = $this$info$iv;
                        boolean bl3 = false;
                        string = "Missing " + missing.size() + " signatures:";
                        logger.info(string);
                    }
                    $this$forEach$iv = CollectionsKt.sorted((Iterable)missing);
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (String)element$iv;
                        boolean bl4 = false;
                        ChecksumDependencyKt.access$getLogger$p().info("  " + it);
                    }
                }
                Logger logger5 = ChecksumDependencyKt.access$getLogger$p();
                Intrinsics.checkExpressionValueIsNotNull((Object)logger5, (String)"logger");
                if (logger5.isDebugEnabled() || ChecksumDependency.access$getRequestedSignatures$p(this.this$0).size() != ChecksumDependency.access$getReceivedSignatures$p(this.this$0).size()) {
                    Logger logger6 = ChecksumDependencyKt.access$getLogger$p();
                    Intrinsics.checkExpressionValueIsNotNull((Object)logger6, (String)"logger");
                    Logger $this$debug$iv = logger6;
                    boolean $i$f$debug = false;
                    if ($this$debug$iv.isDebugEnabled()) {
                        logger = $this$debug$iv;
                        boolean bl5 = false;
                        string = "Resolved " + ChecksumDependency.access$getReceivedSignatures$p(this.this$0).size() + " signatures:";
                        logger.debug(string);
                    }
                    Set set3 = ChecksumDependency.access$getReceivedSignatures$p(this.this$0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)set3, (String)"receivedSignatures");
                    $this$forEach$iv = CollectionsKt.sorted((Iterable)set3);
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (String)element$iv;
                        boolean bl6 = false;
                        ChecksumDependencyKt.access$getLogger$p().debug("  " + it);
                    }
                }
                if (ChecksumDependency.access$getFailOn$p(this.this$0) == FailOn.BUILD_FINISH) {
                    ChecksumDependency.access$reportViolations(this.this$0);
                }
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    public static final /* synthetic */ Stopwatch access$getChecksumComputationTimer$p(ChecksumDependency $this) {
        return $this.checksumComputationTimer;
    }

    public static final /* synthetic */ Set access$getReceivedSignatures$p(ChecksumDependency $this) {
        return $this.receivedSignatures;
    }

    public static final /* synthetic */ DependencyVerificationDb access$getVerificationDb$p(ChecksumDependency $this) {
        return $this.verificationDb;
    }

    public static final /* synthetic */ KeyStore access$getKeyStore$p(ChecksumDependency $this) {
        return $this.keyStore;
    }

    public static final /* synthetic */ Executors access$getExecutors$p(ChecksumDependency $this) {
        return $this.executors;
    }

    public static final /* synthetic */ Stopwatch access$getSignatureVerificationTimer$p(ChecksumDependency $this) {
        return $this.signatureVerificationTimer;
    }

    public static final /* synthetic */ boolean access$verifySignature(ChecksumDependency $this, File file, PGPSignature sign, PGPPublicKey publicKey) {
        return $this.verifySignature(file, sign, publicKey);
    }

    public static final /* synthetic */ Stopwatch access$getOverhead$p(ChecksumDependency $this) {
        return $this.overhead;
    }

    public static final /* synthetic */ void access$verifyDependencies(ChecksumDependency $this, ResolvableDependencies dependencies) {
        $this.verifyDependencies(dependencies);
    }

    public static final /* synthetic */ Set access$getRequestedSignatures$p(ChecksumDependency $this) {
        return $this.requestedSignatures;
    }

    public static final /* synthetic */ FailOn access$getFailOn$p(ChecksumDependency $this) {
        return $this.failOn;
    }

    public static final /* synthetic */ void access$reportViolations(ChecksumDependency $this) {
        $this.reportViolations();
    }
}

