/*
 * Decompiled with CFR 0.152.
 */
package com.github.vlsi.gradle.checksum;

import com.github.vlsi.gradle.checksum.ChecksumDependency;
import com.github.vlsi.gradle.checksum.ChecksumDependencyPlugin;
import com.github.vlsi.gradle.checksum.ChecksumDependencyPluginKt;
import com.github.vlsi.gradle.checksum.Executors;
import com.github.vlsi.gradle.checksum.FailOn;
import com.github.vlsi.gradle.checksum.model.ChecksumLevel;
import com.github.vlsi.gradle.checksum.model.DependencyVerification;
import com.github.vlsi.gradle.checksum.model.DependencyVerificationDb;
import com.github.vlsi.gradle.checksum.model.DependencyVerificationStore;
import com.github.vlsi.gradle.checksum.model.PgpLevel;
import com.github.vlsi.gradle.checksum.model.VerificationConfig;
import com.github.vlsi.gradle.checksum.pgp.KeyDownloader;
import com.github.vlsi.gradle.checksum.pgp.KeyStore;
import com.github.vlsi.gradle.checksum.pgp.Retry;
import com.github.vlsi.gradle.checksum.pgp.RetrySchedule;
import com.github.vlsi.gradle.checksum.pgp.Timeouts;
import java.io.File;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.BuildAdapter;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.diagnostics.DependencyReportTask;
import org.gradle.kotlin.dsl.ExtraPropertiesExtensionsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0014\u0010\u0007\u001a\u00020\b*\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0002J\f\u0010\u000b\u001a\u00020\u0005*\u00020\fH\u0002J\"\u0010\r\u001a\u00020\n*\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fH\u0002J\u001c\u0010\r\u001a\u00020\n*\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\f\u0010\u0010\u001a\u00020\u0005*\u00020\fH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/github/vlsi/gradle/checksum/ChecksumDependencyPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/initialization/Settings;", "()V", "apply", "", "settings", "boolProperty", "", "name", "", "createAddAllDependenciesTask", "Lorg/gradle/api/Project;", "property", "default", "Lkotlin/Function0;", "registerAddAllDependenciesTask", "checksum-dependency-plugin"})
public class ChecksumDependencyPlugin
implements Plugin<Settings> {
    private final String property(Settings $this$property, String name, String string) {
        String string2;
        Settings settings = $this$property.getSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)settings, (String)"settings");
        ExtraPropertiesExtension extraPropertiesExtension = ExtraPropertiesExtensionsKt.getExtra((ExtensionAware)((ExtensionAware)settings));
        boolean bl = false;
        boolean bl2 = false;
        ExtraPropertiesExtension it = extraPropertiesExtension;
        boolean bl3 = false;
        if (it.has(name)) {
            Object object = it.get(name);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            string2 = (String)object;
        } else {
            string2 = string;
        }
        return string2;
    }

    private final String property(Settings $this$property, String name, Function0<String> function0) {
        String string;
        Settings settings = $this$property.getSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)settings, (String)"settings");
        ExtraPropertiesExtension extraPropertiesExtension = ExtraPropertiesExtensionsKt.getExtra((ExtensionAware)((ExtensionAware)settings));
        boolean bl = false;
        boolean bl2 = false;
        ExtraPropertiesExtension it = extraPropertiesExtension;
        boolean bl3 = false;
        if (it.has(name)) {
            Object object = it.get(name);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            string = (String)object;
        } else {
            string = (String)function0.invoke();
        }
        return string;
    }

    private final boolean boolProperty(Settings $this$boolProperty, String name) {
        boolean bl;
        Settings settings = $this$boolProperty.getSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)settings, (String)"settings");
        ExtraPropertiesExtension extraPropertiesExtension = ExtraPropertiesExtensionsKt.getExtra((ExtensionAware)((ExtensionAware)settings));
        boolean bl2 = false;
        boolean bl3 = false;
        ExtraPropertiesExtension it = extraPropertiesExtension;
        boolean bl4 = false;
        if (it.has(name)) {
            Object object = it.get(name);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
            }
            bl = !StringsKt.equals((String)((String)object), (String)"false", (boolean)true);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public void apply(@NotNull Settings settings) {
        Collection<URI> collection;
        void $this$mapTo$iv$iv2;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        boolean checksumIgnore = this.boolProperty(settings, "checksumIgnore");
        if (checksumIgnore) {
            ChecksumDependencyPluginKt.access$getLogger$p().lifecycle("checksum-dependency-plugin is disabled since checksumIgnore property is present");
            return;
        }
        String checksumIgnoreOnTask = this.property(settings, "checksumIgnoreOnTask", "dependencyUpdates");
        String checksumFileName = this.property(settings, "checksum.xml", "checksum.xml");
        File checksums = new File(settings.getRootDir(), checksumFileName);
        String buildDir = this.property(settings, "checksumBuildDir", "build/checksum");
        File cachedKeysTempRoot = new File(settings.getRootDir(), this.property(settings, "checksumCachedPgpKeysTempDir", "build/checksum/key-cache-temp"));
        File buildFolder = new File(settings.getRootDir(), buildDir);
        String string = this.property(settings, "checksumCachedPgpKeysDir", "%{ROOT_DIR}/gradle/checksum-dependency-plugin/cached-pgp-keys");
        File file = settings.getRootDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"settings.rootDir");
        String string2 = file.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"settings.rootDir.absolutePath");
        String string3 = StringsKt.replace$default((String)string, (String)"%{ROOT_DIR}", (String)string2, (boolean)false, (int)4, null);
        boolean bl = false;
        boolean bl2 = false;
        String it = string3;
        boolean bl3 = false;
        File cachedKeysRoot = new File(it);
        boolean checksumUpdateAll = this.boolProperty(settings, "checksumUpdateAll");
        boolean checksumUpdate = checksumUpdateAll || this.boolProperty(settings, "checksumUpdate");
        File computedChecksumFile = checksumUpdate ? checksums : new File(buildFolder, "checksum.xml");
        boolean checksumPrint = this.boolProperty(settings, "checksumPrint");
        boolean checksumTimingsPrint = this.boolProperty(settings, "checksumTimingsPrint");
        String string4 = this.property(settings, "checksumFailOn", (Function0<String>)((Function0)new Function0<String>(checksumUpdate, checksums, checksumUpdateAll){
            final /* synthetic */ boolean $checksumUpdate;
            final /* synthetic */ File $checksums;
            final /* synthetic */ boolean $checksumUpdateAll;

            @NotNull
            public final String invoke() {
                String string;
                if (this.$checksumUpdate && !this.$checksums.exists()) {
                    ChecksumDependencyPluginKt.access$getLogger$p().lifecycle("Checksums file is missing (" + this.$checksums + "), and checksum update was requested (-PchecksumUpdate). Will refrain from failing the build on the first checksum/pgp violation");
                    string = "NEVER";
                } else if (this.$checksumUpdateAll) {
                    ChecksumDependencyPluginKt.access$getLogger$p().lifecycle("-PchecksumUpdateAll is specified, so the build won't fail in case of the checksum mismatch");
                    string = "NEVER";
                } else {
                    string = "FIRST_ERROR";
                }
                return string;
            }
            {
                this.$checksumUpdate = bl;
                this.$checksums = file;
                this.$checksumUpdateAll = bl2;
                super(0);
            }
        }));
        boolean bl4 = false;
        String string5 = string4;
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toUpperCase()");
        string4 = string6;
        bl4 = false;
        boolean bl5 = false;
        String it2 = string4;
        boolean bl6 = false;
        try {
            object = FailOn.valueOf(it2);
        }
        catch (IllegalArgumentException e) {
            throw (Throwable)new GradleException('\'' + it2 + "' is not supported for 'checksumFailOn' property. Please use one of " + ArraysKt.toList((Object[])FailOn.values()));
        }
        FailOn failOn2 = object;
        String pgpKeyserver = this.property(settings, "pgpKeyserver", "https://keyserver.ubuntu.com,https://keys.openpgp.org");
        it2 = this.property(settings, "pgpConnectTimeout", "5");
        boolean bl7 = false;
        long pgpConnectTimeout = Long.parseLong(it2);
        object = this.property(settings, "pgpReadTimeout", "20");
        boolean bl8 = false;
        long pgpReadTimeout = Long.parseLong((String)object);
        String string7 = this.property(settings, "pgpMinLoggableTimeout", "4");
        boolean bl9 = false;
        long pgpMinLoggableTimeout = Long.parseLong(string7);
        String string8 = this.property(settings, "pgpRetryCount", "40");
        boolean bl10 = false;
        int pgpRetryCount = Integer.parseInt(string8);
        String string9 = this.property(settings, "pgpInitialRetryDelay", "100");
        boolean bl11 = false;
        long pgpInitialRetryDelay = Long.parseLong(string9);
        String string10 = this.property(settings, "pgpMaximumRetryDelay", "10000");
        boolean bl12 = false;
        long pgpMaximumRetryDelay = Long.parseLong(string10);
        String string11 = this.property(settings, "pgpResolutionTimeout", "30");
        boolean bl13 = false;
        long pgpResolutionTimeout = Long.parseLong(string11);
        String string12 = this.property(settings, "checksumCpuThreads", String.valueOf(ForkJoinPool.getCommonPoolParallelism()));
        boolean bl14 = false;
        int checksumCpuThreads = Integer.parseInt(string12);
        String string13 = this.property(settings, "checksumIoThreads", "50");
        boolean bl15 = false;
        int checksumIoThreads = Integer.parseInt(string13);
        Object $this$map$iv = StringsKt.split$default((CharSequence)pgpKeyserver, (char[])new char[]{','}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it3;
            String string14 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl16 = false;
            URI uRI = new URI((String)it3);
            collection.add(uRI);
        }
        collection = (List)destination$iv$iv;
        RetrySchedule retrySchedule = new RetrySchedule(pgpInitialRetryDelay, pgpMaximumRetryDelay);
        Duration duration = Duration.ofSeconds(pgpResolutionTimeout);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofSeconds(pgpResolutionTimeout)");
        Duration duration2 = Duration.ofSeconds(pgpMinLoggableTimeout);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ofSeconds(pgpMinLoggableTimeout)");
        $this$map$iv = duration2;
        Duration $i$f$map22 = duration;
        int $this$mapTo$iv$iv2 = pgpRetryCount;
        destination$iv$iv = retrySchedule;
        Object object2 = $this$map$iv;
        int n = $this$mapTo$iv$iv2;
        Object object3 = destination$iv$iv;
        Duration duration3 = $i$f$map22;
        List list = collection;
        Retry retry = new Retry(list, duration3, (RetrySchedule)object3, n, (Duration)object2);
        Duration duration4 = Duration.ofSeconds(pgpConnectTimeout);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration4, (String)"Duration.ofSeconds(pgpConnectTimeout)");
        Duration duration5 = Duration.ofSeconds(pgpReadTimeout);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration5, (String)"Duration.ofSeconds(pgpReadTimeout)");
        Timeouts timeouts = new Timeouts(duration4, duration5);
        Retry retry2 = retry;
        KeyDownloader keyDownloader = new KeyDownloader(retry2, timeouts);
        KeyStore keyStore = new KeyStore(cachedKeysRoot, cachedKeysTempRoot, keyDownloader);
        DependencyVerification verification = checksums.exists() ? DependencyVerificationStore.load(checksums, checksumUpdate) : new DependencyVerification(new VerificationConfig(PgpLevel.GROUP, ChecksumLevel.NONE));
        DependencyVerificationDb verificationDb = new DependencyVerificationDb(verification);
        Executors executors = new Executors("checksum-dependency", checksumCpuThreads, checksumIoThreads);
        ChecksumDependency checksum2 = new ChecksumDependency(settings, checksumUpdate, checksumPrint, checksumTimingsPrint, computedChecksumFile, keyStore, verificationDb, failOn2, executors);
        settings.getGradle().addListener((Object)checksum2.getResolutionListener());
        settings.getGradle().addBuildListener((BuildListener)checksum2.getBuildListener());
        settings.getGradle().addBuildListener((BuildListener)new BuildAdapter(settings, checksum2, checksumIgnoreOnTask, executors){
            final /* synthetic */ Settings $settings;
            final /* synthetic */ ChecksumDependency $checksum;
            final /* synthetic */ String $checksumIgnoreOnTask;
            final /* synthetic */ Executors $executors;

            private final void unregisterChecksumListeners() {
                this.$settings.getGradle().removeListener((Object)this.$checksum.getResolutionListener());
                this.$settings.getGradle().removeListener((Object)this.$checksum.getBuildListener());
            }

            public void projectsEvaluated(@NotNull Gradle gradle) {
                Intrinsics.checkParameterIsNotNull((Object)gradle, (String)"gradle");
                if (StringsKt.isBlank((CharSequence)this.$checksumIgnoreOnTask)) {
                    return;
                }
                CharSequence charSequence = this.$checksumIgnoreOnTask;
                Regex regex = new Regex("\\s*,\\s*");
                int n = 0;
                boolean bl = false;
                Set tasks = CollectionsKt.toSet((Iterable)regex.split(charSequence, n));
                gradle.getTaskGraph().whenReady((Action)new Action<TaskExecutionGraph>(this, tasks){
                    final /* synthetic */ apply.1 this$0;
                    final /* synthetic */ Set $tasks;

                    public final void execute(@NotNull TaskExecutionGraph $this$whenReady) {
                        Object v2;
                        block2: {
                            Intrinsics.checkParameterIsNotNull((Object)$this$whenReady, (String)"$receiver");
                            List list = $this$whenReady.getAllTasks();
                            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"allTasks");
                            Iterable $this$firstOrNull$iv = list;
                            boolean $i$f$firstOrNull = false;
                            for (T element$iv : $this$firstOrNull$iv) {
                                Task it = (Task)element$iv;
                                boolean bl = false;
                                Task task = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)task, (String)"it");
                                if (!this.$tasks.contains(task.getName())) continue;
                                v2 = element$iv;
                                break block2;
                            }
                            v2 = null;
                        }
                        Task stopTask = v2;
                        if (stopTask != null) {
                            ChecksumDependencyPluginKt.access$getLogger$p().lifecycle("checksum-dependency is disabled because task execution graph contains task " + stopTask + ',' + " and checksumIgnoreOnTask is set to '" + this.this$0.$checksumIgnoreOnTask + '\'');
                            apply.1.access$unregisterChecksumListeners(this.this$0);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$tasks = set;
                    }
                });
            }

            public void buildFinished(@NotNull BuildResult result) {
                Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
                this.unregisterChecksumListeners();
                this.$executors.getCpu().shutdown();
                this.$executors.getIo().shutdown();
            }
            {
                this.$settings = $captured_local_variable$0;
                this.$checksum = $captured_local_variable$1;
                this.$checksumIgnoreOnTask = $captured_local_variable$2;
                this.$executors = $captured_local_variable$3;
            }

            public static final /* synthetic */ void access$unregisterChecksumListeners(apply.1 $this) {
                $this.unregisterChecksumListeners();
            }
        });
        String string15 = this.property(settings, "allDependenciesEnabled", "true");
        boolean bl17 = false;
        String string16 = string15;
        boolean bl18 = false;
        boolean allDeps = Boolean.parseBoolean(string16);
        if (allDeps) {
            settings.getGradle().rootProject((Action)new Action<Project>(this){
                final /* synthetic */ ChecksumDependencyPlugin this$0;

                public final void execute(@NotNull Project $this$rootProject) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$rootProject, (String)"$receiver");
                    if (GradleVersion.current().compareTo(GradleVersion.version((String)"4.8")) >= 0) {
                        ChecksumDependencyPlugin.access$registerAddAllDependenciesTask(this.this$0, $this$rootProject);
                    } else {
                        ChecksumDependencyPlugin.access$createAddAllDependenciesTask(this.this$0, $this$rootProject);
                    }
                }
                {
                    this.this$0 = checksumDependencyPlugin;
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void registerAddAllDependenciesTask(Project $this$registerAddAllDependenciesTask) {
        void type$iv;
        void name$iv;
        void $this$register$iv;
        TaskContainer taskContainer = $this$registerAddAllDependenciesTask.getTasks();
        Intrinsics.checkExpressionValueIsNotNull((Object)taskContainer, (String)"tasks");
        TaskContainer taskContainer2 = taskContainer;
        String string = "allDependencies";
        Class<DependencyReportTask> clazz = DependencyReportTask.class;
        Action configurationAction$iv = registerAddAllDependenciesTask.1.INSTANCE;
        boolean $i$f$register = false;
        Intrinsics.checkExpressionValueIsNotNull((Object)$this$register$iv.register((String)name$iv, (Class)type$iv, configurationAction$iv), (String)"`register`(`name`, `type\u2026a, `configurationAction`)");
        $this$registerAddAllDependenciesTask.subprojects((Action)registerAddAllDependenciesTask.2.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final void createAddAllDependenciesTask(Project $this$createAddAllDependenciesTask) {
        void type$iv;
        void name$iv;
        void $this$create$iv;
        TaskContainer taskContainer = $this$createAddAllDependenciesTask.getTasks();
        Intrinsics.checkExpressionValueIsNotNull((Object)taskContainer, (String)"tasks");
        TaskContainer taskContainer2 = taskContainer;
        String string = "allDependencies";
        Class<DependencyReportTask> clazz = DependencyReportTask.class;
        Action configuration$iv = createAddAllDependenciesTask.1.INSTANCE;
        boolean $i$f$create = false;
        Intrinsics.checkExpressionValueIsNotNull((Object)$this$create$iv.create((String)name$iv, (Class)type$iv, configuration$iv), (String)"`create`(`name`, `type`.java, `configuration`)");
        $this$createAddAllDependenciesTask.subprojects((Action)createAddAllDependenciesTask.2.INSTANCE);
    }

    public static final /* synthetic */ void access$registerAddAllDependenciesTask(ChecksumDependencyPlugin $this, Project $this$access_u24registerAddAllDependenciesTask) {
        $this.registerAddAllDependenciesTask($this$access_u24registerAddAllDependenciesTask);
    }

    public static final /* synthetic */ void access$createAddAllDependenciesTask(ChecksumDependencyPlugin $this, Project $this$access_u24createAddAllDependenciesTask) {
        $this.createAddAllDependenciesTask($this$access_u24createAddAllDependenciesTask);
    }
}

