/*
 * Decompiled with CFR 0.152.
 */
package com.github.vlsi.gradle.checksum.model;

import com.github.vlsi.gradle.checksum.model.ActualChecksums;
import com.github.vlsi.gradle.checksum.model.ChecksumLevel;
import com.github.vlsi.gradle.checksum.model.DependencyChecksum;
import com.github.vlsi.gradle.checksum.model.DependencyVerification;
import com.github.vlsi.gradle.checksum.model.Id;
import com.github.vlsi.gradle.checksum.model.PgpLevel;
import com.github.vlsi.gradle.checksum.model.VerificationConfig;
import com.github.vlsi.gradle.checksum.pgp.PgpKeyId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014J \u0010\u0016\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00180\u00172\u0006\u0010\u001b\u001a\u00020\u001cR\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/github/vlsi/gradle/checksum/model/DependencyVerificationDb;", "", "verification", "Lcom/github/vlsi/gradle/checksum/model/DependencyVerification;", "(Lcom/github/vlsi/gradle/checksum/model/DependencyVerification;)V", "<set-?>", "", "hasUpdates", "getHasUpdates", "()Z", "updatedVerification", "getUpdatedVerification", "()Lcom/github/vlsi/gradle/checksum/model/DependencyVerification;", "getConfigFor", "Lcom/github/vlsi/gradle/checksum/model/VerificationConfig;", "id", "Lcom/github/vlsi/gradle/checksum/model/Id;", "ignoreKey", "", "key", "Lcom/github/vlsi/gradle/checksum/pgp/PgpKeyId;", "isIgnored", "verify", "", "Lkotlin/Pair;", "Lcom/github/vlsi/gradle/checksum/model/DependencyChecksum;", "", "actualChecksums", "Lcom/github/vlsi/gradle/checksum/model/ActualChecksums;", "Companion", "checksum-dependency-plugin"})
public final class DependencyVerificationDb {
    private boolean hasUpdates;
    @NotNull
    private final DependencyVerification updatedVerification;
    private final DependencyVerification verification;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    public final boolean getHasUpdates() {
        return this.hasUpdates;
    }

    @NotNull
    public final DependencyVerification getUpdatedVerification() {
        return this.updatedVerification;
    }

    @NotNull
    public final VerificationConfig getConfigFor(@NotNull Id id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Object object = this.verification.getDependencies().get(id);
        if (object == null || (object = ((DependencyChecksum)object).getVerificationConfig()) == null) {
            object = this.verification.getDefaultVerificationConfig();
        }
        return object;
    }

    public final boolean isIgnored(@NotNull PgpKeyId key2) {
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        return this.verification.getIgnoredKeys().contains(key2);
    }

    public final void ignoreKey(@NotNull PgpKeyId key2) {
        Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        Collection collection = this.updatedVerification.getIgnoredKeys();
        boolean bl = false;
        collection.add(key2);
        this.hasUpdates = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pair<DependencyChecksum, String>> verify(@NotNull ActualChecksums actualChecksums) {
        Intrinsics.checkParameterIsNotNull((Object)actualChecksums, (String)"actualChecksums");
        boolean bl = false;
        List violations = new ArrayList();
        boolean bl2 = false;
        List details = new ArrayList();
        Object object = actualChecksums.getDependencies();
        boolean bl3 = false;
        Iterator<Map.Entry<Id, DependencyChecksum>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean moduleConfigRequired;
            boolean bl4;
            String string;
            Collection collection;
            void id;
            Map.Entry<Id, DependencyChecksum> entry;
            Map.Entry<Id, DependencyChecksum> entry2 = entry = iterator.next();
            boolean bl5 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl5 = false;
            DependencyChecksum dependencyChecksum = entry2.getValue();
            details.clear();
            DependencyChecksum expected = this.verification.getDependencies().get(id);
            Object object2 = expected;
            if (object2 == null || (object2 = ((DependencyChecksum)object2).getVerificationConfig()) == null) {
                object2 = this.verification.getDefaultVerificationConfig();
            }
            Object verificationConfig = object2;
            PgpLevel pgpResult = PgpLevel.NONE;
            ChecksumLevel checksumResult = ChecksumLevel.NONE;
            if (dependencyChecksum.getPgpKeys().isEmpty() && ((VerificationConfig)verificationConfig).getPgp().compareTo((Enum)PgpLevel.NONE) > 0) {
                collection = details;
                string = "No PGP signature (.asc file) found for artifact";
                bl4 = false;
                collection.add(string);
            } else {
                Unit unit;
                if (this.verification.groupKeys(id.getGroup()) != null) {
                    Collection $this$debug$iv;
                    boolean bl6;
                    Set<PgpKeyId.Full> groupKeys;
                    block45: {
                        Set<PgpKeyId.Full> set;
                        boolean bl7 = false;
                        boolean bl8 = false;
                        groupKeys = set;
                        boolean bl9 = false;
                        Iterable $this$any$iv = groupKeys;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl6 = false;
                        } else {
                            for (Object element$iv22 : $this$any$iv) {
                                PgpKeyId.Full it = (PgpKeyId.Full)element$iv22;
                                boolean bl10 = false;
                                if (!dependencyChecksum.getPgpKeys().contains(it)) continue;
                                bl6 = true;
                                break block45;
                            }
                            bl6 = false;
                        }
                    }
                    boolean pass = bl6;
                    Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
                    boolean $i$f$debug2 = false;
                    if ($this$debug$iv.isDebugEnabled()) {
                        Logger logger = $this$debug$iv;
                        boolean bl11 = false;
                        String string2 = (pass ? "OK" : "KO") + " PGP group verification for " + id + '.' + " The file was signed via " + dependencyChecksum.getPgpKeys() + ',' + " trusted keys for group " + id.getGroup() + " are " + groupKeys;
                        logger.debug(string2);
                    }
                    if (pass) {
                        pgpResult = PgpLevel.GROUP;
                    } else if (expected == null && ((VerificationConfig)verificationConfig).getPgp() == PgpLevel.GROUP) {
                        $this$debug$iv = details;
                        String $i$f$debug2 = "Trusted PGP keys for group " + id.getGroup() + " are " + groupKeys + ", " + (dependencyChecksum.getPgpKeys().isEmpty() ? "however no signature found" : "however artifact is signed by " + dependencyChecksum.getPgpKeys() + " only");
                        boolean bl11 = false;
                        $this$debug$iv.add($i$f$debug2);
                    }
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (details.isEmpty() && ((VerificationConfig)verificationConfig).getPgp() == PgpLevel.GROUP) {
                    Collection collection2 = details;
                    String string3 = "No trusted PGP keys are configured for group " + id.getGroup();
                    boolean bl12 = false;
                    collection2.add(string3);
                }
            }
            if (expected == null) {
                if (((VerificationConfig)verificationConfig).getPgp().compareTo((Enum)PgpLevel.MODULE) >= 0) {
                    collection = details;
                    string = "No trusted PGP key is configured for artifact";
                    bl4 = false;
                    collection.add(string);
                }
                if (((VerificationConfig)verificationConfig).getChecksum().compareTo((Enum)ChecksumLevel.NONE) > 0) {
                    collection = details;
                    string = "No trusted SHA512 signature is configured for artifact";
                    bl4 = false;
                    collection.add(string);
                }
            } else {
                String string4;
                Logger logger;
                collection = expected.getPgpKeys();
                boolean bl13 = false;
                if (!collection.isEmpty()) {
                    Collection $this$debug$iv;
                    boolean bl14;
                    block46: {
                        Iterable $this$any$iv = expected.getPgpKeys();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl14 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                PgpKeyId.Full it = (PgpKeyId.Full)element$iv;
                                boolean bl15 = false;
                                if (!dependencyChecksum.getPgpKeys().contains(it)) continue;
                                bl14 = true;
                                break block46;
                            }
                            bl14 = false;
                        }
                    }
                    boolean pass = bl14;
                    Intrinsics.checkExpressionValueIsNotNull((Object)DependencyVerificationDb.logger, (String)"logger");
                    boolean $i$f$debug3 = false;
                    if ($this$debug$iv.isDebugEnabled()) {
                        logger = $this$debug$iv;
                        boolean bl16 = false;
                        string4 = (pass ? "OK" : "KO") + " PGP module verification for " + id + '.' + " The file was signed via " + dependencyChecksum.getPgpKeys() + ',' + " trusted keys for module are " + expected.getPgpKeys();
                        logger.debug(string4);
                    }
                    if (pass) {
                        pgpResult = PgpLevel.MODULE;
                    } else {
                        $this$debug$iv = details;
                        String $i$f$debug3 = "Expecting one of the following PGP signatures: " + expected.getPgpKeys() + ", but artifact is signed by " + dependencyChecksum.getPgpKeys() + " only";
                        boolean bl16 = false;
                        $this$debug$iv.add($i$f$debug3);
                    }
                }
                Collection pass = expected.getSha512();
                boolean $this$debug$iv = false;
                if (!pass.isEmpty()) {
                    Set unexpectedSha512 = SetsKt.minus(dependencyChecksum.getSha512(), (Iterable)expected.getSha512());
                    boolean pass2 = unexpectedSha512.isEmpty();
                    if (pass2) {
                        Logger $this$debug$iv2;
                        checksumResult = ChecksumLevel.MODULE;
                        Intrinsics.checkExpressionValueIsNotNull((Object)DependencyVerificationDb.logger, (String)"logger");
                        boolean $i$f$debug = false;
                        if ($this$debug$iv2.isDebugEnabled()) {
                            logger = $this$debug$iv2;
                            boolean bl17 = false;
                            string4 = "OK SHA512 verification for " + id + '.' + " Checksum is " + dependencyChecksum.getSha512();
                            logger.debug(string4);
                        }
                    } else {
                        boolean bl18;
                        Logger $this$debug$iv3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)DependencyVerificationDb.logger, (String)"logger");
                        boolean $i$f$debug22 = false;
                        if ($this$debug$iv3.isDebugEnabled()) {
                            logger = $this$debug$iv3;
                            bl18 = false;
                            string4 = "KO SHA512 verification for " + id + '.' + " Checksum is " + dependencyChecksum.getSha512() + ", expected checksums are " + expected.getSha512();
                            logger.debug(string4);
                        }
                        Collection collection3 = details;
                        String $i$f$debug22 = "Actual checksum is " + dependencyChecksum.getSha512() + ", however expected one of " + expected.getSha512();
                        bl18 = false;
                        collection3.add($i$f$debug22);
                    }
                }
            }
            if (((VerificationConfig)verificationConfig).getPgp() == PgpLevel.GROUP) {
                Iterable $this$forEach$iv = dependencyChecksum.getPgpKeys();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PgpKeyId.Full it = (PgpKeyId.Full)element$iv;
                    boolean bl19 = false;
                    DependencyVerification bl15 = this.updatedVerification;
                    boolean bl11 = false;
                    boolean element$iv22 = false;
                    synchronized (bl15) {
                        Object element$iv22;
                        boolean bl20 = false;
                        if (this.updatedVerification.add(id.getGroup(), it)) {
                            this.hasUpdates = true;
                        }
                        element$iv22 = Unit.INSTANCE;
                    }
                }
            }
            boolean bl21 = moduleConfigRequired = dependencyChecksum.getPgpKeys().isEmpty() || ((VerificationConfig)verificationConfig).getChecksum().compareTo((Enum)ChecksumLevel.MODULE) >= 0;
            if (moduleConfigRequired) {
                Object object3 = dependencyChecksum.getSha512();
                boolean bl22 = false;
                if (!object3.isEmpty()) {
                    object3 = this.updatedVerification;
                    bl22 = false;
                    boolean bl23 = false;
                    synchronized (object3) {
                        Object object4;
                        void $this$getOrPut$iv;
                        boolean bl24 = false;
                        Map<Id, DependencyChecksum> bl19 = this.updatedVerification.getDependencies();
                        void key$iv = id;
                        boolean $i$f$getOrPut = false;
                        Object value$iv = $this$getOrPut$iv.get(key$iv);
                        if (value$iv == null) {
                            boolean bl25 = false;
                            DependencyChecksum answer$iv = new DependencyChecksum((Id)id);
                            $this$getOrPut$iv.put(key$iv, answer$iv);
                            object4 = answer$iv;
                        } else {
                            object4 = value$iv;
                        }
                        Object v = object4;
                        boolean bl26 = false;
                        boolean bl27 = false;
                        DependencyChecksum $this$apply = (DependencyChecksum)v;
                        boolean bl28 = false;
                        if ($this$apply.getSha512().addAll((Collection<String>)dependencyChecksum.getSha512())) {
                            this.hasUpdates = true;
                        }
                        if ($this$apply.getPgpKeys().addAll((Collection<PgpKeyId.Full>)dependencyChecksum.getPgpKeys())) {
                            this.hasUpdates = true;
                        }
                        DependencyChecksum dependencyChecksum2 = (DependencyChecksum)v;
                    }
                }
            }
            if (pgpResult.compareTo((Enum)((VerificationConfig)verificationConfig).getPgp()) >= 0 && checksumResult.compareTo((Enum)((VerificationConfig)verificationConfig).getChecksum()) >= 0) continue;
            Collection collection4 = violations;
            Pair pair = TuplesKt.to((Object)dependencyChecksum, (Object)CollectionsKt.joinToString$default((Iterable)details, null, null, null, (int)0, null, null, (int)63, null));
            boolean bl29 = false;
            collection4.add(pair);
        }
        return violations;
    }

    public DependencyVerificationDb(@NotNull DependencyVerification verification) {
        Intrinsics.checkParameterIsNotNull((Object)verification, (String)"verification");
        this.verification = verification;
        this.updatedVerification = this.verification.deepClone();
    }

    static {
        Companion = new Companion(null);
        logger = Logging.getLogger(DependencyVerificationDb.class);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/github/vlsi/gradle/checksum/model/DependencyVerificationDb$Companion;", "", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/gradle/api/logging/Logger;", "checksum-dependency-plugin"})
    public static final class Companion {
        public final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

