/*
 * Decompiled with CFR 0.152.
 */
package com.github.vlsi.gradle.checksum.model;

import com.github.vlsi.gradle.checksum.model.ChecksumLevel;
import com.github.vlsi.gradle.checksum.model.DependencyChecksum;
import com.github.vlsi.gradle.checksum.model.DependencyVerification;
import com.github.vlsi.gradle.checksum.model.DependencyVerificationStore;
import com.github.vlsi.gradle.checksum.model.DependencyVerificationStore$save$;
import com.github.vlsi.gradle.checksum.model.DependencyVerificationStoreKt;
import com.github.vlsi.gradle.checksum.model.Id;
import com.github.vlsi.gradle.checksum.model.PgpLevel;
import com.github.vlsi.gradle.checksum.model.VerificationConfig;
import com.github.vlsi.gradle.checksum.pgp.PgpKeyId;
import groovy.util.XmlSlurper;
import groovy.util.slurpersupport.GPathResult;
import groovy.xml.MarkupBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.gradle.api.GradleException;
import org.gradle.kotlin.dsl.GroovyBuilderScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0007H\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0007H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/github/vlsi/gradle/checksum/model/DependencyVerificationStore;", "", "()V", "VERSION_1", "", "VERSION_2", "load", "Lcom/github/vlsi/gradle/checksum/model/DependencyVerification;", "file", "Ljava/io/File;", "skipUnparseable", "", "input", "Ljava/io/InputStream;", "fileName", "save", "", "verification", "out", "Ljava/io/Writer;", "checksum-dependency-plugin"})
public final class DependencyVerificationStore {
    @NotNull
    public static final String VERSION_1 = "1";
    @NotNull
    public static final String VERSION_2 = "2";
    @NotNull
    public static final DependencyVerificationStore INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final DependencyVerification load(@NotNull File file, boolean skipUnparseable) {
        DependencyVerification dependencyVerification;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Object object = file;
        boolean bl = false;
        object = new FileInputStream((File)object);
        bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)object;
            boolean bl3 = false;
            InputStream inputStream = it;
            String string = file.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.absolutePath");
            dependencyVerification = DependencyVerificationStore.load(inputStream, string, skipUnparseable);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return dependencyVerification;
    }

    @JvmStatic
    @NotNull
    public static final DependencyVerification load(@NotNull InputStream input, @NotNull String fileName, boolean skipUnparseable) {
        ChecksumLevel checksumLevel;
        PgpLevel pgpLevel;
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        GPathResult xml = new XmlSlurper().parse(input);
        if (Intrinsics.areEqual((Object)xml.name(), (Object)"dependency-verification") ^ true) {
            throw (Throwable)new GradleException("Root tag should be dependency-verification, actual one is " + xml.name());
        }
        GPathResult gPathResult = xml;
        Intrinsics.checkExpressionValueIsNotNull((Object)gPathResult, (String)"xml");
        String string = DependencyVerificationStoreKt.access$requiredAttr(gPathResult, "version");
        boolean bl = false;
        boolean bl2 = false;
        String it22 = string;
        boolean bl3 = false;
        if (!CollectionsKt.listOf((Object[])new String[]{VERSION_1, VERSION_2}).contains(it22)) {
            throw (Throwable)new GradleException("Unsupported version (" + it22 + ") for dependency-verification file " + fileName + ". Please upgrade checksum-dependency plugin");
        }
        GPathResult gPathResult2 = DependencyVerificationStoreKt.access$get(xml, "trust-requirement");
        bl2 = false;
        boolean it22 = false;
        GPathResult it = gPathResult2;
        boolean bl4 = false;
        if (it.isEmpty()) {
            throw (Throwable)new GradleException("Tag dependency-verification/trust-requirement is not found in " + fileName);
        }
        String string2 = DependencyVerificationStoreKt.access$requiredAttr(it, "pgp");
        boolean bl5 = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toUpperCase()");
        string2 = string4;
        bl5 = false;
        boolean bl6 = false;
        String it322 = string2;
        boolean bl7 = false;
        try {
            pgpLevel = PgpLevel.valueOf(it322);
        }
        catch (Exception e) {
            throw (Throwable)new GradleException('\'' + it322 + "' is not supported for trust-requirement/@pgp. Supported values are " + ArraysKt.toList((Object[])PgpLevel.values()), (Throwable)e);
        }
        PgpLevel pgp = pgpLevel;
        String string5 = DependencyVerificationStoreKt.access$requiredAttr(it, "checksum");
        bl6 = false;
        String string6 = string5;
        if (string6 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string7 = string6.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).toUpperCase()");
        string5 = string7;
        bl6 = false;
        boolean it322 = false;
        String it4 = string5;
        boolean bl8 = false;
        try {
            checksumLevel = ChecksumLevel.valueOf(it4);
        }
        catch (Exception e) {
            throw (Throwable)new GradleException('\'' + it4 + "' is not supported for trust-requirement/@checksum. Supported values are " + ArraysKt.toList((Object[])ChecksumLevel.values()), (Throwable)e);
        }
        ChecksumLevel checksum2 = checksumLevel;
        VerificationConfig verificationConfig = new VerificationConfig(pgp, checksum2);
        DependencyVerification result = new DependencyVerification(verificationConfig);
        Iterable $this$forEach$iv = DependencyVerificationStoreKt.access$getList(DependencyVerificationStoreKt.access$get(xml, "ignored-keys"), "ignored-key");
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GPathResult it5 = (GPathResult)element$iv;
            boolean bl9 = false;
            Collection collection = result.getIgnoredKeys();
            PgpKeyId it322 = DependencyVerificationStoreKt.access$getParseKey$p(DependencyVerificationStoreKt.access$requiredAttr(it5, "id"));
            boolean bl10 = false;
            collection.add(it322);
        }
        $this$forEach$iv = DependencyVerificationStoreKt.access$get(xml, "trusted-keys");
        $i$f$forEach = false;
        boolean bl11 = false;
        Iterable $this$apply = $this$forEach$iv;
        boolean bl12 = false;
        if ($this$apply.isEmpty()) {
            throw (Throwable)new GradleException("Tag dependency-verification/trusted-keys is not found");
        }
        $this$forEach$iv = DependencyVerificationStoreKt.access$getList((GPathResult)$this$forEach$iv, "trusted-key");
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GPathResult it6 = (GPathResult)element$iv;
            boolean bl13 = false;
            String group = DependencyVerificationStoreKt.access$requiredAttr(it6, "group");
            PgpKeyId.Full key2 = DependencyVerificationStoreKt.access$parseFullKey(DependencyVerificationStoreKt.access$requiredAttr(it6, "id"), skipUnparseable, (Function0)new Function0<String>(group){
                final /* synthetic */ String $group;

                @NotNull
                public final String invoke() {
                    return "trusted-key for group " + this.$group;
                }
                {
                    this.$group = string;
                    super(0);
                }
            });
            if (key2 == null) continue;
            result.add(group, key2);
        }
        $this$forEach$iv = DependencyVerificationStoreKt.access$get(xml, "dependencies");
        $i$f$forEach = false;
        boolean bl14 = false;
        $this$apply = $this$forEach$iv;
        boolean bl15 = false;
        if ($this$apply.isEmpty()) {
            throw (Throwable)new GradleException("Tag dependency-verification/dependencies is not found");
        }
        $this$forEach$iv = DependencyVerificationStoreKt.access$getList((GPathResult)$this$forEach$iv, "dependency");
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GPathResult it7 = (GPathResult)element$iv;
            boolean bl16 = false;
            DependencyChecksum dep = DependencyVerificationStoreKt.access$toDependencyChecksum(it7, skipUnparseable);
            result.getDependencies().put(dep.getId(), dep);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void save(@NotNull File file, @NotNull DependencyVerification verification) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)verification, (String)"verification");
        Object object = file;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        Object object2 = object;
        boolean bl2 = false;
        object2 = new FileOutputStream((File)object2);
        bl2 = false;
        object = new OutputStreamWriter((OutputStream)object2, charset);
        boolean bl3 = false;
        bl = false;
        Throwable throwable = null;
        try {
            OutputStreamWriter it = (OutputStreamWriter)object;
            boolean bl4 = false;
            DependencyVerificationStore.save(it, verification);
            object2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void save(@NotNull Writer out, @NotNull DependencyVerification verification) {
        void $this$withGroovyBuilder$iv;
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        Intrinsics.checkParameterIsNotNull((Object)verification, (String)"verification");
        MarkupBuilder markupBuilder = new MarkupBuilder(out);
        boolean bl = false;
        boolean bl2 = false;
        MarkupBuilder $this$apply = markupBuilder;
        boolean bl3 = false;
        $this$apply.getMkp().xmlDeclaration(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"version", (Object)"1.0"), TuplesKt.to((Object)"encoding", (Object)"utf-8")}));
        boolean $i$f$withGroovyBuilder = false;
        GroovyBuilderScope $this$withGroovyBuilder = GroovyBuilderScope.Companion.of((Object)$this$withGroovyBuilder$iv);
        boolean bl4 = false;
        $this$withGroovyBuilder.invoke("dependency-verification", new Object[]{MapsKt.mapOf((Pair)TuplesKt.to((Object)"version", (Object)VERSION_2))}, (Function1)new Function1<GroovyBuilderScope, Object>(verification){
            final /* synthetic */ DependencyVerification $verification$inlined;
            {
                this.$verification$inlined = dependencyVerification;
                super(1);
            }

            @Nullable
            public final Object invoke(@NotNull GroovyBuilderScope $this$invoke) {
                Intrinsics.checkParameterIsNotNull((Object)$this$invoke, (String)"$receiver");
                $this$invoke.invoke("trust-requirement", new Object[]{DependencyVerificationStoreKt.access$toMap(this.$verification$inlined.getDefaultVerificationConfig())});
                $this$invoke.invoke("ignored-keys", (Function1)new Function1<GroovyBuilderScope, Unit>(this){
                    final /* synthetic */ save$$inlined$withGroovyBuilder$lambda$1 this$0;
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull GroovyBuilderScope $this$invoke) {
                        void $this$mapTo$iv$iv;
                        Intrinsics.checkParameterIsNotNull((Object)$this$invoke, (String)"$receiver");
                        Iterable $this$map$iv = this.this$0.$verification$inlined.getIgnoredKeys();
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            PgpKeyId pgpKeyId = (PgpKeyId)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            String string = it.toString();
                            collection.add(string);
                        }
                        Iterable $this$forEach$iv = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
                        boolean $i$f$forEach = false;
                        for (E element$iv : $this$forEach$iv) {
                            String it = (String)element$iv;
                            boolean bl = false;
                            $this$invoke.invoke("ignored-key", new Object[]{MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)it))});
                        }
                    }
                });
                $this$invoke.invoke("trusted-keys", (Function1)new Function1<GroovyBuilderScope, Unit>(this){
                    final /* synthetic */ save$$inlined$withGroovyBuilder$lambda$1 this$0;
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull GroovyBuilderScope $this$invoke) {
                        void $this$flatMapTo$iv$iv;
                        Intrinsics.checkParameterIsNotNull((Object)$this$invoke, (String)"$receiver");
                        Map<String, Set<PgpKeyId.Full>> $this$flatMap$iv = this.this$0.$verification$inlined.getGroupKeys();
                        boolean $i$f$flatMap = false;
                        Map<String, Set<PgpKeyId.Full>> map = $this$flatMap$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$flatMapTo = false;
                        void var7_8 = $this$flatMapTo$iv$iv;
                        boolean bl = false;
                        Iterator<Map.Entry<K, V>> iterator = var7_8.entrySet().iterator();
                        while (iterator.hasNext()) {
                            void $this$mapTo$iv$iv;
                            Map.Entry<K, V> element$iv$iv;
                            Map.Entry<K, V> $dstr$group$keys = element$iv$iv = iterator.next();
                            boolean bl2 = false;
                            Map.Entry<K, V> entry = $dstr$group$keys;
                            boolean bl3 = false;
                            String string = (String)entry.getKey();
                            entry = $dstr$group$keys;
                            bl3 = false;
                            Set keys2 = (Set)entry.getValue();
                            Iterable $this$map$iv = keys2;
                            boolean $i$f$map = false;
                            Iterable iterable = $this$map$iv;
                            Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                void group;
                                PgpKeyId.Full full = (PgpKeyId.Full)item$iv$iv;
                                Collection collection = destination$iv$iv2;
                                boolean bl4 = false;
                                Pair pair = TuplesKt.to((Object)group, (Object)it.toString());
                                collection.add(pair);
                            }
                            Iterable list$iv$iv = (List)destination$iv$iv2;
                            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                        }
                        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)ComparisonsKt.compareBy((Function1[])new Function1[]{save.3.2.INSTANCE, save.3.3.INSTANCE}));
                        boolean $i$f$forEach = false;
                        for (E element$iv : $this$forEach$iv) {
                            Pair it = (Pair)element$iv;
                            boolean bl5 = false;
                            $this$invoke.invoke("trusted-key", new Object[]{MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"id", (Object)it.getSecond()), TuplesKt.to((Object)"group", (Object)it.getFirst())})});
                        }
                    }
                });
                return $this$invoke.invoke("dependencies", (Function1)new Function1<GroovyBuilderScope, Unit>(this){
                    final /* synthetic */ save$$inlined$withGroovyBuilder$lambda$1 this$0;
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull GroovyBuilderScope $this$invoke) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$invoke, (String)"$receiver");
                        Iterable $this$sortedBy$iv = this.this$0.$verification$inlined.getDependencies().entrySet();
                        boolean $i$f$sortedBy = false;
                        boolean bl = false;
                        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                            public final int compare(T a, T b) {
                                boolean bl = false;
                                Map.Entry it = (Map.Entry)a;
                                boolean bl2 = false;
                                Comparable comparable = (Comparable)((Object)((Id)it.getKey()).toString());
                                it = (Map.Entry)b;
                                Comparable comparable2 = comparable;
                                bl2 = false;
                                String string = ((Id)it.getKey()).toString();
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                            }
                        });
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            void id;
                            Map.Entry $dstr$id$dependency = (Map.Entry)element$iv;
                            boolean bl2 = false;
                            Map.Entry entry = $dstr$id$dependency;
                            boolean bl3 = false;
                            Id id2 = (Id)entry.getKey();
                            entry = $dstr$id$dependency;
                            bl3 = false;
                            DependencyChecksum dependency = (DependencyChecksum)entry.getValue();
                            $this$invoke.invoke("dependency", new Object[]{DependencyVerificationStoreKt.access$toMap((Id)id)}, (Function1)new Function1<GroovyBuilderScope, Unit>(dependency){
                                final /* synthetic */ DependencyChecksum $dependency;
                                {
                                    this.$dependency = dependencyChecksum;
                                    super(1);
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public final void invoke(@NotNull GroovyBuilderScope $this$invoke) {
                                    void $this$mapTo$iv$iv;
                                    Intrinsics.checkParameterIsNotNull((Object)$this$invoke, (String)"$receiver");
                                    Iterable $this$map$iv = this.$dependency.getPgpKeys();
                                    boolean $i$f$map = false;
                                    Iterator<T> iterator = $this$map$iv;
                                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                    boolean $i$f$mapTo = false;
                                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                                        void it;
                                        PgpKeyId.Full full = (PgpKeyId.Full)item$iv$iv;
                                        Collection collection = destination$iv$iv;
                                        boolean bl = false;
                                        String string = it.toString();
                                        collection.add(string);
                                    }
                                    Iterable $this$forEach$iv = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
                                    boolean $i$f$forEach = false;
                                    for (Object element$iv : $this$forEach$iv) {
                                        String it = (String)element$iv;
                                        boolean bl = false;
                                        $this$invoke.invoke("pgp", new Object[]{it});
                                    }
                                    $this$forEach$iv = CollectionsKt.sorted((Iterable)this.$dependency.getSha512());
                                    $i$f$forEach = false;
                                    for (Object element$iv : $this$forEach$iv) {
                                        String it = (String)element$iv;
                                        boolean bl = false;
                                        $this$invoke.invoke("sha512", new Object[]{it});
                                    }
                                }
                            });
                        }
                    }
                });
            }
        });
        out.write("\n");
    }

    private DependencyVerificationStore() {
    }

    static {
        DependencyVerificationStore dependencyVerificationStore;
        INSTANCE = dependencyVerificationStore = new DependencyVerificationStore();
    }
}

