/*
 * Decompiled with CFR 0.152.
 */
package com.github.vlsi.gradle.checksum.pgp;

import com.github.vlsi.gradle.checksum.pgp.KeyDownloaderKt;
import com.github.vlsi.gradle.checksum.pgp.PgpKeyId;
import com.github.vlsi.gradle.checksum.pgp.Retry;
import com.github.vlsi.gradle.checksum.pgp.ShouldRetrySpec;
import com.github.vlsi.gradle.checksum.pgp.SingleHostDns;
import com.github.vlsi.gradle.checksum.pgp.Timeouts;
import java.io.Closeable;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import okhttp3.Dns;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u001c\u0010\u0017\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\u00020\u000e*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lcom/github/vlsi/gradle/checksum/pgp/KeyDownloader;", "", "retry", "Lcom/github/vlsi/gradle/checksum/pgp/Retry;", "timeouts", "Lcom/github/vlsi/gradle/checksum/pgp/Timeouts;", "(Lcom/github/vlsi/gradle/checksum/pgp/Retry;Lcom/github/vlsi/gradle/checksum/pgp/Timeouts;)V", "client", "Lokhttp3/OkHttpClient;", "getRetry", "()Lcom/github/vlsi/gradle/checksum/pgp/Retry;", "getTimeouts", "()Lcom/github/vlsi/gradle/checksum/pgp/Timeouts;", "prepare", "Ljava/net/URI;", "getPrepare", "(Ljava/net/URI;)Ljava/net/URI;", "findKey", "", "keyId", "Lcom/github/vlsi/gradle/checksum/pgp/PgpKeyId;", "comment", "", "retrieveKeyUri", "inetAddress", "Ljava/net/InetAddress;", "checksum-dependency-plugin"})
public final class KeyDownloader {
    private final OkHttpClient client;
    @NotNull
    private final Retry retry;
    @NotNull
    private final Timeouts timeouts;

    /*
     * Unable to fully structure code
     */
    private final URI getPrepare(URI $this$prepare) {
        block5: {
            block4: {
                v0 = $this$prepare.getScheme();
                if (v0 == null) break block4;
                var2_2 = v0;
                switch (var2_2.hashCode()) {
                    case 3213448: {
                        if (!var2_2.equals("http")) break;
                        ** GOTO lbl10
                    }
                    case 103373: {
                        if (!var2_2.equals("hkp")) break;
lbl10:
                        // 2 sources

                        v1 = "http";
                        break block5;
                    }
                }
            }
            v1 = "https";
        }
        return new URI(v1, $this$prepare.getUserInfo(), $this$prepare.getHost(), $this$prepare.getPort() == -1 && Intrinsics.areEqual((Object)$this$prepare.getScheme(), (Object)"hkp") != false ? 11371 : $this$prepare.getPort(), $this$prepare.getPath(), $this$prepare.getQuery(), $this$prepare.getFragment());
    }

    private final URI retrieveKeyUri(URI $this$retrieveKeyUri, PgpKeyId keyId, InetAddress inetAddress) {
        return new URI($this$retrieveKeyUri.getScheme(), $this$retrieveKeyUri.getUserInfo(), $this$retrieveKeyUri.getHost(), $this$retrieveKeyUri.getPort(), "/pks/lookup", "op=get&options=mr&search=0x" + keyId, null);
    }

    @Nullable
    public final byte[] findKey(@NotNull PgpKeyId keyId, @NotNull String comment) {
        Intrinsics.checkParameterIsNotNull((Object)keyId, (String)"keyId");
        Intrinsics.checkParameterIsNotNull((Object)comment, (String)"comment");
        return (byte[])this.retry.invoke("Downloading key " + keyId + " for " + comment, (Function1)new Function1<ShouldRetrySpec, byte[]>(this, keyId){
            final /* synthetic */ KeyDownloader this$0;
            final /* synthetic */ PgpKeyId $keyId;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final byte[] invoke(@NotNull ShouldRetrySpec $this$invoke) {
                byte[] byArray;
                Intrinsics.checkParameterIsNotNull((Object)$this$invoke, (String)"$receiver");
                URL url = KeyDownloader.access$retrieveKeyUri(this.this$0, KeyDownloader.access$getPrepare$p(this.this$0, $this$invoke.getUri()), this.$keyId, $this$invoke.getInetAddress()).toURL();
                Logger logger = KeyDownloaderKt.access$getLogger$p();
                Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
                Logger $this$debug$iv = logger;
                boolean $i$f$debug = false;
                if ($this$debug$iv.isDebugEnabled()) {
                    Logger logger2 = $this$debug$iv;
                    boolean bl = false;
                    String string = "Downloading PGP key " + this.$keyId + " from " + $this$invoke.getInetAddress() + ", url: " + url;
                    logger2.debug(string);
                }
                Request.Builder builder = new Request.Builder();
                URL uRL = url;
                Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url");
                Request request = builder.url(uRL).build();
                OkHttpClient.Builder builder2 = KeyDownloader.access$getClient$p(this.this$0).newBuilder();
                String string = url.getHost();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.host");
                OkHttpClient.Builder builder3 = builder2.dns((Dns)new SingleHostDns(string, $this$invoke.getInetAddress()));
                Duration duration = Duration.ofMillis(RangesKt.coerceAtMost((long)$this$invoke.getMaxTimeout(), (long)this.this$0.getTimeouts().getConnectTimeout().toMillis()));
                Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMillis(maxTim\u2026nnectTimeout.toMillis()))");
                OkHttpClient.Builder builder4 = builder3.connectTimeout(duration);
                Duration duration2 = Duration.ofMillis(RangesKt.coerceAtMost((long)$this$invoke.getMaxTimeout(), (long)this.this$0.getTimeouts().getReadTimeout().toMillis()));
                Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ofMillis(maxTim\u2026.readTimeout.toMillis()))");
                OkHttpClient newClient = builder4.readTimeout(duration2).build();
                Closeable closeable = (Closeable)newClient.newCall(request).execute();
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    Response response = (Response)closeable;
                    boolean bl3 = false;
                    int code = response.code();
                    $this$invoke.setLatency(response.receivedResponseAtMillis() - response.sentRequestAtMillis());
                    if (!response.isSuccessful()) {
                        Void void_ = $this$invoke.retry("Keyserver should respond with successful HTTP codes (200..300), actual code is " + code + ", url: " + url, code);
                        throw null;
                    }
                    ResponseBody responseBody = response.body();
                    if (responseBody == null) {
                        Void void_ = $this$invoke.retry("Empty response body for url: " + url, code);
                        throw null;
                    }
                    ResponseBody body = responseBody;
                    byArray = body.bytes();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return byArray;
            }
            {
                this.this$0 = keyDownloader;
                this.$keyId = pgpKeyId;
                super(1);
            }
        });
    }

    @NotNull
    public final Retry getRetry() {
        return this.retry;
    }

    @NotNull
    public final Timeouts getTimeouts() {
        return this.timeouts;
    }

    public KeyDownloader(@NotNull Retry retry, @NotNull Timeouts timeouts) {
        Intrinsics.checkParameterIsNotNull((Object)retry, (String)"retry");
        Intrinsics.checkParameterIsNotNull((Object)timeouts, (String)"timeouts");
        this.retry = retry;
        this.timeouts = timeouts;
        this.client = new OkHttpClient.Builder().connectTimeout(this.timeouts.getConnectTimeout()).readTimeout(this.timeouts.getReadTimeout()).build();
    }

    public /* synthetic */ KeyDownloader(Retry retry, Timeouts timeouts, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            retry = new Retry(null, null, null, 0, null, 31, null);
        }
        if ((n & 2) != 0) {
            timeouts = new Timeouts(null, null, 3, null);
        }
        this(retry, timeouts);
    }

    public KeyDownloader() {
        this(null, null, 3, null);
    }

    public static final /* synthetic */ URI access$retrieveKeyUri(KeyDownloader $this, URI $this$access_u24retrieveKeyUri, PgpKeyId keyId, InetAddress inetAddress) {
        return $this.retrieveKeyUri($this$access_u24retrieveKeyUri, keyId, inetAddress);
    }

    public static final /* synthetic */ URI access$getPrepare$p(KeyDownloader $this, URI $this$access_u24prepare_u24p) {
        return $this.getPrepare($this$access_u24prepare_u24p);
    }

    public static final /* synthetic */ OkHttpClient access$getClient$p(KeyDownloader $this) {
        return $this.client;
    }
}

