/*
 * Decompiled with CFR 0.152.
 */
package com.github.vlsi.gradle.git;

import com.github.vlsi.gradle.git.DirectorySet;
import com.github.vlsi.gradle.git.ParentAndPrefix;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.RelativePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u001a\u0010\u0011\u001a\u0016\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0013\u0012\u0004\u0012\u00028\u00000\u0012H\u0004J\u0013\u0010\u0014\u001a\u00028\u00012\u0006\u0010\u0015\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010\u0014\u001a\u00028\u00012\u0006\u0010\u0015\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0017J\u001f\u0010\u0014\u001a\u00028\u00012\b\u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0019\u001a\u00020\u001aH&\u00a2\u0006\u0002\u0010\u001bJ\u0013\u0010\u0014\u001a\u00028\u00012\u0006\u0010\u0015\u001a\u00020\u001c\u00a2\u0006\u0002\u0010\u001dJ\u0013\u0010\u0014\u001a\u00028\u00012\u0006\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\u0002\u0010 J\u001d\u0010!\u001a\u00028\u00012\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010$J\u0017\u0010%\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0018\u001a\u00020\nH\u0004\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020\nH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/github/vlsi/gradle/git/GitHolder;", "T", "V", "", "rootPath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "root", "Lcom/github/vlsi/gradle/git/DirectorySet;", "rootAbsolutePath", "", "kotlin.jvm.PlatformType", "rootDir", "Ljava/io/File;", "add", "", "prefix", "init", "Lkotlin/Function1;", "Lcom/github/vlsi/gradle/git/ParentAndPrefix;", "compute", "element", "(Ljava/io/File;)Ljava/lang/Object;", "(Ljava/lang/Object;)Ljava/lang/Object;", "entryPath", "isFile", "", "(Ljava/lang/String;Z)Ljava/lang/Object;", "Lorg/gradle/api/file/FileTreeElement;", "(Lorg/gradle/api/file/FileTreeElement;)Ljava/lang/Object;", "path", "Lorg/gradle/api/file/RelativePath;", "(Lorg/gradle/api/file/RelativePath;)Ljava/lang/Object;", "computeFile", "file", "isDirectory", "(Ljava/io/File;Z)Ljava/lang/Object;", "findNode", "(Ljava/lang/String;)Ljava/lang/Object;", "toString", "crlf-plugin"})
public abstract class GitHolder<T, V> {
    private final File rootDir;
    private final String rootAbsolutePath;
    private final DirectorySet<T> root;

    protected final void add(@NotNull String prefix, @NotNull Function1<? super ParentAndPrefix<T>, ? extends T> init) {
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Intrinsics.checkParameterIsNotNull(init, (String)"init");
        this.root.add(prefix, init);
    }

    @Nullable
    protected final T findNode(@NotNull String entryPath) {
        Intrinsics.checkParameterIsNotNull((Object)entryPath, (String)"entryPath");
        return this.root.get(entryPath);
    }

    public abstract V compute(@Nullable String var1, boolean var2);

    public final V compute(@NotNull Object element) {
        V v;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Object object = element;
        if (object instanceof FileTreeElement) {
            v = this.compute((FileTreeElement)element);
        } else if (object instanceof File) {
            v = this.compute((File)element);
        } else if (object instanceof RelativePath) {
            v = this.compute((RelativePath)element);
        } else {
            String string = "Unsupported value: " + element;
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
        }
        return v;
    }

    public final V compute(@NotNull RelativePath path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Object[] objectArray = path.getSegments();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"path.segments");
        return this.compute(ArraysKt.joinToString$default((Object[])objectArray, (CharSequence)"/", (CharSequence)"/", (CharSequence)"", (int)0, null, null, (int)56, null), path.isFile());
    }

    public final V compute(@NotNull FileTreeElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        File file = element.getFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"element.file");
        return this.computeFile(file, element.isDirectory());
    }

    public final V compute(@NotNull File element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return this.computeFile(element, element.isDirectory());
    }

    private final V computeFile(File file, boolean isDirectory) {
        String string;
        String absolutePath;
        String string2 = absolutePath = file.getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"absolutePath");
        String string3 = this.rootAbsolutePath;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"rootAbsolutePath");
        if (!StringsKt.startsWith$default((String)string2, (String)string3, (boolean)false, (int)2, null)) {
            return this.compute(null, false);
        }
        if (absolutePath.length() == this.rootAbsolutePath.length()) {
            string = "/";
        } else {
            String string4 = absolutePath;
            int n = this.rootAbsolutePath.length();
            boolean bl = false;
            String string5 = string4.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            string = StringsKt.replace$default((String)string5, (char)'\\', (char)'/', (boolean)false, (int)4, null);
        }
        String rel = string;
        return this.compute(rel, !isDirectory);
    }

    @NotNull
    public String toString() {
        return this.root.toString();
    }

    public GitHolder(@NotNull Path rootPath) {
        Intrinsics.checkParameterIsNotNull((Object)rootPath, (String)"rootPath");
        File file = this.rootDir = rootPath.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"rootDir");
        this.rootAbsolutePath = file.getCanonicalPath();
        this.root = new DirectorySet();
    }
}

