/*
 * Decompiled with CFR 0.152.
 */
package com.github.vlsi.gradle.gettext;

import com.github.vlsi.gradle.gettext.BaseGettextEditTask;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileType;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecSpec;
import org.gradle.work.ChangeType;
import org.gradle.work.FileChange;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007R\u001c\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u00020\u00138\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lcom/github/vlsi/gradle/gettext/MsgMergeTask;", "Lcom/github/vlsi/gradle/gettext/BaseGettextEditTask;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "args", "Lorg/gradle/api/provider/ListProperty;", "", "getArgs", "()Lorg/gradle/api/provider/ListProperty;", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "poFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getPoFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "potFile", "Lorg/gradle/api/file/RegularFileProperty;", "getPotFile", "()Lorg/gradle/api/file/RegularFileProperty;", "run", "", "inputChanges", "Lorg/gradle/work/InputChanges;", "gettext-plugin"})
public class MsgMergeTask
extends BaseGettextEditTask {
    @InputFiles
    @Incremental
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    private final ConfigurableFileCollection poFiles;
    @Input
    @NotNull
    private final ListProperty<String> args;
    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    private final RegularFileProperty potFile;
    @OutputDirectory
    @NotNull
    private final DirectoryProperty outputDir;

    @NotNull
    public final ConfigurableFileCollection getPoFiles() {
        return this.poFiles;
    }

    @NotNull
    public final ListProperty<String> getArgs() {
        return this.args;
    }

    @NotNull
    public final RegularFileProperty getPotFile() {
        return this.potFile;
    }

    @NotNull
    public final DirectoryProperty getOutputDir() {
        return this.outputDir;
    }

    @TaskAction
    public final void run(@NotNull InputChanges inputChanges) {
        Intrinsics.checkParameterIsNotNull((Object)inputChanges, (String)"inputChanges");
        Object object = this.outputDir.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"outputDir.get()");
        File file = ((Directory)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"outputDir.get().asFile");
        File outDir = file;
        Object object2 = this.getExecutable().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"executable.get()");
        String cmd = (String)object2;
        Object object3 = this.args.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"args.get()");
        List arg = (List)object3;
        Object object4 = this.potFile.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"potFile.get()");
        File file2 = ((RegularFile)object4).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"potFile.get().asFile");
        String pot = file2.getAbsolutePath();
        Iterator iterator = inputChanges.getFileChanges((FileCollection)this.poFiles).iterator();
        while (iterator.hasNext()) {
            FileChange po;
            FileChange fileChange = po = (FileChange)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileChange, (String)"po");
            if (fileChange.getFileType() != FileType.FILE) continue;
            File file3 = po.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"po.file");
            File outFile = new File(outDir, file3.getName());
            if (po.getChangeType() == ChangeType.REMOVED) {
                this.getLogger().debug("Removing output {}", (Object)outFile);
                this.getProject().delete(new Object[]{outFile});
                continue;
            }
            this.getLogger().debug("Processing {} with {} {}", new Object[]{po.getFile(), cmd, arg});
            this.getProject().exec((Action)new Action<ExecSpec>(cmd, outFile, arg, po, pot){
                final /* synthetic */ String $cmd;
                final /* synthetic */ File $outFile;
                final /* synthetic */ List $arg;
                final /* synthetic */ FileChange $po;
                final /* synthetic */ String $pot;

                public final void execute(@NotNull ExecSpec $this$exec) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$exec, (String)"$receiver");
                    $this$exec.setExecutable(this.$cmd);
                    $this$exec.args(new Object[]{"--output-file=" + this.$outFile.getAbsolutePath()});
                    $this$exec.args(new Object[]{"--quiet"});
                    $this$exec.args((Iterable)this.$arg);
                    Object[] objectArray = new Object[1];
                    FileChange fileChange = this.$po;
                    Intrinsics.checkExpressionValueIsNotNull((Object)fileChange, (String)"po");
                    File file = fileChange.getFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"po.file");
                    objectArray[0] = file.getAbsolutePath();
                    $this$exec.args(objectArray);
                    $this$exec.args(new Object[]{this.$pot});
                }
                {
                    this.$cmd = string;
                    this.$outFile = file;
                    this.$arg = list;
                    this.$po = fileChange;
                    this.$pot = string2;
                }
            });
            this.removePotCreationDate(outFile);
        }
    }

    @Inject
    public MsgMergeTask(@NotNull ObjectFactory objects) {
        Intrinsics.checkParameterIsNotNull((Object)objects, (String)"objects");
        super(objects);
        ConfigurableFileCollection configurableFileCollection = objects.fileCollection();
        Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection, (String)"objects.fileCollection()");
        this.poFiles = configurableFileCollection;
        ObjectFactory $this$listProperty$iv = objects;
        boolean $i$f$listProperty = false;
        ListProperty listProperty = $this$listProperty$iv.listProperty(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"listProperty(T::class.java)");
        this.args = listProperty;
        RegularFileProperty regularFileProperty = objects.fileProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)regularFileProperty, (String)"objects.fileProperty()");
        this.potFile = regularFileProperty;
        DirectoryProperty directoryProperty = objects.directoryProperty();
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        ProjectLayout projectLayout = project.getLayout();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectLayout, (String)"project.layout");
        DirectoryProperty directoryProperty2 = directoryProperty.convention(projectLayout.getBuildDirectory().dir("gettext/" + this.getName() + "/po"));
        Intrinsics.checkExpressionValueIsNotNull((Object)directoryProperty2, (String)"objects.directoryPropert\u2026.dir(\"gettext/$name/po\"))");
        this.outputDir = directoryProperty2;
        this.getExecutable().convention((Object)"msgmerge");
    }
}

