/*
 * Decompiled with CFR 0.152.
 */
package com.github.vlsi.jandex;

import com.github.vlsi.jandex.JandexBuildAction;
import com.github.vlsi.jandex.JandexException;
import com.github.vlsi.jandex.JandexFileParseException;
import com.github.vlsi.jandex.JandexWorkParameters;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.file.RegularFile;
import org.gradle.workers.WorkAction;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b&\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\u0006\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u00a8\u0006\n"}, d2={"Lcom/github/vlsi/jandex/JandexWork;", "Lorg/gradle/workers/WorkAction;", "Lcom/github/vlsi/jandex/JandexWorkParameters;", "()V", "execute", "", "writeIndex", "index", "", "Companion", "jandex-plugin"})
@SourceDebugExtension(value={"SMAP\nJandexWork.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JandexWork.kt\ncom/github/vlsi/jandex/JandexWork\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n1557#2:139\n1628#2,3:140\n*S KotlinDebug\n*F\n+ 1 JandexWork.kt\ncom/github/vlsi/jandex/JandexWork\n*L\n81#1:139\n81#1:140,3\n*E\n"})
public abstract class JandexWork
implements WorkAction<JandexWorkParameters> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger logger = LoggerFactory.getLogger(JandexWork.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void execute() {
        Object object4;
        Throwable cause;
        Throwable throwable;
        long start = System.currentTimeMillis();
        Class<?> indexerClass = Class.forName("org.jboss.jandex.Indexer");
        Object indexer = indexerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        Class[] classArray = new Class[]{InputStream.class};
        Method indexMethod = indexerClass.getMethod("index", classArray);
        int indexedFiles = 0;
        Object object2 = ((JandexWorkParameters)this.getParameters()).getMaxErrors().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.maxErrors.get()");
        int maxErrors = ((Number)object2).intValue();
        List errors = new ArrayList();
        for (Object file : ((JandexWorkParameters)this.getParameters()).getInputFiles()) {
            logger.debug("Jandex: processing {}", file);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
            Closeable closeable = new FileInputStream((File)file);
            throwable = null;
            try {
                Object object3;
                Object it = closeable;
                boolean bl = false;
                try {
                    object3 = new Object[]{it};
                    object3 = indexMethod.invoke(indexer, (Object[])object3);
                }
                catch (InvocationTargetException e) {
                    Throwable throwable2 = cause = e.getCause();
                    logger.info("Error indexing file {}: {}", file, (Object)(throwable2 != null ? throwable2.getMessage() : null));
                    ((Collection)errors).add(new JandexFileParseException((File)file, ((File)file).toString(), cause));
                    object3 = Unit.INSTANCE;
                }
                it = object3;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            ++indexedFiles;
            if (errors.size() <= maxErrors) continue;
        }
        if (!((Collection)errors).isEmpty()) {
            JandexException jandexException;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object file;
            String s = errors.size() == 1 ? "" : "s";
            file = errors;
            StringBuilder stringBuilder = new StringBuilder().append("Unable to process ").append(errors.size()).append(" file").append(s).append(". It might be caused by invalid bytecode in the class file or a defect in org.jboss:jandex; You might analyze the bytecode with the following command: javap -verbose -p <ClassName.class>; Unable to parse the following file").append(s).append(": ");
            boolean $i$f$map = false;
            throwable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                cause = (JandexFileParseException)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getFile());
            }
            Throwable throwable3 = errors.size() != 1 ? null : ((JandexFileParseException)CollectionsKt.first((List)errors)).getCause();
            String string = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)).toString();
            JandexException $this$execute_u24lambda_u242 = jandexException = new JandexException(string, throwable3);
            boolean object4 = false;
            if (errors.size() > 1) {
                for (JandexFileParseException e : errors) {
                    ExceptionsKt.addSuppressed((Throwable)$this$execute_u24lambda_u242, (Throwable)e);
                }
            }
            throw (Throwable)jandexException;
        }
        long parseFiles = System.currentTimeMillis();
        try {
            object4 = indexerClass.getMethod("complete", new Class[0]).invoke(indexer, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable throwable4 = e.getCause();
            Intrinsics.checkNotNull((Object)throwable4);
            throw throwable4;
        }
        Object index = object4;
        long indexBuild = System.currentTimeMillis();
        this.writeIndex(index);
        long indexWrite = System.currentTimeMillis();
        logger.info("Jandex indexed " + indexedFiles + " files, total time: " + (indexWrite - start) + " ms, class processing: " + (parseFiles - start) + " ms, index build: " + (indexBuild - parseFiles) + " ms, index write: " + (indexWrite - indexBuild) + " ms");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeIndex(Object index) {
        File file = ((RegularFile)((JandexWorkParameters)this.getParameters()).getIndexFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"parameters.indexFile.get().asFile");
        File indexFile2 = file;
        if (index == null || ((JandexWorkParameters)this.getParameters()).getJandexBuildAction().get() == JandexBuildAction.VERIFY_ONLY) {
            logger.debug("Writing empty jandex index to {} (indexBuildAction=VERIFY_ONLY, so the file is used only for Gradle build cache)", (Object)indexFile2);
            FilesKt.writeBytes((File)indexFile2, (byte[])new byte[0]);
            return;
        }
        logger.debug("Writing jandex index to {}", (Object)indexFile2);
        indexFile2.getAbsoluteFile().getParentFile().mkdirs();
        Closeable closeable = new FileOutputStream(indexFile2);
        Throwable throwable = null;
        try {
            FileOutputStream indexFileStream = (FileOutputStream)closeable;
            boolean bl = false;
            Class<?> indexWriterClass = Class.forName("org.jboss.jandex.IndexWriter");
            Object[] objectArray = new Class[]{OutputStream.class};
            Constructor<?> constructor = indexWriterClass.getConstructor((Class<?>[])objectArray);
            objectArray = new Object[]{indexFileStream};
            Object indexWriter = constructor.newInstance(objectArray);
            Object object = new Class[]{index.getClass()};
            Method writeMethod = indexWriterClass.getMethod("write", (Class<?>[])object);
            try {
                object = new Object[]{index};
                object = writeMethod.invoke(indexWriter, object);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                throw new JandexException("Unable to write index to " + indexFile2 + ". It is likely caused by a defect in org.jboss:jandex. " + cause, cause);
            }
            Object object2 = object;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/github/vlsi/jandex/JandexWork$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "jandex-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

