/*
 * Decompiled with CFR 0.152.
 */
package com.github.vlsi.gradle.license;

import com.github.vlsi.gradle.license.FindLicenseKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/github/vlsi/gradle/license/FindLicense;", "Ljava/lang/Runnable;", "id", "", "file", "Ljava/io/File;", "outputDir", "(Ljava/lang/String;Ljava/io/File;Ljava/io/File;)V", "run", "", "license-gather-plugin"})
public final class FindLicense
implements Runnable {
    private final String id;
    private final File file;
    private final File outputDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!ArraysKt.contains((Object[])new String[]{"zip", "jar"}, (Object)FilesKt.getExtension((File)this.file))) {
            return;
        }
        Closeable closeable = new ZipFile(this.file);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ZipFile zipFile = (ZipFile)closeable;
            boolean bl3 = false;
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            Intrinsics.checkExpressionValueIsNotNull(enumeration, (String)"zipFile.entries()");
            Iterator iterator = CollectionsKt.iterator(enumeration);
            while (iterator.hasNext()) {
                ZipEntry e;
                ZipEntry zipEntry = e = (ZipEntry)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)zipEntry, (String)"e");
                String entryName = zipEntry.getName();
                if (e.isDirectory()) continue;
                String string = entryName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entryName");
                if (!FindLicenseKt.looksLikeLicense(string) || StringsKt.contains$default((CharSequence)entryName, (CharSequence)"../", (boolean)false, (int)2, null)) continue;
                File outFile = new File(this.outputDir, StringsKt.removePrefix((String)entryName, (CharSequence)"/"));
                outFile.getParentFile().mkdirs();
                Object object = outFile;
                boolean bl4 = false;
                object = new FileOutputStream((File)object);
                bl4 = false;
                boolean bl5 = false;
                Throwable throwable2 = null;
                try {
                    long l;
                    FileOutputStream out = (FileOutputStream)object;
                    boolean bl6 = false;
                    Closeable closeable2 = zipFile.getInputStream(e);
                    boolean bl7 = false;
                    boolean bl8 = false;
                    Throwable throwable3 = null;
                    try {
                        InputStream it = (InputStream)closeable2;
                        boolean bl9 = false;
                        InputStream inputStream = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"it");
                        l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)out, (int)0, (int)2, null);
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable3);
                    }
                    long l2 = l;
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Inject
    public FindLicense(@NotNull String id, @NotNull File file, @NotNull File outputDir) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)outputDir, (String)"outputDir");
        this.id = id;
        this.file = file;
        this.outputDir = outputDir;
    }
}

