/*
 * Decompiled with CFR 0.152.
 */
package com.github.vlsi.gradle.license;

import com.github.vlsi.gradle.license.Predictor;
import com.github.vlsi.gradle.license.TfIdfBuilder;
import com.github.vlsi.gradle.license.api.LicenseExpression;
import com.github.vlsi.gradle.license.api.LicenseExpressionNormalizer;
import com.github.vlsi.gradle.license.api.SimpleLicense;
import com.github.vlsi.gradle.license.api.SimpleLicenseExpression;
import com.github.vlsi.gradle.license.api.SpdxLicense;
import com.github.vlsi.gradle.license.api.WithException;
import java.net.URI;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0014\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0012H\u0002J\f\u0010\u0013\u001a\u00020\u0012*\u00020\u0012H\u0002J\f\u0010\u0014\u001a\u00020\u0012*\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/github/vlsi/gradle/license/GuessBasedNormalizer;", "Lcom/github/vlsi/gradle/license/api/LicenseExpressionNormalizer;", "logger", "Lorg/slf4j/Logger;", "similarityThreshold", "", "(Lorg/slf4j/Logger;D)V", "nameGuesser", "Lcom/github/vlsi/gradle/license/Predictor;", "Lcom/github/vlsi/gradle/license/api/LicenseExpression;", "normalize", "license", "Lcom/github/vlsi/gradle/license/api/SimpleLicense;", "looksTheSame", "", "Ljava/net/URI;", "other", "normalizeUri", "", "trimTextExtensions", "trimWww", "license-gather-plugin"})
public final class GuessBasedNormalizer
extends LicenseExpressionNormalizer {
    private final Predictor<LicenseExpression> nameGuesser;
    private final Logger logger;
    private final double similarityThreshold;

    private final String trimTextExtensions(String $this$trimTextExtensions) {
        return StringsKt.removeSuffix((String)StringsKt.removeSuffix((String)$this$trimTextExtensions, (CharSequence)".txt"), (CharSequence)".md");
    }

    private final String trimWww(String $this$trimWww) {
        String string;
        if (StringsKt.startsWith$default((String)$this$trimWww, (String)"//www.", (boolean)false, (int)2, null)) {
            StringBuilder stringBuilder = new StringBuilder().append("//");
            String string2 = $this$trimWww;
            int n = 6;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            string = stringBuilder.append(string4).toString();
        } else {
            string = $this$trimWww;
        }
        return string;
    }

    private final String normalizeUri(String $this$normalizeUri) {
        return this.trimWww(this.trimTextExtensions($this$normalizeUri));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean looksTheSame(URI $this$looksTheSame, URI other) {
        if (Intrinsics.areEqual((Object)$this$looksTheSame.getSchemeSpecificPart(), (Object)other.getSchemeSpecificPart())) return true;
        String string = $this$looksTheSame.getSchemeSpecificPart();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"schemeSpecificPart");
        String string2 = this.normalizeUri(string);
        String string3 = other.getSchemeSpecificPart();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"other.schemeSpecificPart");
        if (!Intrinsics.areEqual((Object)string2, (Object)this.normalizeUri(string3))) return false;
        return true;
    }

    @Override
    @Nullable
    public LicenseExpression normalize(@NotNull SimpleLicense license) {
        Map.Entry firstLicense;
        Intrinsics.checkParameterIsNotNull((Object)license, (String)"license");
        if (StringsKt.equals((String)license.getTitle(), (String)"PUBLIC DOMAIN", (boolean)true)) {
            return SpdxLicense.CC0_1_0.getExpression();
        }
        SpdxLicense spdxLicense = SpdxLicense.Companion.fromIdOrNull(license.getTitle());
        if (spdxLicense != null) {
            SpdxLicense spdxLicense2 = spdxLicense;
            boolean bl = false;
            boolean bl2 = false;
            SpdxLicense it = spdxLicense2;
            boolean bl3 = false;
            return it.getExpression();
        }
        Iterable $this$sortedByDescending$iv = this.nameGuesser.predict(license.getTitle()).entrySet();
        boolean $i$f$sortedByDescending22 = false;
        boolean it = false;
        List guessList = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Map.Entry it = (Map.Entry)b;
                boolean bl2 = false;
                Comparable comparable = (Double)it.getValue();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Double d = (Double)it.getValue();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
            }
        });
        List<URI> inputUris = license.getUri();
        Collection $i$f$sortedByDescending22 = inputUris;
        it = false;
        if (!$i$f$sortedByDescending22.isEmpty()) {
            Object v4;
            block16: {
                Sequence $this$firstOrNull$iv = SequencesKt.take((Sequence)CollectionsKt.asSequence((Iterable)guessList), (int)20);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    boolean bl;
                    block15: {
                        Object object;
                        Map.Entry $dstr$guess$_u24__u24 = (Map.Entry)element$iv;
                        boolean bl4 = false;
                        Object object2 = $dstr$guess$_u24__u24;
                        boolean bl5 = false;
                        LicenseExpression guess = (LicenseExpression)object2.getKey();
                        if (((object2 = guess) instanceof SimpleLicenseExpression ? ((SimpleLicenseExpression)guess).getLicense() : (object = object2 instanceof WithException ? ((WithException)guess).getLicense().getLicense() : null)) != null && (object = object.getUri()) != null) {
                            Iterable $this$any$iv = (Iterable)object;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv) {
                                    boolean bl6;
                                    block14: {
                                        URI u = (URI)element$iv2;
                                        boolean bl7 = false;
                                        Iterable $this$any$iv2 = inputUris;
                                        boolean $i$f$any2 = false;
                                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                            bl6 = false;
                                        } else {
                                            for (Object element$iv3 : $this$any$iv2) {
                                                URI it2 = (URI)element$iv3;
                                                boolean bl8 = false;
                                                if (!this.looksTheSame(it2, u)) continue;
                                                bl6 = true;
                                                break block14;
                                            }
                                            bl6 = false;
                                        }
                                    }
                                    if (!bl6) continue;
                                    bl = true;
                                    break block15;
                                }
                                bl = false;
                            }
                        } else {
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    v4 = element$iv;
                    break block16;
                }
                v4 = null;
            }
            Map.Entry matchingLicense = v4;
            if (matchingLicense != null) {
                this.logger.debug("Automatically detected license name={} url={} to mean {}", new Object[]{license.getTitle(), license.getUri(), matchingLicense.getKey()});
                return (LicenseExpression)matchingLicense.getKey();
            }
        }
        if (((Number)(firstLicense = (Map.Entry)CollectionsKt.first((List)guessList)).getValue()).doubleValue() * (double)100 > this.similarityThreshold) {
            this.logger.debug("Automatically detected license {} to mean {}. Other possibilities were {}", new Object[]{license.getTitle(), firstLicense.getKey(), CollectionsKt.take((Iterable)guessList, (int)10)});
            return (LicenseExpression)firstLicense.getKey();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public GuessBasedNormalizer(@NotNull Logger logger, double similarityThreshold) {
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        this.logger = logger;
        this.similarityThreshold = similarityThreshold;
        TfIdfBuilder tfIdfBuilder = new TfIdfBuilder();
        boolean bl = false;
        boolean bl2 = false;
        TfIdfBuilder tfIdfBuilder2 = tfIdfBuilder;
        GuessBasedNormalizer guessBasedNormalizer = this;
        boolean bl3 = false;
        SpdxLicense[] $this$forEach$iv = SpdxLicense.values();
        boolean $i$f$forEach = false;
        SpdxLicense[] spdxLicenseArray = $this$forEach$iv;
        int n = spdxLicenseArray.length;
        for (int i = 0; i < n; ++i) {
            void $this$apply;
            SpdxLicense element$iv;
            SpdxLicense it = element$iv = spdxLicenseArray[i];
            boolean bl4 = false;
            $this$apply.addDocument(it.getExpression(), it.getTitle());
        }
        Unit unit = Unit.INSTANCE;
        guessBasedNormalizer.nameGuesser = tfIdfBuilder.build();
    }

    public /* synthetic */ GuessBasedNormalizer(Logger logger, double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d = 42.0;
        }
        this(logger, d);
    }
}

