/*
 * Decompiled with CFR 0.152.
 */
package com.github.vlsi.gradle.license;

import com.github.vlsi.gradle.license.CompatibilityResult;
import com.github.vlsi.gradle.license.GuessBasedNormalizer;
import com.github.vlsi.gradle.license.LicenseCompatibility;
import com.github.vlsi.gradle.license.LicenseCompatibilityConfig;
import com.github.vlsi.gradle.license.LicenseCompatibilityInterpreter;
import com.github.vlsi.gradle.license.LicenseInfo;
import com.github.vlsi.gradle.license.MetadataStore;
import com.github.vlsi.gradle.license.ResolvedLicenseCompatibility;
import com.github.vlsi.gradle.license.VerifyLicenseCompatibilityTask;
import com.github.vlsi.gradle.license.VerifyLicenseCompatibilityTask$WhenMappings;
import com.github.vlsi.gradle.license.api.LicenseEquivalence;
import com.github.vlsi.gradle.license.api.LicenseExpression;
import com.github.vlsi.gradle.license.api.LicenseExpressionSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.kotlin.dsl.ActionExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0010\b\u0002\u0010$\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010%H\u0007J(\u0010'\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010(\u001a\u00020)2\u0010\b\u0002\u0010$\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010%J\"\u0010*\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0010\b\u0002\u0010$\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010%H\u0007J\b\u0010+\u001a\u00020!H\u0007J\"\u0010,\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0010\b\u0002\u0010$\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010%H\u0007J,\u0010-\u001a\u00020!*\u00060.j\u0002`/2\u001a\u00100\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u000203\u0012\u0006\u0012\u0004\u0018\u00010\u001c0201H\u0002R$\u0010\u0007\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR$\u0010\r\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000e0\u000e0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0016\u0010\u0010\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u00020\u00158\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\fR\"\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00064"}, d2={"Lcom/github/vlsi/gradle/license/VerifyLicenseCompatibilityTask;", "Lorg/gradle/api/DefaultTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "layout", "Lorg/gradle/api/file/ProjectLayout;", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/api/file/ProjectLayout;)V", "failOnIncompatibleLicense", "Lorg/gradle/api/provider/Property;", "", "kotlin.jvm.PlatformType", "getFailOnIncompatibleLicense", "()Lorg/gradle/api/provider/Property;", "licenseSimilarityNormalizationThreshold", "", "getLicenseSimilarityNormalizationThreshold", "metadata", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getMetadata", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "printResults", "getPrintResults", "resolvedCases", "Lorg/gradle/api/provider/MapProperty;", "Lcom/github/vlsi/gradle/license/api/LicenseExpression;", "Lcom/github/vlsi/gradle/license/LicenseCompatibility;", "getResolvedCases", "()Lorg/gradle/api/provider/MapProperty;", "allow", "", "licenseSet", "Lcom/github/vlsi/gradle/license/api/LicenseExpressionSet;", "action", "Lorg/gradle/api/Action;", "Lcom/github/vlsi/gradle/license/LicenseCompatibilityConfig;", "registerResolution", "type", "Lcom/github/vlsi/gradle/license/CompatibilityResult;", "reject", "run", "unknown", "appendComponents", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "components", "", "Lkotlin/Pair;", "Lorg/gradle/api/artifacts/component/ModuleComponentIdentifier;", "license-gather-plugin"})
public class VerifyLicenseCompatibilityTask
extends DefaultTask {
    @InputFiles
    @NotNull
    private final ConfigurableFileCollection metadata;
    @Input
    @NotNull
    private final Property<Boolean> failOnIncompatibleLicense;
    @Input
    @NotNull
    private final MapProperty<LicenseExpression, LicenseCompatibility> resolvedCases;
    @Input
    @NotNull
    private final Property<Integer> licenseSimilarityNormalizationThreshold;
    @Option(option="print", description="prints the verification results to console")
    @Console
    @NotNull
    private final Property<Boolean> printResults;
    @OutputFile
    @NotNull
    private final RegularFileProperty outputFile;

    @NotNull
    public final ConfigurableFileCollection getMetadata() {
        return this.metadata;
    }

    @NotNull
    public final Property<Boolean> getFailOnIncompatibleLicense() {
        return this.failOnIncompatibleLicense;
    }

    @NotNull
    public final MapProperty<LicenseExpression, LicenseCompatibility> getResolvedCases() {
        return this.resolvedCases;
    }

    @NotNull
    public final Property<Integer> getLicenseSimilarityNormalizationThreshold() {
        return this.licenseSimilarityNormalizationThreshold;
    }

    @NotNull
    public final Property<Boolean> getPrintResults() {
        return this.printResults;
    }

    @NotNull
    public final RegularFileProperty getOutputFile() {
        return this.outputFile;
    }

    public final void registerResolution(@NotNull LicenseExpressionSet licenseSet, @NotNull CompatibilityResult type, @Nullable Action<LicenseCompatibilityConfig> action) {
        Object object;
        block4: {
            block3: {
                Intrinsics.checkParameterIsNotNull((Object)licenseSet, (String)"licenseSet");
                Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
                object = action;
                if (object == null) break block3;
                Action<LicenseCompatibilityConfig> action2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Action<LicenseCompatibilityConfig> it = action2;
                boolean bl3 = false;
                LicenseCompatibilityConfig licenseCompatibilityConfig = new LicenseCompatibilityConfig(){
                    @NotNull
                    private String reason;

                    @NotNull
                    public final String getReason() {
                        return this.reason;
                    }

                    public final void setReason(@NotNull String string) {
                        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
                        this.reason = string;
                    }

                    public void because(@NotNull String reason2) {
                        Intrinsics.checkParameterIsNotNull((Object)reason2, (String)"reason");
                        this.reason = reason2;
                    }
                    {
                        this.reason = "";
                    }
                };
                boolean bl4 = false;
                boolean bl5 = false;
                LicenseCompatibilityConfig it2 = licenseCompatibilityConfig;
                boolean bl6 = false;
                ActionExtensionsKt.invoke(action, (Object)it2);
                String string = it2.getReason();
                object = string;
                if (string != null) break block4;
            }
            object = "";
        }
        Object reason2 = object;
        LicenseCompatibility licenseCompatibility = new LicenseCompatibility(type, (String)reason2);
        for (LicenseExpression licenseExpression : licenseSet.getDisjunctions()) {
            this.resolvedCases.put((Object)licenseExpression, (Object)licenseCompatibility);
        }
    }

    public static /* synthetic */ void registerResolution$default(VerifyLicenseCompatibilityTask verifyLicenseCompatibilityTask, LicenseExpressionSet licenseExpressionSet, CompatibilityResult compatibilityResult, Action action, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: registerResolution");
        }
        if ((n & 4) != 0) {
            action = null;
        }
        verifyLicenseCompatibilityTask.registerResolution(licenseExpressionSet, compatibilityResult, (Action<LicenseCompatibilityConfig>)action);
    }

    @JvmOverloads
    public final void allow(@NotNull LicenseExpressionSet licenseSet, @Nullable Action<LicenseCompatibilityConfig> action) {
        Intrinsics.checkParameterIsNotNull((Object)licenseSet, (String)"licenseSet");
        this.registerResolution(licenseSet, CompatibilityResult.ALLOW, action);
    }

    public static /* synthetic */ void allow$default(VerifyLicenseCompatibilityTask verifyLicenseCompatibilityTask, LicenseExpressionSet licenseExpressionSet, Action action, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: allow");
        }
        if ((n & 2) != 0) {
            action = null;
        }
        verifyLicenseCompatibilityTask.allow(licenseExpressionSet, (Action<LicenseCompatibilityConfig>)action);
    }

    @JvmOverloads
    public final void allow(@NotNull LicenseExpressionSet licenseSet) {
        VerifyLicenseCompatibilityTask.allow$default(this, licenseSet, null, 2, null);
    }

    @JvmOverloads
    public final void reject(@NotNull LicenseExpressionSet licenseSet, @Nullable Action<LicenseCompatibilityConfig> action) {
        Intrinsics.checkParameterIsNotNull((Object)licenseSet, (String)"licenseSet");
        this.registerResolution(licenseSet, CompatibilityResult.REJECT, action);
    }

    public static /* synthetic */ void reject$default(VerifyLicenseCompatibilityTask verifyLicenseCompatibilityTask, LicenseExpressionSet licenseExpressionSet, Action action, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reject");
        }
        if ((n & 2) != 0) {
            action = null;
        }
        verifyLicenseCompatibilityTask.reject(licenseExpressionSet, (Action<LicenseCompatibilityConfig>)action);
    }

    @JvmOverloads
    public final void reject(@NotNull LicenseExpressionSet licenseSet) {
        VerifyLicenseCompatibilityTask.reject$default(this, licenseSet, null, 2, null);
    }

    @JvmOverloads
    public final void unknown(@NotNull LicenseExpressionSet licenseSet, @Nullable Action<LicenseCompatibilityConfig> action) {
        Intrinsics.checkParameterIsNotNull((Object)licenseSet, (String)"licenseSet");
        this.registerResolution(licenseSet, CompatibilityResult.UNKNOWN, action);
    }

    public static /* synthetic */ void unknown$default(VerifyLicenseCompatibilityTask verifyLicenseCompatibilityTask, LicenseExpressionSet licenseExpressionSet, Action action, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: unknown");
        }
        if ((n & 2) != 0) {
            action = null;
        }
        verifyLicenseCompatibilityTask.unknown(licenseExpressionSet, (Action<LicenseCompatibilityConfig>)action);
    }

    @JvmOverloads
    public final void unknown(@NotNull LicenseExpressionSet licenseSet) {
        VerifyLicenseCompatibilityTask.unknown$default(this, licenseSet, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void run() {
        Object list$iv;
        void $this$groupByTo$iv;
        ResolvedLicenseCompatibility it$iv$iv2;
        ModuleComponentIdentifier it;
        Map map;
        Sequence $this$mapKeysTo$iv$iv;
        void $this$mapKeys$iv;
        Map<ModuleComponentIdentifier, LicenseInfo> dependencies = MetadataStore.load((Iterable)this.metadata).getDependencies();
        org.gradle.api.logging.Logger logger = this.getLogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
        GuessBasedNormalizer licenseNormalizer = new GuessBasedNormalizer((Logger)logger, ((Number)this.licenseSimilarityNormalizationThreshold.get()).intValue());
        LicenseEquivalence licenseEquivalence = new LicenseEquivalence(null, 1, null);
        Object object = this.resolvedCases.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"resolvedCases.get()");
        Map map2 = (Map)object;
        LicenseEquivalence licenseEquivalence2 = licenseEquivalence;
        boolean $i$f$mapKeys = false;
        void var6_7 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkExpressionValueIsNotNull(k, (String)"it.key");
            LicenseExpression licenseExpression = licenseNormalizer.normalize((LicenseExpression)k);
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            LicenseExpression licenseExpression2 = licenseExpression;
            Map map3 = map;
            boolean bl2 = false;
            Object v = it$iv$iv2.getValue();
            map3.put(licenseExpression2, v);
        }
        Map map4 = map = destination$iv$iv;
        LicenseEquivalence licenseEquivalence3 = licenseEquivalence2;
        LicenseCompatibilityInterpreter licenseCompatibilityInterpreter = new LicenseCompatibilityInterpreter(licenseEquivalence3, map4);
        StringBuilder ok = new StringBuilder();
        StringBuilder ko = new StringBuilder();
        $this$mapKeysTo$iv$iv = SequencesKt.map((Sequence)MapsKt.asSequence(dependencies), (Function1)run.1.INSTANCE);
        Map destination$iv = new TreeMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv : $this$groupByTo$iv) {
            Object object2;
            void component;
            LogLevel logLevel;
            Pair $dstr$component$license = (Pair)element$iv;
            boolean bl = false;
            it = (ModuleComponentIdentifier)$dstr$component$license.component1();
            LicenseExpression license = (LicenseExpression)$dstr$component$license.component2();
            it$iv$iv2 = licenseCompatibilityInterpreter.eval(license);
            boolean bl3 = false;
            boolean bl4 = false;
            ResolvedLicenseCompatibility it2 = it$iv$iv2;
            boolean $i$a$-also-VerifyLicenseCompatibilityTask$run$2$22 = false;
            org.gradle.api.logging.Logger logger2 = this.getLogger();
            switch (VerifyLicenseCompatibilityTask$WhenMappings.$EnumSwitchMapping$0[it2.getType().ordinal()]) {
                case 1: {
                    logLevel = LogLevel.DEBUG;
                    break;
                }
                case 2: {
                    logLevel = LogLevel.LIFECYCLE;
                    break;
                }
                case 3: {
                    logLevel = LogLevel.LIFECYCLE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            logger2.log(logLevel, "License compatibility for {}: {} -> {}", new Object[]{component, license, it2});
            ResolvedLicenseCompatibility key$iv = it$iv$iv2;
            Map $this$getOrPut$iv$iv = destination$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv);
            if (value$iv$iv == null) {
                boolean bl5 = false;
                List answer$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv.put(key$iv, answer$iv$iv);
                object2 = answer$iv$iv;
            } else {
                object2 = value$iv$iv;
            }
            list$iv = (List)object2;
            list$iv.add(element$iv);
        }
        Map $this$forEach$iv = destination$iv;
        boolean $i$f$forEach = false;
        Object object3 = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = object3.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$fold$iv;
            void licenseCompatibility;
            Map.Entry element$iv;
            Map.Entry $dstr$licenseCompatibility$components = element$iv = iterator.next();
            boolean bl6 = false;
            Map.Entry license = $dstr$licenseCompatibility$components;
            boolean it$iv$iv2 = false;
            ResolvedLicenseCompatibility resolvedLicenseCompatibility = (ResolvedLicenseCompatibility)license.getKey();
            license = $dstr$licenseCompatibility$components;
            it$iv$iv2 = false;
            List components = (List)license.getValue();
            String header = (Object)((Object)licenseCompatibility.getType()) + '\n' + CollectionsKt.joinToString$default((Iterable)licenseCompatibility.getReasons(), (CharSequence)"\n  ", (CharSequence)"  ", null, (int)0, null, null, (int)60, null);
            StringBuilder sb = licenseCompatibility.getType() == CompatibilityResult.ALLOW ? ok : ko;
            CharSequence it2 = sb;
            boolean $i$a$-also-VerifyLicenseCompatibilityTask$run$2$22 = false;
            if (it2.length() > 0) {
                sb.append('\n');
            }
            sb.append(header).append('\n');
            Iterable $i$a$-also-VerifyLicenseCompatibilityTask$run$2$22 = licenseCompatibility.getReasons();
            int initial$iv = licenseCompatibility.getType().toString().length();
            boolean $i$f$fold = false;
            int accumulator$iv = initial$iv;
            for (Object element$iv2 : $this$fold$iv) {
                void b;
                list$iv = (String)element$iv2;
                int a = accumulator$iv;
                boolean bl7 = false;
                accumulator$iv = RangesKt.coerceAtLeast((int)a, (int)(b.length() + 2));
            }
            int headerWidth = accumulator$iv;
            sb.append(StringsKt.repeat((CharSequence)"=", (int)headerWidth)).append('\n');
            this.appendComponents(sb, components);
        }
        String string = ko.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ko.toString()");
        String errorMessage = string;
        object3 = ko;
        bl = false;
        boolean bl8 = false;
        Object $this$apply = object3;
        boolean bl9 = false;
        CharSequence charSequence = (CharSequence)$this$apply;
        boolean bl10 = false;
        if (charSequence.length() > 0) {
            charSequence = ok;
            bl10 = false;
            if (charSequence.length() > 0) {
                ((StringBuilder)$this$apply).append('\n');
            }
        }
        ((StringBuilder)$this$apply).append((CharSequence)ok);
        while (StringsKt.endsWith$default((CharSequence)((CharSequence)$this$apply), (char)'\n', (boolean)false, (int)2, null)) {
            ((StringBuilder)$this$apply).setLength(((StringBuilder)$this$apply).length() - 1);
        }
        String string2 = ((StringBuilder)object3).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ko.apply {\n            i\u2026   }\n        }.toString()");
        String result = string2;
        Object object4 = this.printResults.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"printResults.get()");
        if (((Boolean)object4).booleanValue()) {
            boolean bl11 = false;
            System.out.println((Object)result);
        }
        Object object5 = this.outputFile.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"outputFile.get()");
        Object object6 = ((RegularFile)object5).getAsFile();
        bl = false;
        bl8 = false;
        $this$apply = object6;
        boolean bl12 = false;
        ((File)$this$apply).getParentFile().mkdirs();
        FilesKt.writeText$default((File)$this$apply, (String)result, null, (int)2, null);
        object6 = errorMessage;
        bl = false;
        if (object6.length() > 0) {
            Object object7 = this.failOnIncompatibleLicense.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object7, (String)"failOnIncompatibleLicense.get()");
            if (((Boolean)object7).booleanValue()) {
                throw (Throwable)new GradleException(errorMessage);
            }
            this.getLogger().warn(errorMessage);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void appendComponents(Appendable $this$appendComponents, List<? extends Pair<? extends ModuleComponentIdentifier, ? extends LicenseExpression>> components) {
        Object value$iv$iv;
        boolean $i$f$getOrPut;
        Map.Entry<LicenseExpression, List> $this$getOrPut$iv$iv;
        void $this$groupByTo$iv;
        Iterable iterable = components;
        Map destination$iv = new TreeMap(ComparisonsKt.nullsFirst(LicenseExpression.Companion.getNATURAL_ORDER()));
        boolean $i$f$groupByTo = false;
        for (Object element$iv : $this$groupByTo$iv) {
            Object object;
            Pair it = (Pair)element$iv;
            boolean bl = false;
            LicenseExpression key$iv = (LicenseExpression)it.getSecond();
            $this$getOrPut$iv$iv = destination$iv;
            $i$f$getOrPut = false;
            value$iv$iv = $this$getOrPut$iv$iv.get(key$iv);
            if (value$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv.put(key$iv, answer$iv$iv);
                object = answer$iv$iv;
            } else {
                object = value$iv$iv;
            }
            List list$iv = (List)object;
            it = (Pair)element$iv;
            List list = list$iv;
            boolean bl3 = false;
            ModuleComponentIdentifier moduleComponentIdentifier = (ModuleComponentIdentifier)it.getFirst();
            list.add(moduleComponentIdentifier);
        }
        Map $this$forEach$iv = destination$iv;
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void license;
            Map.Entry<LicenseExpression, List> element$iv;
            Map.Entry<LicenseExpression, List> $dstr$license$components = element$iv = iterator.next();
            boolean bl4 = false;
            $this$getOrPut$iv$iv = $dstr$license$components;
            $i$f$getOrPut = false;
            value$iv$iv = (LicenseExpression)$this$getOrPut$iv$iv.getKey();
            $this$getOrPut$iv$iv = $dstr$license$components;
            $i$f$getOrPut = false;
            List components2 = (List)$this$getOrPut$iv$iv.getValue();
            $this$appendComponents.append('\n');
            String string = license;
            if (string == null || (string = string.toString()) == null) {
                string = "Unknown license";
            }
            $this$appendComponents.append(string).append('\n');
            Iterable $this$forEach$iv2 = components2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ModuleComponentIdentifier it = (ModuleComponentIdentifier)element$iv2;
                boolean bl5 = false;
                $this$appendComponents.append("* " + it.getDisplayName() + '\n');
            }
        }
    }

    @Inject
    public VerifyLicenseCompatibilityTask(@NotNull ObjectFactory objectFactory, @NotNull ProjectLayout layout) {
        Intrinsics.checkParameterIsNotNull((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkParameterIsNotNull((Object)layout, (String)"layout");
        ConfigurableFileCollection configurableFileCollection = objectFactory.fileCollection();
        Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection, (String)"objectFactory.fileCollection()");
        this.metadata = configurableFileCollection;
        ObjectFactory $this$property$iv = objectFactory;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(Boolean.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        Property property2 = property.convention((Object)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)property2, (String)"objectFactory.property<Boolean>().convention(true)");
        this.failOnIncompatibleLicense = property2;
        ObjectFactory $this$mapProperty$iv = objectFactory;
        boolean $i$f$mapProperty = false;
        MapProperty mapProperty = $this$mapProperty$iv.mapProperty(LicenseExpression.class, LicenseCompatibility.class);
        Intrinsics.checkNotNullExpressionValue((Object)mapProperty, (String)"mapProperty(K::class.java, V::class.java)");
        this.resolvedCases = mapProperty;
        $this$property$iv = objectFactory;
        $i$f$property = false;
        Property property3 = $this$property$iv.property(Integer.class);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"property(T::class.java)");
        Property property4 = property3.convention((Object)42);
        Intrinsics.checkExpressionValueIsNotNull((Object)property4, (String)"objectFactory.property<Int>().convention(42)");
        this.licenseSimilarityNormalizationThreshold = property4;
        $this$property$iv = objectFactory;
        $i$f$property = false;
        Property property5 = $this$property$iv.property(Boolean.class);
        Intrinsics.checkNotNullExpressionValue((Object)property5, (String)"property(T::class.java)");
        Property property6 = property5.convention((Object)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)property6, (String)"objectFactory.property<B\u2026lean>().convention(false)");
        this.printResults = property6;
        RegularFileProperty regularFileProperty = objectFactory.fileProperty().convention(layout.getBuildDirectory().file("verifyLicense/" + this.getName() + "/verification_result.txt"));
        Intrinsics.checkExpressionValueIsNotNull((Object)regularFileProperty, (String)"objectFactory.fileProper\u2026erification_result.txt\"))");
        this.outputFile = regularFileProperty;
    }
}

