/*
 * Decompiled with CFR 0.152.
 */
package com.github.vlsi.gradle.license.api;

import com.github.vlsi.gradle.license.api.DefaultLicenseParser;
import com.github.vlsi.gradle.license.api.JustLicense;
import com.github.vlsi.gradle.license.api.LicenseExpression;
import com.github.vlsi.gradle.license.api.LicenseExpressionParser;
import com.github.vlsi.gradle.license.api.LicenseExpressionParser$WhenMappings;
import com.github.vlsi.gradle.license.api.LicenseParser;
import com.github.vlsi.gradle.license.api.ParseException;
import com.github.vlsi.gradle.license.api.SimpleLicenseExpression;
import com.github.vlsi.gradle.license.api.Token;
import com.github.vlsi.gradle.license.api.TokenType;
import java.util.ArrayDeque;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/github/vlsi/gradle/license/api/LicenseExpressionParser;", "", "titleParser", "Lcom/github/vlsi/gradle/license/api/LicenseParser;", "(Lcom/github/vlsi/gradle/license/api/LicenseParser;)V", "parse", "Lcom/github/vlsi/gradle/license/api/LicenseExpression;", "value", "", "tokenize", "Lkotlin/sequences/Sequence;", "Lcom/github/vlsi/gradle/license/api/Token;", "Companion", "license-gather-plugin"})
public final class LicenseExpressionParser {
    private final LicenseParser titleParser;
    private static final Regex tokenRegex;
    @NotNull
    public static final Companion Companion;

    private final Sequence<Token> tokenize(String $this$tokenize) {
        return SequencesKt.map((Sequence)Regex.findAll$default((Regex)tokenRegex, (CharSequence)$this$tokenize, (int)0, (int)2, null), (Function1)tokenize.1.INSTANCE);
    }

    @NotNull
    public final LicenseExpression parse(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        ArrayDeque<Token> operators = new ArrayDeque<Token>();
        ArrayDeque<Token> rpn = new ArrayDeque<Token>();
        for (Token t : this.tokenize(value)) {
            switch (LicenseExpressionParser$WhenMappings.$EnumSwitchMapping$0[t.getType().ordinal()]) {
                case 1: {
                    rpn.add(t);
                    break;
                }
                case 2: {
                    operators.push(t);
                    break;
                }
                case 3: {
                    Object op;
                    boolean bl;
                    while (true) {
                        Collection collection = operators;
                        bl = false;
                        if (!(!collection.isEmpty()) || ((Token)(op = (Token)operators.peek())).getType() == TokenType.LBRACE) break;
                        rpn.add((Token)operators.pop());
                    }
                    if (operators.isEmpty()) {
                        throw (Throwable)new ParseException("Unmatched closing brace " + t, t.getPosition(), value, null, 8, null);
                    }
                    operators.pop();
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    Object op;
                    boolean bl;
                    while (true) {
                        op = operators;
                        bl = false;
                        if (!(!op.isEmpty()) || ((Token)operators.peek()).getType().compareTo((Enum)t.getType()) < 0) break;
                        rpn.add((Token)operators.pop());
                    }
                    operators.push(t);
                    break;
                }
            }
        }
        rpn.addAll((Collection)operators);
        ArrayDeque<LicenseExpression> result = new ArrayDeque<LicenseExpression>();
        while (true) {
            Collection collection = rpn;
            boolean op = false;
            if (!(!collection.isEmpty())) break;
            Token t = (Token)rpn.removeFirst();
            switch (LicenseExpressionParser$WhenMappings.$EnumSwitchMapping$1[t.getType().ordinal()]) {
                case 1: {
                    if (Intrinsics.areEqual((Object)t.getValue(), (Object)"NONE")) {
                        result.push(LicenseExpression.NONE.INSTANCE);
                        break;
                    }
                    if (Intrinsics.areEqual((Object)t.getValue(), (Object)"NOASSERION")) {
                        result.push(LicenseExpression.NOASSERTION.INSTANCE);
                        break;
                    }
                    Token token = (Token)rpn.peekFirst();
                    if ((token != null ? token.getType() : null) != TokenType.WITH) {
                        result.push(this.titleParser.parseLicense(t.getValue()).getExpression());
                        break;
                    }
                    Token withToken = (Token)rpn.pop();
                    LicenseExpression license = (LicenseExpression)result.pop();
                    if (!(license instanceof SimpleLicenseExpression)) {
                        throw (Throwable)new ParseException("Left argument of 'with exception' must be a SimpleLicenseExpression. Actual argument is " + Reflection.getOrCreateKotlinClass(license.getClass()).getSimpleName() + ": [" + license + ']', withToken.getPosition(), value, null, 8, null);
                    }
                    result.push(((SimpleLicenseExpression)license).with(this.titleParser.parseException(t.getValue())));
                    break;
                }
                case 2: {
                    if (result.size() < 2) {
                        throw (Throwable)new ParseException("OR expression requires two arguments", t.getPosition(), value, null, 8, null);
                    }
                    LicenseExpression licenseExpression = (LicenseExpression)result.pop();
                    Object e = result.pop();
                    Intrinsics.checkExpressionValueIsNotNull(e, (String)"result.pop()");
                    result.push(licenseExpression.or((LicenseExpression)e));
                    break;
                }
                case 3: {
                    if (result.size() < 2) {
                        throw (Throwable)new ParseException("AND expression requires two arguments", t.getPosition(), value, null, 8, null);
                    }
                    LicenseExpression licenseExpression = (LicenseExpression)result.pop();
                    Object e = result.pop();
                    Intrinsics.checkExpressionValueIsNotNull(e, (String)"result.pop()");
                    result.push(licenseExpression.and((LicenseExpression)e));
                    break;
                }
                case 4: {
                    LicenseExpression exception = (LicenseExpression)result.poll();
                    LicenseExpression license = (LicenseExpression)result.poll();
                    throw (Throwable)new ParseException("'With exception' should be applied to SimpleLicenseExpression and LicenseException. Actual arguments are [" + license + "] and [" + exception + ']', t.getPosition(), value, null, 8, null);
                }
                case 5: {
                    LicenseExpression license = (LicenseExpression)result.pop();
                    if (!(license instanceof JustLicense)) {
                        throw (Throwable)new ParseException("'Or later' modifier can be applied to License only. Actual argument is " + Reflection.getOrCreateKotlinClass(license.getClass()).getSimpleName() + ": [" + license + ']', t.getPosition(), value, null, 8, null);
                    }
                    result.push(((JustLicense)license).getOrLater());
                    break;
                }
                case 6: {
                    throw (Throwable)new ParseException("Unclosed open brace", t.getPosition(), value, null, 8, null);
                }
                case 7: {
                    throw (Throwable)new ParseException("Extra closing brace", t.getPosition(), value, null, 8, null);
                }
            }
        }
        if (result.isEmpty()) {
            int n = 0;
            throw (Throwable)new ParseException("Result is empty", new IntRange(n, 0), value, null, 8, null);
        }
        if (result.size() > 1) {
            int n = 0;
            throw (Throwable)new ParseException("Multiple expressions in the output. Probably, AND/OR is missing: [" + result + ']', new IntRange(n, 0), value, null, 8, null);
        }
        Object e = result.getFirst();
        Intrinsics.checkExpressionValueIsNotNull(e, (String)"result.first");
        return (LicenseExpression)e;
    }

    public LicenseExpressionParser(@NotNull LicenseParser titleParser) {
        Intrinsics.checkParameterIsNotNull((Object)titleParser, (String)"titleParser");
        this.titleParser = titleParser;
    }

    public /* synthetic */ LicenseExpressionParser(LicenseParser licenseParser, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            licenseParser = DefaultLicenseParser.INSTANCE;
        }
        this(licenseParser);
    }

    public LicenseExpressionParser() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        tokenRegex = new Regex("[-A-Za-z0-9_.]+|[()+]");
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/vlsi/gradle/license/api/LicenseExpressionParser$Companion;", "", "()V", "tokenRegex", "Lkotlin/text/Regex;", "license-gather-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

