/*
 * Decompiled with CFR 0.152.
 */
package com.github.vlsi.gradle.license.api;

import com.github.vlsi.gradle.license.api.LicenseExpression;
import com.github.vlsi.gradle.license.api.LicenseExpressionParser;
import com.github.vlsi.gradle.license.api.ParseException;
import java.net.URI;
import java.net.URISyntaxException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/github/vlsi/gradle/license/api/OsgiBundleLicenseParser;", "", "licenseExpressionParser", "Lcom/github/vlsi/gradle/license/api/LicenseExpressionParser;", "lookupLicenseByUri", "Lkotlin/Function1;", "Ljava/net/URI;", "Lcom/github/vlsi/gradle/license/api/LicenseExpression;", "(Lcom/github/vlsi/gradle/license/api/LicenseExpressionParser;Lkotlin/jvm/functions/Function1;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "parseOrNull", "bundleLicense", "", "context", "license-gather-plugin"})
public final class OsgiBundleLicenseParser {
    private final Logger logger;
    private final LicenseExpressionParser licenseExpressionParser;
    private final Function1<URI, LicenseExpression> lookupLicenseByUri;

    @Nullable
    public final LicenseExpression parseOrNull(@NotNull String bundleLicense, @NotNull Object context) {
        LicenseExpression licenseExpression;
        Intrinsics.checkParameterIsNotNull((Object)bundleLicense, (String)"bundleLicense");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (StringsKt.contains$default((CharSequence)bundleLicense, (char)',', (boolean)false, (int)2, null)) {
            this.logger.info("Ignoring Bundle-License '{}' in {} since it contains multiple license references", (Object)bundleLicense, context);
            licenseExpression = null;
        } else if (StringsKt.startsWith$default((String)bundleLicense, (String)"http", (boolean)false, (int)2, null)) {
            URI uRI;
            try {
                uRI = new URI(bundleLicense);
            }
            catch (URISyntaxException e) {
                this.logger.info("Invalid URI for license in Bundle-License value '{}' in {}", new Object[]{bundleLicense, context, e});
                return null;
            }
            URI uri = uRI;
            licenseExpression = (LicenseExpression)this.lookupLicenseByUri.invoke((Object)uri);
        } else {
            LicenseExpression licenseExpression2;
            String string = StringsKt.substringBefore$default((String)bundleLicense, (String)";", null, (int)2, null);
            boolean bl = false;
            boolean bl2 = false;
            String it = string;
            boolean bl3 = false;
            try {
                licenseExpression2 = this.licenseExpressionParser.parse(it);
            }
            catch (ParseException e) {
                this.logger.info("Unable to parse Bundle-License value '{}' in {}", new Object[]{bundleLicense, context, e});
                licenseExpression2 = null;
            }
            licenseExpression = licenseExpression2;
        }
        return licenseExpression;
    }

    public OsgiBundleLicenseParser(@NotNull LicenseExpressionParser licenseExpressionParser, @NotNull Function1<? super URI, ? extends LicenseExpression> lookupLicenseByUri) {
        Intrinsics.checkParameterIsNotNull((Object)licenseExpressionParser, (String)"licenseExpressionParser");
        Intrinsics.checkParameterIsNotNull(lookupLicenseByUri, (String)"lookupLicenseByUri");
        this.licenseExpressionParser = licenseExpressionParser;
        this.lookupLicenseByUri = lookupLicenseByUri;
        this.logger = LoggerFactory.getLogger(OsgiBundleLicenseParser.class);
    }
}

