/*
 * Decompiled with CFR 0.152.
 */
package com.github.vlsi.gradle.license;

import com.github.vlsi.gradle.AppendPlatformLineKt;
import com.github.vlsi.gradle.license.ErrorLanguage;
import com.github.vlsi.gradle.license.FindLicenseKt;
import com.github.vlsi.gradle.license.FindLicenseParameters;
import com.github.vlsi.gradle.license.FindLicenseWorkAction;
import com.github.vlsi.gradle.license.GatherLicenseTask;
import com.github.vlsi.gradle.license.GatherLicenseTaskKt;
import com.github.vlsi.gradle.license.GuessBasedNormalizer;
import com.github.vlsi.gradle.license.LicenseInfo;
import com.github.vlsi.gradle.license.LicenseOverride;
import com.github.vlsi.gradle.license.LicenseOverrideSpec;
import com.github.vlsi.gradle.license.LicenseOverrides;
import com.github.vlsi.gradle.license.MetadataStore;
import com.github.vlsi.gradle.license.PomLicenseLoaderKt;
import com.github.vlsi.gradle.license.Predictor;
import com.github.vlsi.gradle.license.Result;
import com.github.vlsi.gradle.license.SpdxPredictorKt;
import com.github.vlsi.gradle.license.api.DependencyInfo;
import com.github.vlsi.gradle.license.api.JustLicense;
import com.github.vlsi.gradle.license.api.License;
import com.github.vlsi.gradle.license.api.LicenseExpression;
import com.github.vlsi.gradle.license.api.LicenseExpressionParser;
import com.github.vlsi.gradle.license.api.OsgiBundleLicenseParser;
import com.github.vlsi.gradle.license.api.SpdxLicense;
import groovy.util.slurpersupport.GPathResult;
import java.io.Closeable;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.jar.JarFile;
import javax.inject.Inject;
import kotlin.ExceptionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.kotlin.dsl.DependencyHandlerScope;
import org.gradle.kotlin.dsl.NamedDomainObjectCollectionExtensionsKt;
import org.gradle.kotlin.dsl.ProjectExtensionsKt;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u00e2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u00122\u0006\u00109\u001a\u00020:J\u0016\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u00122\u0006\u0010;\u001a\u00020\rJ@\u00106\u001a\u00020.2\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020?0=2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020.2\u0006\u0010C\u001a\u00020\u00122\n\b\u0002\u0010D\u001a\u0004\u0018\u00010.H\u0002J\u000e\u0010E\u001a\u0002072\u0006\u0010F\u001a\u00020\tJ\u0016\u0010E\u001a\u0002072\u000e\u0010F\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0GJ\u0016\u0010H\u001a\u0002072\u0006\u00108\u001a\u00020\u00122\u0006\u00109\u001a\u00020:J\u0016\u0010H\u001a\u0002072\u0006\u00108\u001a\u00020\u00122\u0006\u0010;\u001a\u00020\rJ*\u0010I\u001a\u0002072\u0012\u0010J\u001a\u000e\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020?0=2\f\u0010K\u001a\b\u0012\u0004\u0012\u00020M0LH\u0002J$\u0010N\u001a\u0002072\u0012\u0010J\u001a\u000e\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020?0=2\u0006\u0010)\u001a\u00020*H\u0002J$\u0010O\u001a\u0002072\u0012\u0010J\u001a\u000e\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020?0=2\u0006\u0010P\u001a\u00020QH\u0002J\u000e\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00120SH\u0005J\u000e\u0010T\u001a\b\u0012\u0004\u0012\u00020\u00120UH\u0005J\u000e\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00120UH\u0005J\u000e\u0010%\u001a\u0002072\u0006\u00109\u001a\u00020:J\u000e\u0010%\u001a\u0002072\u0006\u00109\u001a\u00020\rJ\u0016\u0010W\u001a\u0002072\u0006\u00108\u001a\u00020\u00122\u0006\u00109\u001a\u00020:J\u0016\u0010W\u001a\u0002072\u0006\u00108\u001a\u00020\u00122\u0006\u0010;\u001a\u00020\rJ\u001c\u0010W\u001a\u0002072\u0006\u0010X\u001a\u00020\u00122\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020[0ZJ\b\u0010\\\u001a\u000207H\u0007J\u0018\u0010]\u001a\u000207*\u00060^j\u0002`_2\u0006\u0010`\u001a\u00020\u0012H\u0002J\f\u0010a\u001a\u00020b*\u00020.H\u0002J\u0015\u0010c\u001a\u00020d*\u00020d2\u0006\u0010e\u001a\u00020\u0012H\u0086\u0002J\f\u0010f\u001a\u00020\r*\u00020gH\u0002R\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR$\u0010\f\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\"\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00118\u0004X\u0085\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u0015\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\u00170\u00170\u00168\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\"\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00118\u0004X\u0085\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0014R\u001b\u0010\u001c\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010!\u001a\u00020\"8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020\r0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u000bR\u0016\u0010'\u001a\u00020\"8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010$R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010-\u001a\u00020.8G\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u001c\u00101\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010\u000bR$\u00103\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u000104040\u00168\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006h"}, d2={"Lcom/github/vlsi/gradle/license/GatherLicenseTask;", "Lorg/gradle/api/DefaultTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/workers/WorkerExecutor;)V", "configurations", "Lorg/gradle/api/provider/SetProperty;", "Lorg/gradle/api/artifacts/Configuration;", "getConfigurations", "()Lorg/gradle/api/provider/SetProperty;", "defaultTextFor", "Lcom/github/vlsi/gradle/license/api/LicenseExpression;", "kotlin.jvm.PlatformType", "getDefaultTextFor", "effectiveLicenses", "Lorg/gradle/api/provider/MapProperty;", "", "getEffectiveLicenses", "()Lorg/gradle/api/provider/MapProperty;", "errorLanguage", "Lorg/gradle/api/provider/Property;", "Lcom/github/vlsi/gradle/license/ErrorLanguage;", "getErrorLanguage", "()Lorg/gradle/api/provider/Property;", "expectedLicenses", "getExpectedLicenses", "extraDeps", "getExtraDeps", "()Lorg/gradle/api/artifacts/Configuration;", "extraDeps$delegate", "Lkotlin/Lazy;", "extraLicenseDir", "Lorg/gradle/api/file/DirectoryProperty;", "getExtraLicenseDir", "()Lorg/gradle/api/file/DirectoryProperty;", "ignoreMissingLicenseFor", "getIgnoreMissingLicenseFor", "licenseDir", "getLicenseDir", "licenseExpressionParser", "Lcom/github/vlsi/gradle/license/api/LicenseExpressionParser;", "licenseOverrides", "Lcom/github/vlsi/gradle/license/LicenseOverrides;", "licensesXml", "Ljava/io/File;", "getLicensesXml", "()Ljava/io/File;", "nonResolvableConfigurations", "getNonResolvableConfigurations", "similarityThreshold", "", "getSimilarityThreshold", "addDependency", "", "module", "license", "Lcom/github/vlsi/gradle/license/api/License;", "licenseExpression", "allDependencies", "", "Lorg/gradle/api/artifacts/component/ComponentIdentifier;", "Lcom/github/vlsi/gradle/license/LicenseInfo;", "compId", "Lorg/gradle/api/artifacts/component/ModuleComponentIdentifier;", "licenseTextDir", "outDirectoryName", "artifactFile", "configuration", "conf", "Lorg/gradle/api/provider/Provider;", "expectLicense", "findLicenseFromFiles", "detectedLicenses", "model", "Lcom/github/vlsi/gradle/license/Predictor;", "Lcom/github/vlsi/gradle/license/api/SpdxLicense;", "findManifestLicenses", "findPomLicenses", "licenseNormalizer", "Lcom/github/vlsi/gradle/license/GuessBasedNormalizer;", "getExtraArtifacts", "", "getIgnoreMissingLicense", "", "getIncludeDefaultTextFor", "overrideLicense", "id", "action", "Lorg/gradle/api/Action;", "Lcom/github/vlsi/gradle/license/LicenseOverrideSpec;", "run", "appendTitle", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "title", "containsLicenseFile", "", "get", "Lgroovy/util/slurpersupport/GPathResult;", "name", "toLicenseExpression", "", "license-gather-plugin"})
public class GatherLicenseTask
extends DefaultTask {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    private final SetProperty<Configuration> configurations;
    @Internal
    @NotNull
    private final SetProperty<Configuration> nonResolvableConfigurations;
    @Input
    @NotNull
    private final Property<Integer> similarityThreshold;
    @Input
    @Optional
    @NotNull
    private final MapProperty<String, String> expectedLicenses;
    @Input
    @Optional
    @NotNull
    private final MapProperty<String, String> effectiveLicenses;
    @Console
    @NotNull
    private final Property<ErrorLanguage> errorLanguage;
    @Internal
    @NotNull
    private final SetProperty<LicenseExpression> defaultTextFor;
    @Internal
    @NotNull
    private final SetProperty<LicenseExpression> ignoreMissingLicenseFor;
    private final LicenseOverrides licenseOverrides;
    @OutputDirectory
    @NotNull
    private final DirectoryProperty licenseDir;
    @InputFiles
    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    private final DirectoryProperty extraLicenseDir;
    private final Lazy extraDeps$delegate;
    private final LicenseExpressionParser licenseExpressionParser;
    private final WorkerExecutor workerExecutor;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(GatherLicenseTask.class), "extraDeps", "getExtraDeps()Lorg/gradle/api/artifacts/Configuration;"))};
    }

    @NotNull
    public final SetProperty<Configuration> getConfigurations() {
        return this.configurations;
    }

    /*
     * WARNING - void declaration
     */
    @Input
    @NotNull
    protected final Set<String> getExtraArtifacts() {
        void var2_3;
        void $this$flatMapTo$iv;
        Object object = this.nonResolvableConfigurations.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"nonResolvableConfigurations.get()");
        Iterable iterable = (Iterable)object;
        boolean bl = false;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            void $this$mapTo$iv$iv;
            Configuration conf = (Configuration)element$iv;
            boolean bl2 = false;
            Configuration configuration = conf;
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"conf");
            DependencySet dependencySet = configuration.getAllDependencies();
            Intrinsics.checkExpressionValueIsNotNull((Object)dependencySet, (String)"conf.allDependencies");
            Iterable $this$map$iv = (Iterable)dependencySet;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Dependency dependency = (Dependency)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                String string = it.toString();
                collection.add(string);
            }
            Iterable list$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (Set)var2_3;
    }

    @NotNull
    public final SetProperty<Configuration> getNonResolvableConfigurations() {
        return this.nonResolvableConfigurations;
    }

    @NotNull
    public final Property<Integer> getSimilarityThreshold() {
        return this.similarityThreshold;
    }

    @NotNull
    protected final MapProperty<String, String> getExpectedLicenses() {
        return this.expectedLicenses;
    }

    @NotNull
    protected final MapProperty<String, String> getEffectiveLicenses() {
        return this.effectiveLicenses;
    }

    @NotNull
    public final Property<ErrorLanguage> getErrorLanguage() {
        return this.errorLanguage;
    }

    /*
     * WARNING - void declaration
     */
    @Input
    @Optional
    @NotNull
    protected final Set<String> getIncludeDefaultTextFor() {
        void var2_3;
        void $this$mapTo$iv;
        Object object = this.defaultTextFor.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"defaultTextFor.get()");
        Iterable iterable = (Iterable)object;
        boolean bl = false;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            LicenseExpression licenseExpression = (LicenseExpression)item$iv;
            Collection collection = destination$iv;
            boolean bl2 = false;
            String string = it.toString();
            collection.add(string);
        }
        return (Set)var2_3;
    }

    @NotNull
    public final SetProperty<LicenseExpression> getDefaultTextFor() {
        return this.defaultTextFor;
    }

    /*
     * WARNING - void declaration
     */
    @Input
    @Optional
    @NotNull
    protected final Set<String> getIgnoreMissingLicense() {
        void var2_3;
        void $this$mapTo$iv;
        Object object = this.ignoreMissingLicenseFor.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ignoreMissingLicenseFor.get()");
        Iterable iterable = (Iterable)object;
        boolean bl = false;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            LicenseExpression licenseExpression = (LicenseExpression)item$iv;
            Collection collection = destination$iv;
            boolean bl2 = false;
            String string = it.toString();
            collection.add(string);
        }
        return (Set)var2_3;
    }

    @NotNull
    public final SetProperty<LicenseExpression> getIgnoreMissingLicenseFor() {
        return this.ignoreMissingLicenseFor;
    }

    public final void ignoreMissingLicenseFor(@NotNull License license) {
        Intrinsics.checkParameterIsNotNull((Object)license, (String)"license");
        this.ignoreMissingLicenseFor(license.getExpression());
    }

    public final void ignoreMissingLicenseFor(@NotNull LicenseExpression license) {
        Intrinsics.checkParameterIsNotNull((Object)license, (String)"license");
        this.ignoreMissingLicenseFor.add((Object)license);
    }

    @NotNull
    public final DirectoryProperty getLicenseDir() {
        return this.licenseDir;
    }

    @NotNull
    public final DirectoryProperty getExtraLicenseDir() {
        return this.extraLicenseDir;
    }

    @Internal
    @NotNull
    public final File getLicensesXml() {
        RegularFile regularFile = ((Directory)this.licenseDir.get()).file("license.xml");
        Intrinsics.checkExpressionValueIsNotNull((Object)regularFile, (String)"licenseDir.get().file(\"license.xml\")");
        File file = regularFile.getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"licenseDir.get().file(\"license.xml\").asFile");
        return file;
    }

    private final Configuration getExtraDeps() {
        Lazy lazy = this.extraDeps$delegate;
        GatherLicenseTask gatherLicenseTask = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (Configuration)lazy.getValue();
    }

    public final void addDependency(@NotNull String module, @NotNull License license) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)license, (String)"license");
        this.addDependency(module, license.getExpression());
    }

    public final void addDependency(@NotNull String module, @NotNull LicenseExpression licenseExpression) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)licenseExpression, (String)"licenseExpression");
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        ProjectExtensionsKt.dependencies((Project)project, (Function1)((Function1)new Function1<DependencyHandlerScope, Unit>(this, module, licenseExpression){
            final /* synthetic */ GatherLicenseTask this$0;
            final /* synthetic */ String $module;
            final /* synthetic */ LicenseExpression $licenseExpression;

            public final void invoke(@NotNull DependencyHandlerScope $this$dependencies) {
                String string;
                StringBuilder stringBuilder;
                block7: {
                    block6: {
                        String string2;
                        String it;
                        StringBuilder stringBuilder2;
                        boolean bl;
                        boolean bl2;
                        String string3;
                        String string4;
                        StringBuilder stringBuilder3;
                        Dependency dep;
                        block5: {
                            block4: {
                                Intrinsics.checkParameterIsNotNull((Object)$this$dependencies, (String)"$receiver");
                                dep = $this$dependencies.create((Object)this.$module);
                                $this$dependencies.invoke(GatherLicenseTask.access$getExtraDeps$p(this.this$0), (Object)dep);
                                stringBuilder3 = new StringBuilder();
                                string4 = dep.getGroup();
                                if (string4 == null) break block4;
                                string3 = string4;
                                bl2 = false;
                                bl = false;
                                String string5 = string3;
                                stringBuilder2 = stringBuilder3;
                                boolean bl3 = false;
                                string2 = it + ':';
                                stringBuilder3 = stringBuilder2;
                                string4 = string2;
                                if (string4 != null) break block5;
                            }
                            string4 = "";
                        }
                        stringBuilder = stringBuilder3.append(string4).append(dep.getName());
                        string = dep.getVersion();
                        if (string == null) break block6;
                        string3 = string;
                        bl2 = false;
                        bl = false;
                        it = string3;
                        stringBuilder2 = stringBuilder;
                        boolean bl4 = false;
                        string2 = ':' + it;
                        stringBuilder = stringBuilder2;
                        string = string2;
                        if (string != null) break block7;
                    }
                    string = "";
                }
                String overrideId = stringBuilder.append(string).toString();
                this.this$0.overrideLicense(overrideId, this.$licenseExpression);
            }
            {
                this.this$0 = gatherLicenseTask;
                this.$module = string;
                this.$licenseExpression = licenseExpression;
                super(1);
            }
        }));
    }

    public final void expectLicense(@NotNull String module, @NotNull License license) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)license, (String)"license");
        this.expectLicense(module, license.getExpression());
    }

    public final void expectLicense(@NotNull String module, @NotNull LicenseExpression licenseExpression) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)licenseExpression, (String)"licenseExpression");
        this.overrideLicense(module, (Action<LicenseOverrideSpec>)((Action)new Action<LicenseOverrideSpec>(licenseExpression){
            final /* synthetic */ LicenseExpression $licenseExpression;

            public final void execute(@NotNull LicenseOverrideSpec $this$overrideLicense) {
                Intrinsics.checkParameterIsNotNull((Object)$this$overrideLicense, (String)"$receiver");
                $this$overrideLicense.setExpectedLicense(this.$licenseExpression);
            }
            {
                this.$licenseExpression = licenseExpression;
            }
        }));
    }

    public final void overrideLicense(@NotNull String module, @NotNull License license) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)license, (String)"license");
        this.overrideLicense(module, license.getExpression());
    }

    public final void overrideLicense(@NotNull String module, @NotNull LicenseExpression licenseExpression) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)licenseExpression, (String)"licenseExpression");
        this.overrideLicense(module, (Action<LicenseOverrideSpec>)((Action)new Action<LicenseOverrideSpec>(licenseExpression){
            final /* synthetic */ LicenseExpression $licenseExpression;

            public final void execute(@NotNull LicenseOverrideSpec $this$overrideLicense) {
                Intrinsics.checkParameterIsNotNull((Object)$this$overrideLicense, (String)"$receiver");
                $this$overrideLicense.setEffectiveLicense(this.$licenseExpression);
            }
            {
                this.$licenseExpression = licenseExpression;
            }
        }));
    }

    private final LicenseExpression toLicenseExpression(Object $this$toLicenseExpression) {
        LicenseExpression licenseExpression;
        Object object = $this$toLicenseExpression;
        if (object instanceof String) {
            licenseExpression = this.licenseExpressionParser.parse((String)$this$toLicenseExpression);
        } else if (object instanceof License) {
            licenseExpression = ((License)$this$toLicenseExpression).getExpression();
        } else if (object instanceof LicenseExpression) {
            licenseExpression = (LicenseExpression)$this$toLicenseExpression;
        } else {
            throw (Throwable)new GradleException("Illegal value " + $this$toLicenseExpression + " for LicenseExpression. Expecting String, License, or LicenseExpression");
        }
        return licenseExpression;
    }

    /*
     * WARNING - void declaration
     */
    public final void overrideLicense(@NotNull String id, @NotNull Action<LicenseOverrideSpec> action) {
        File file;
        Object it;
        boolean bl;
        boolean bl2;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        LicenseOverrideSpec s = new LicenseOverrideSpec();
        action.execute((Object)s);
        if (s.getEffectiveLicense() == null && s.getExpectedLicense() == null && s.getLicenseFiles() == null) {
            return;
        }
        Object object2 = s.getExpectedLicense();
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl3 = false;
            this.expectedLicenses.put((Object)id, (Object)it.toString());
        }
        Object object3 = s.getEffectiveLicense();
        if (object3 != null) {
            object = object3;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl4 = false;
            this.effectiveLicenses.put((Object)id, (Object)it.toString());
        }
        Object object4 = s.getExpectedLicense();
        LicenseExpression licenseExpression = object4 != null ? this.toLicenseExpression(object4) : null;
        Object object5 = s.getEffectiveLicense();
        LicenseExpression licenseExpression2 = object5 != null ? this.toLicenseExpression(object5) : null;
        Object object6 = s.getLicenseFiles();
        if (object6 != null) {
            File file2;
            void it2;
            Object object7 = object6;
            bl = false;
            boolean bl5 = false;
            Object bl4 = object7;
            LicenseExpression licenseExpression3 = licenseExpression2;
            LicenseExpression licenseExpression4 = licenseExpression;
            boolean bl6 = false;
            void var10_18 = it2;
            if (var10_18 instanceof String) {
                RegularFile regularFile = ((Directory)this.extraLicenseDir.get()).file((String)it2);
                Intrinsics.checkExpressionValueIsNotNull((Object)regularFile, (String)"extraLicenseDir.get().file(it)");
                file2 = regularFile.getAsFile();
            } else {
                file2 = var10_18 instanceof File ? (File)it2 : null;
            }
            File file3 = file2;
            licenseExpression = licenseExpression4;
            licenseExpression2 = licenseExpression3;
            file = file3;
        } else {
            file = null;
        }
        File file4 = file;
        LicenseExpression licenseExpression5 = licenseExpression2;
        LicenseExpression licenseExpression6 = licenseExpression;
        LicenseOverride override = new LicenseOverride(licenseExpression6, licenseExpression5, file4);
        LicenseOverride licenseOverride = this.licenseOverrides.get(id);
        if (licenseOverride != null) {
            LicenseOverride licenseOverride2 = licenseOverride;
            bl = false;
            boolean bl7 = false;
            LicenseOverride prev = licenseOverride2;
            boolean bl8 = false;
            this.getLogger().warn("Duplicate license override for {}. prev={}, new={}", new Object[]{id, prev, override});
        }
        this.licenseOverrides.set(id, override);
    }

    public final void configuration(@NotNull Configuration conf) {
        Intrinsics.checkParameterIsNotNull((Object)conf, (String)"conf");
        (conf.isCanBeResolved() ? this.configurations : this.nonResolvableConfigurations).add((Object)conf);
    }

    public final void configuration(@NotNull Provider<? extends Configuration> conf) {
        Intrinsics.checkParameterIsNotNull(conf, (String)"conf");
        this.configurations.add(conf);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean containsLicenseFile(File $this$containsLicenseFile) {
        boolean bl;
        Sequence $this$any$iv = (Sequence)FilesKt.walk$default((File)$this$containsLicenseFile, null, (int)1, null);
        boolean $i$f$any = false;
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            File it = (File)element$iv;
            boolean bl2 = false;
            if (it.isFile()) {
                String string = it.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name");
                if (FindLicenseKt.looksLikeLicense(string)) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void run() {
        boolean $i$f$forEach;
        Object $this$forEach$iv;
        Iterator text2;
        SpdxLicense it;
        boolean bl10;
        Map $this$mapTo$iv$iv;
        Object object;
        Object object2;
        Object it2;
        void $this$filterTo$iv$iv;
        boolean bl2 = false;
        Map allDependencies = new LinkedHashMap();
        Object object3 = this.licenseDir.dir("texts").get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"licenseDir.dir(\"texts\").get()");
        File file = ((Directory)object3).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"licenseDir.dir(\"texts\").get().asFile");
        File licenseTextDir = file;
        this.licenseOverrides.configurationComplete();
        for (Configuration c : (Set)this.nonResolvableConfigurations.get()) {
            this.getLogger().debug("Analyzing configuration " + c);
            Configuration configuration = c;
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"c");
            for (Object dep : configuration.getAllDependencies()) {
                Dependency dependency = dep;
                Intrinsics.checkExpressionValueIsNotNull((Object)dependency, (String)"dep");
                String string = dependency.getGroup();
                if (string == null) {
                    string = dep.getName();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dep.group ?: dep.name");
                String string2 = dep.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dep.name");
                String string3 = dep.getVersion();
                if (string3 == null) {
                    string3 = "";
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"dep.version ?: \"\"");
                ModuleComponentIdentifier compId = GatherLicenseTaskKt.moduleComponentId(string, string2, string3);
                GatherLicenseTask.addDependency$default(this, allDependencies, compId, licenseTextDir, compId.getGroup() + '/' + compId.getModule() + '-' + compId.getVersion(), null, 16, null);
            }
        }
        boolean haveFilesToAnalyze = false;
        Object object4 = this.configurations.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"configurations.get()");
        Iterable $this$filter$iv = (Iterable)object4;
        boolean $i$f$filter2 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
            it2 = (Configuration)element$iv$iv2;
            boolean bl3 = false;
            Configuration configuration = it2;
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"it");
            if (!configuration.isCanBeResolved()) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        for (Configuration c : (List)destination$iv$iv) {
            this.getLogger().debug("Analyzing configuration " + c);
            Configuration configuration = c;
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"c");
            ResolvedConfiguration resolvedConfiguration = configuration.getResolvedConfiguration();
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedConfiguration, (String)"c.resolvedConfiguration");
            Iterator $i$f$filter2 = resolvedConfiguration.getResolvedArtifacts().iterator();
            while ($i$f$filter2.hasNext()) {
                void workActionClass$iv;
                void $this$submit$iv;
                String string;
                StringBuilder stringBuilder;
                File file2;
                ModuleComponentIdentifier moduleComponentIdentifier;
                Object object5;
                Object object6;
                ComponentIdentifier compId;
                ResolvedArtifact art;
                Object element$iv$iv2;
                block46: {
                    block45: {
                        void it3;
                        String string4;
                        ResolvedArtifact resolvedArtifact = art = (ResolvedArtifact)$i$f$filter2.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifact, (String)"art");
                        ComponentArtifactIdentifier componentArtifactIdentifier = resolvedArtifact.getId();
                        Intrinsics.checkExpressionValueIsNotNull((Object)componentArtifactIdentifier, (String)"art.id");
                        Intrinsics.checkExpressionValueIsNotNull((Object)componentArtifactIdentifier.getComponentIdentifier(), (String)"art.id.componentIdentifier");
                        if (allDependencies.containsKey(compId) || compId instanceof ProjectComponentIdentifier) continue;
                        if (!(compId instanceof ModuleComponentIdentifier)) {
                            this.getLogger().warn("GatherLicenseTask supports only ModuleComponentIdentifier for now. Input component " + compId + " is of type " + Reflection.getOrCreateKotlinClass(compId.getClass()).getSimpleName());
                            continue;
                        }
                        if (art.getClassifier() != null) {
                            boolean bl4 = false;
                            boolean element$iv$iv2 = false;
                            it2 = $i$f$filterTo;
                            boolean bl5 = false;
                            string4 = '-' + (String)it2;
                        } else {
                            string4 = null;
                        }
                        String classifier = string4;
                        object6 = this;
                        object5 = allDependencies;
                        moduleComponentIdentifier = (ModuleComponentIdentifier)compId;
                        file2 = licenseTextDir;
                        stringBuilder = new StringBuilder().append(((ModuleComponentIdentifier)compId).getGroup()).append('/').append(((ModuleComponentIdentifier)compId).getModule()).append('-').append(((ModuleComponentIdentifier)compId).getVersion());
                        string = classifier;
                        if (string == null) break block45;
                        String string5 = string;
                        boolean element$iv$iv2 = false;
                        boolean it4 = false;
                        String bl5 = string5;
                        StringBuilder stringBuilder2 = stringBuilder;
                        File file3 = file2;
                        ModuleComponentIdentifier moduleComponentIdentifier2 = moduleComponentIdentifier;
                        object2 = object5;
                        object = object6;
                        boolean bl6 = false;
                        String string6 = '-' + (String)it3;
                        object6 = object;
                        object5 = object2;
                        moduleComponentIdentifier = moduleComponentIdentifier2;
                        file2 = file3;
                        stringBuilder = stringBuilder2;
                        string = string6;
                        if (string != null) break block46;
                    }
                    string = "";
                }
                File artLicenseTexts = object6.addDependency((Map<ComponentIdentifier, LicenseInfo>)object5, moduleComponentIdentifier, file2, stringBuilder.append(string).toString(), art.getFile());
                haveFilesToAnalyze = true;
                Intrinsics.checkExpressionValueIsNotNull((Object)this.workerExecutor.noIsolation(), (String)"workerExecutor.noIsolation()");
                element$iv$iv2 = FindLicenseWorkAction.class;
                Action parameterAction$iv = (Action)new Action<FindLicenseParameters>(compId, art, artLicenseTexts){
                    final /* synthetic */ ComponentIdentifier $compId;
                    final /* synthetic */ ResolvedArtifact $art;
                    final /* synthetic */ File $artLicenseTexts;

                    public final void execute(@NotNull FindLicenseParameters $this$submit) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$submit, (String)"$receiver");
                        $this$submit.getId().set((Object)((ModuleComponentIdentifier)this.$compId).getDisplayName());
                        Property<File> property = $this$submit.getFile();
                        ResolvedArtifact resolvedArtifact = this.$art;
                        Intrinsics.checkExpressionValueIsNotNull((Object)resolvedArtifact, (String)"art");
                        property.set((Object)resolvedArtifact.getFile());
                        $this$submit.getOutputDir().set((Object)this.$artLicenseTexts);
                    }
                    {
                        this.$compId = componentIdentifier;
                        this.$art = resolvedArtifact;
                        this.$artLicenseTexts = file;
                    }
                };
                boolean $i$f$submit = false;
                $this$submit$iv.submit((Class)workActionClass$iv, parameterAction$iv);
            }
        }
        Predictor<SpdxLicense> predictor = !haveFilesToAnalyze ? null : SpdxPredictorKt.getSpdxPredictor();
        this.workerExecutor.await();
        org.gradle.api.logging.Logger logger = this.getLogger();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
        GuessBasedNormalizer licenseNormalizer = new GuessBasedNormalizer((Logger)logger, ((Number)this.similarityThreshold.get()).intValue());
        if (predictor != null) {
            this.findManifestLicenses(allDependencies, this.licenseExpressionParser);
            this.findPomLicenses(allDependencies, licenseNormalizer);
            this.findLicenseFromFiles(allDependencies, predictor);
        }
        boolean $i$f$filter2 = false;
        List missingLicenseId = new ArrayList();
        boolean compId = false;
        List missingLicenseFile = new ArrayList();
        boolean classifier = false;
        List nonModuleDependency = new ArrayList();
        boolean artLicenseTexts = false;
        Map metadata = new LinkedHashMap();
        boolean $this$submit$iv = false;
        Map licenseTextCache = new LinkedHashMap();
        Object object7 = this.ignoreMissingLicenseFor.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object7, (String)"ignoreMissingLicenseFor.get()");
        Object $this$map$iv = (Iterable)object7;
        boolean $i$f$map22 = false;
        Iterable $i$f$submit = $this$map$iv;
        Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        Iterator<Object> iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv = iterator.next();
            LicenseExpression licenseExpression = (LicenseExpression)item$iv$iv;
            object = destination$iv$iv22;
            bl10 = false;
            void v22 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v22, (String)"it");
            object2 = licenseNormalizer.normalize((LicenseExpression)v22);
            object.add(object2);
        }
        List ignoreMissingLicenseFor = (List)destination$iv$iv22;
        $this$mapTo$iv$iv = allDependencies;
        boolean destination$iv$iv22 = false;
        Object $i$f$map22 = $this$mapTo$iv$iv.entrySet().iterator();
        while ($i$f$map22.hasNext()) {
            File licenseFiles;
            void id;
            Object $i$f$mapTo2 = $this$map$iv = $i$f$map22.next();
            boolean bl7 = false;
            $this$mapTo$iv$iv = (ComponentIdentifier)$i$f$mapTo2.getKey();
            $i$f$mapTo2 = $this$map$iv;
            bl7 = false;
            LicenseInfo licenseInfo = (LicenseInfo)$i$f$mapTo2.getValue();
            if (licenseInfo.getLicense() == null) {
                missingLicenseId.add(id);
            }
            if ((licenseFiles = licenseInfo.getLicenseFiles()) != null && !this.containsLicenseFile(licenseFiles)) {
                LicenseExpression licenseExpression = licenseInfo.getLicense();
                if (licenseExpression != null && ignoreMissingLicenseFor.contains(licenseExpression)) {
                    this.getLogger().debug("No LICENSE file detected for component " + id.getDisplayName() + " however licenseid " + licenseExpression + " is included in ignoreMissingLicenseFor set." + " Will skip creating a default LICENSE for that component.");
                } else {
                    Object object8;
                    if (!((Set)this.defaultTextFor.get()).contains(licenseExpression)) {
                        this.getLogger().debug("The identified licenseid " + licenseExpression + " for component " + id.getDisplayName() + "is not included in defaultTextFor set: " + this.defaultTextFor + '.' + " Will skip creating a default LICENSE for that component.");
                        object8 = null;
                    } else {
                        LicenseExpression licenseExpression2 = licenseExpression;
                        if (!(licenseExpression2 instanceof JustLicense)) {
                            licenseExpression2 = null;
                        }
                        JustLicense justLicense = (JustLicense)licenseExpression2;
                        License license = justLicense != null ? justLicense.getLicense() : null;
                        if (!(license instanceof SpdxLicense)) {
                            license = null;
                        }
                        if ((SpdxLicense)license != null) {
                            bl10 = false;
                            boolean bl8 = false;
                            SpdxLicense spdx = it;
                            boolean bl9 = false;
                            object8 = (String)licenseTextCache.computeIfAbsent(spdx, run.text.1.1.INSTANCE);
                        } else {
                            object8 = text2 = null;
                        }
                    }
                    if (text2 == null) {
                        missingLicenseFile.add(id);
                    } else {
                        if (!licenseFiles.isDirectory() && !licenseFiles.mkdirs()) {
                            throw (Throwable)new GradleException("Unable to create directory " + licenseFiles);
                        }
                        FilesKt.writeText$default((File)new File(licenseFiles, "LICENSE"), text2, null, (int)2, null);
                    }
                }
            }
            if (!(id instanceof ModuleComponentIdentifier)) {
                nonModuleDependency.add(id);
                continue;
            }
            metadata.put(id, licenseInfo);
        }
        Object object9 = this.licenseDir.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object9, (String)"licenseDir.get()");
        File file4 = ((Directory)object9).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"licenseDir.get().asFile");
        MetadataStore.save(file4, new DependencyInfo(metadata));
        StringBuilder sb = new StringBuilder();
        $i$f$map22 = missingLicenseId;
        boolean id = false;
        if (!$i$f$map22.isEmpty()) {
            Iterator $this$mapTo$iv$iv22;
            this.appendTitle(sb, "LicenseID is not specified for components");
            Iterable $this$map$iv2 = missingLicenseId;
            boolean $i$f$map = false;
            Iterable licenseInfo = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo3 = false;
            text2 = $this$mapTo$iv$iv22.iterator();
            while (text2.hasNext()) {
                void it5;
                Object item$iv$iv = text2.next();
                ComponentIdentifier bl10 = (ComponentIdentifier)item$iv$iv;
                object = destination$iv$iv3;
                boolean bl11 = false;
                object2 = it5.getDisplayName();
                object.add(object2);
            }
            $this$forEach$iv = CollectionsKt.sorted((Iterable)((List)destination$iv$iv3));
            $i$f$forEach = false;
            $this$mapTo$iv$iv22 = $this$forEach$iv.iterator();
            while ($this$mapTo$iv$iv22.hasNext()) {
                Object element$iv = $this$mapTo$iv$iv22.next();
                String it6 = (String)element$iv;
                boolean bl12 = false;
                AppendPlatformLineKt.appendPlatformLine(sb, "* " + it6);
            }
        }
        $this$forEach$iv = nonModuleDependency;
        $i$f$forEach = false;
        if (!$this$forEach$iv.isEmpty()) {
            this.appendTitle(sb, "Only ModuleComponentIdentifier are supported for now");
            Iterable $this$sortedBy$iv = missingLicenseId;
            boolean $i$f$sortedBy = false;
            boolean $this$mapTo$iv$iv22 = false;
            $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    ComponentIdentifier it = (ComponentIdentifier)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)it.getDisplayName());
                    it = (ComponentIdentifier)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string = it.getDisplayName();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            });
            $i$f$forEach = false;
            Iterator $this$mapTo$iv$iv22 = $this$forEach$iv.iterator();
            while ($this$mapTo$iv$iv22.hasNext()) {
                Object element$iv = $this$mapTo$iv$iv22.next();
                ComponentIdentifier it7 = (ComponentIdentifier)element$iv;
                boolean bl13 = false;
                AppendPlatformLineKt.appendPlatformLine(sb, "* " + it7.getDisplayName() + " (" + Reflection.getOrCreateKotlinClass(it7.getClass()).getSimpleName());
            }
        }
        $this$forEach$iv = missingLicenseFile;
        $i$f$forEach = false;
        if (!$this$forEach$iv.isEmpty()) {
            Iterable list$iv;
            void $this$groupByTo$iv;
            this.appendTitle(sb, "LICENSE-like files are missing");
            $this$forEach$iv = missingLicenseFile;
            Map destination$iv = new TreeMap(ComparisonsKt.nullsFirst(LicenseExpression.Companion.getNATURAL_ORDER()));
            boolean $i$f$groupByTo = false;
            for (Object element$iv : $this$groupByTo$iv) {
                Object object10;
                ComponentIdentifier it8 = (ComponentIdentifier)element$iv;
                boolean bl14 = false;
                LicenseInfo licenseInfo = (LicenseInfo)allDependencies.get(it8);
                LicenseExpression key$iv = licenseInfo != null ? licenseInfo.getLicense() : null;
                Map $this$getOrPut$iv$iv = destination$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv);
                if (value$iv$iv == null) {
                    boolean bl15 = false;
                    List answer$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv.put(key$iv, answer$iv$iv);
                    object10 = answer$iv$iv;
                } else {
                    object10 = value$iv$iv;
                }
                list$iv = (List)object10;
                list$iv.add(element$iv);
            }
            $this$forEach$iv = destination$iv;
            $i$f$forEach = false;
            Object object11 = $this$forEach$iv;
            boolean bl16 = false;
            iterator = object11.entrySet().iterator();
            while (iterator.hasNext()) {
                void $this$mapTo$iv$iv2;
                void license;
                Map.Entry element$iv;
                Map.Entry $dstr$license$ids = element$iv = (Map.Entry)iterator.next();
                boolean bl17 = false;
                Map.Entry $this$getOrPut$iv$iv = $dstr$license$ids;
                boolean $i$f$getOrPut = false;
                LicenseExpression value$iv$iv = (LicenseExpression)$this$getOrPut$iv$iv.getKey();
                $this$getOrPut$iv$iv = $dstr$license$ids;
                $i$f$getOrPut = false;
                List ids = (List)$this$getOrPut$iv$iv.getValue();
                AppendPlatformLineKt.appendPlatformLine(sb);
                Appendable appendable = sb;
                String string = license;
                if (string == null || (string = string.toString()) == null) {
                    string = "Unknown license";
                }
                AppendPlatformLineKt.appendPlatformLine(appendable, string);
                Iterable $this$map$iv3 = ids;
                boolean $i$f$map = false;
                list$iv = $this$map$iv3;
                Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo4 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it9;
                    ComponentIdentifier componentIdentifier = (ComponentIdentifier)item$iv$iv;
                    Collection collection = destination$iv$iv4;
                    boolean bl18 = false;
                    String string7 = it9.getDisplayName();
                    collection.add(string7);
                }
                Iterable $this$forEach$iv2 = (List)destination$iv$iv4;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String it10 = (String)element$iv2;
                    boolean bl19 = false;
                    AppendPlatformLineKt.appendPlatformLine(sb, "* " + it10);
                }
            }
        }
        Set<String> unusedOverrides = this.licenseOverrides.getUnusedOverrides();
        Object object12 = unusedOverrides;
        boolean bl20 = false;
        if (!object12.isEmpty()) {
            this.getLogger().warn("License overrides were declared but unused for the following dependencies: {}", (Object)CollectionsKt.sorted((Iterable)unusedOverrides));
        }
        object12 = sb;
        bl20 = false;
        if (object12.length() > 0) {
            throw (Throwable)new GradleException(sb.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final File addDependency(Map<ComponentIdentifier, LicenseInfo> allDependencies, ModuleComponentIdentifier compId, File licenseTextDir, String outDirectoryName, File artifactFile) {
        File file;
        File f;
        LicenseExpression licenseExpression;
        LicenseOverride licenseOverride;
        String outDir = outDirectoryName + (StringsKt.endsWith$default((String)outDirectoryName, (String)".jar", (boolean)false, (int)2, null) ? ".contents" : "");
        File artLicenseTexts = new File(licenseTextDir, outDir);
        if (artLicenseTexts.isDirectory()) {
            this.getProject().delete(new Object[]{artLicenseTexts});
        }
        if ((licenseOverride = this.licenseOverrides.get(compId)) != null) {
            this.getLogger().debug("Using license override for {}: {}", (Object)compId, (Object)licenseOverride);
        }
        LicenseOverride licenseOverride2 = licenseOverride;
        if ((licenseOverride2 != null ? licenseOverride2.getExpectedLicense() : null) == null) {
            LicenseOverride licenseOverride3 = licenseOverride;
            licenseExpression = licenseOverride3 != null ? licenseOverride3.getEffectiveLicense() : null;
        } else {
            licenseExpression = null;
        }
        allDependencies.put((ComponentIdentifier)compId, new LicenseInfo(licenseExpression, artifactFile, artLicenseTexts, outDir));
        LicenseOverride licenseOverride4 = licenseOverride;
        File file2 = f = licenseOverride4 != null ? licenseOverride4.getLicenseFiles() : null;
        if (f == null) {
            Object v8;
            block11: {
                void $this$mapTo$iv$iv;
                Object[] objectArray = new String[2];
                objectArray[0] = compId.getModule() + '-' + compId.getVersion();
                String string = compId.getModule();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"compId.module");
                objectArray[1] = string;
                Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Directory directory = ((Directory)this.extraLicenseDir.get()).dir((String)it);
                    Intrinsics.checkExpressionValueIsNotNull((Object)directory, (String)"extraLicenseDir.get().dir(it)");
                    File file3 = directory.getAsFile();
                    collection.add(file3);
                }
                Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    File it = (File)element$iv;
                    boolean bl = false;
                    if (!it.exists()) continue;
                    v8 = element$iv;
                    break block11;
                }
                v8 = null;
            }
            file = v8;
        } else if (f.exists()) {
            file = f;
        } else {
            throw (Throwable)new GradleException("licenseFiles folder " + f + " specified for component " + compId.getDisplayName() + " does not exists");
        }
        File licenseFiles = file;
        if (licenseFiles != null) {
            this.getProject().copy((Action)new Action<CopySpec>(artLicenseTexts, licenseFiles){
                final /* synthetic */ File $artLicenseTexts;
                final /* synthetic */ File $licenseFiles;

                public final void execute(@NotNull CopySpec $this$copy) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$copy, (String)"$receiver");
                    $this$copy.into((Object)this.$artLicenseTexts);
                    $this$copy.from(new Object[]{this.$licenseFiles});
                }
                {
                    this.$artLicenseTexts = file;
                    this.$licenseFiles = file2;
                }
            });
        }
        return artLicenseTexts;
    }

    static /* synthetic */ File addDependency$default(GatherLicenseTask gatherLicenseTask, Map map, ModuleComponentIdentifier moduleComponentIdentifier, File file, String string, File file2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addDependency");
        }
        if ((n & 0x10) != 0) {
            file2 = null;
        }
        return gatherLicenseTask.addDependency(map, moduleComponentIdentifier, file, string, file2);
    }

    private final void appendTitle(StringBuilder $this$appendTitle, String title) {
        CharSequence charSequence = $this$appendTitle;
        boolean bl = false;
        if (charSequence.length() > 0) {
            $this$appendTitle.append("\n");
        }
        AppendPlatformLineKt.appendPlatformLine($this$appendTitle, title);
        AppendPlatformLineKt.appendPlatformLine($this$appendTitle, StringsKt.repeat((CharSequence)"=", (int)title.length()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void findManifestLicenses(Map<ComponentIdentifier, LicenseInfo> detectedLicenses, LicenseExpressionParser licenseExpressionParser) {
        bundleLicenseParser = new OsgiBundleLicenseParser(licenseExpressionParser, (Function1<? super URI, ? extends LicenseExpression>)((Function1)findManifestLicenses.bundleLicenseParser.1.INSTANCE));
        var6_4 = detectedLicenses;
        var7_5 = false;
        for (Map.Entry<ComponentIdentifier, LicenseInfo> e : var6_4.entrySet()) {
            if (e.getValue().getLicense() != null) continue;
            file = e.getValue().getFile();
            if (file == null) {
                this.getLogger().debug("No file is specified for artifact {}. Will skip MANIFEST.MF check", (Object)e.getKey());
                continue;
            }
            if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"jar") ^ true) {
                this.getLogger().debug("File {} for artifact {} does not look like a JAR. Will skip MANIFEST.MF check", (Object)file, (Object)e.getKey());
                continue;
            }
            this.getLogger().debug("Will check if file {} for artifact {} has Bundle-License in MANIFEST.MF", (Object)file, (Object)e.getKey());
            try {
                var7_6 = new JarFile(file);
                var8_10 = false;
                var9_12 = false;
                var9_11 = null;
                try {
                    jar = (JarFile)var7_6;
                    $i$a$-use-GatherLicenseTask$findManifestLicenses$1 = false;
                    v0 = jar.getManifest();
                    if (v0 == null || (v0 = v0.getMainAttributes()) == null || (v0 = v0.getValue("Bundle-License")) == null) ** GOTO lbl-1000
                    var12_17 = v0;
                    var13_18 = false;
                    var14_19 = false;
                    it = var12_17;
                    $i$a$-let-GatherLicenseTask$findManifestLicenses$1$1 = false;
                    v0 = bundleLicenseParser.parseOrNull((String)it, file);
                    if (v0 != null) {
                        var12_17 = v0;
                        var13_18 = false;
                        var14_19 = false;
                        license = var12_17;
                        $i$a$-let-GatherLicenseTask$findManifestLicenses$1$2 = false;
                        this.getLogger().debug("Detected license for " + e.getKey() + ": " + license);
                        v1 = e.setValue(LicenseInfo.copy$default(e.getValue(), (LicenseExpression)license, null, null, null, 14, null));
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = null;
                    }
                    var10_13 = v1;
                }
                catch (Throwable var10_14) {
                    var9_11 = var10_14;
                    throw var10_14;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)var7_6, (Throwable)var9_11);
                }
            }
            catch (Throwable e) {
                this.getLogger().warn("Unable to parse Bundle-License from {}", (Object)file, (Object)e);
            }
        }
    }

    @NotNull
    public final GPathResult get(@NotNull GPathResult $this$get, @NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)$this$get, (String)"$this$get");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Object object = $this$get.getProperty(name);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type groovy.util.slurpersupport.GPathResult");
        }
        return (GPathResult)object;
    }

    /*
     * WARNING - void declaration
     */
    private final void findPomLicenses(Map<ComponentIdentifier, LicenseInfo> detectedLicenses, GuessBasedNormalizer licenseNormalizer) {
        void $this$filterTo$iv$iv222;
        Map<ComponentIdentifier, LicenseInfo> $this$filter$iv = detectedLicenses;
        boolean $i$f$filter = false;
        Map<ComponentIdentifier, LicenseInfo> map = $this$filter$iv;
        Map destination$iv$iv22 = new LinkedHashMap();
        boolean $i$f$filterTo2 = false;
        Iterator iterator = $this$filterTo$iv$iv222;
        boolean bl = false;
        Iterator iterator2 = iterator.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl2 = false;
            if (!(((LicenseInfo)it.getValue()).getLicense() == null)) continue;
            destination$iv$iv22.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        List compIds = CollectionsKt.toList((Iterable)destination$iv$iv22.keySet());
        if (compIds.isEmpty()) {
            return;
        }
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        List<Result<LicenseExpression>> licenses = PomLicenseLoaderKt.loadLicenses(compIds, project, this.licenseOverrides, licenseNormalizer);
        boolean $this$filterTo$iv$iv222 = false;
        List failures = new ArrayList();
        for (Pair $this$filterTo$iv$iv222 : CollectionsKt.zip((Iterable)compIds, (Iterable)licenses)) {
            LicenseExpression license;
            void id;
            ComponentIdentifier $i$f$filterTo2 = (ComponentIdentifier)$this$filterTo$iv$iv222.component1();
            Result licenseResult = (Result)$this$filterTo$iv$iv222.component2();
            if (licenseResult.isFailure()) {
                Throwable throwable = licenseResult.exceptionOrNull();
                if (throwable == null) {
                    Intrinsics.throwNpe();
                }
                failures.add(throwable);
                continue;
            }
            if ((LicenseExpression)licenseResult.getOrNull() == null) {
                continue;
            }
            detectedLicenses.compute((ComponentIdentifier)id, new BiFunction<ComponentIdentifier, LicenseInfo, LicenseInfo>(license){
                final /* synthetic */ LicenseExpression $license;

                @Nullable
                public final LicenseInfo apply(@NotNull ComponentIdentifier $noName_0, @Nullable LicenseInfo v) {
                    Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                    LicenseInfo licenseInfo = v;
                    if (licenseInfo == null) {
                        Intrinsics.throwNpe();
                    }
                    return LicenseInfo.copy$default(licenseInfo, this.$license, null, null, null, 14, null);
                }
                {
                    this.$license = licenseExpression;
                }
            });
        }
        Collection $this$filterTo$iv$iv222 = failures;
        boolean destination$iv$iv22 = false;
        if (!$this$filterTo$iv$iv222.isEmpty()) {
            GradleException res2 = new GradleException(CollectionsKt.joinToString$default((Iterable)failures, (CharSequence)"\n", null, null, (int)0, null, (Function1)findPomLicenses.res.1.INSTANCE, (int)30, null));
            Iterable $this$forEach$iv = failures;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Throwable it = (Throwable)element$iv;
                boolean bl3 = false;
                ExceptionsKt.addSuppressed((Throwable)((Throwable)res2), (Throwable)it);
            }
            throw (Throwable)res2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void findLicenseFromFiles(Map<ComponentIdentifier, LicenseInfo> detectedLicenses, Predictor<SpdxLicense> model) {
        Map<ComponentIdentifier, LicenseInfo> map = detectedLicenses;
        boolean bl = false;
        for (Map.Entry<ComponentIdentifier, LicenseInfo> e : map.entrySet()) {
            void $this$flatMapTo$iv$iv;
            File licenseDir = e.getValue().getLicenseFiles();
            if (e.getValue().getLicense() != null || licenseDir == null) continue;
            ConfigurableFileTree configurableFileTree = this.getProject().fileTree((Object)licenseDir, (Action)findLicenseFromFiles.bestLicenses.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileTree, (String)"project.fileTree(license\u2026e(\"**\")\n                }");
            Iterable $this$flatMap$iv = (Iterable)configurableFileTree;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                File f = (File)element$iv$iv;
                boolean bl2 = false;
                File file = f;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"f");
                Iterable $this$sortedByDescending$iv = model.predict(FilesKt.readText$default((File)file, null, (int)1, null)).entrySet();
                boolean $i$f$sortedByDescending = false;
                boolean bl3 = false;
                Iterable list$iv$iv = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        Map.Entry it = (Map.Entry)b;
                        boolean bl2 = false;
                        Comparable comparable = (Double)it.getValue();
                        it = (Map.Entry)a;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Double d = (Double)it.getValue();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
                    }
                }), (int)5);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Object $this$sortedByDescending$iv = (List)destination$iv$iv;
            boolean $i$f$sortedByDescending = false;
            boolean bl4 = false;
            List bestLicenses2 = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    Map.Entry it = (Map.Entry)b;
                    boolean bl2 = false;
                    Comparable comparable = (Double)it.getValue();
                    it = (Map.Entry)a;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Double d = (Double)it.getValue();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
                }
            }), (int)5);
            $this$sortedByDescending$iv = bestLicenses2;
            $i$f$sortedByDescending = false;
            if (!$this$sortedByDescending$iv.isEmpty()) {
                void licenseId;
                Map.Entry entry;
                Map.Entry entry2 = entry = (Map.Entry)CollectionsKt.first((List)bestLicenses2);
                boolean bl5 = false;
                $this$sortedByDescending$iv = (SpdxLicense)entry2.getKey();
                entry2 = entry;
                bl5 = false;
                double similarity = ((Number)entry2.getValue()).doubleValue();
                double d = similarity * (double)100;
                Object object = this.similarityThreshold.get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"similarityThreshold.get()");
                if (Double.compare(d, ((Number)object).doubleValue()) < 0) {
                    throw (Throwable)new GradleException("Unable to identify license for " + e.getKey() + '.' + " Best matching license is " + licenseId + ',' + " however similarity is " + similarity * (double)100 + "% which is less" + " than similarityThreshold=" + (Integer)this.similarityThreshold.get() + '.' + " Possible licenses are " + bestLicenses2);
                }
                this.getLogger().info("Detected license in {} to mean {}. Consider using SPDX id or specify the license explicitly", (Object)licenseDir, (Object)licenseId);
                e.setValue(LicenseInfo.copy$default(e.getValue(), this.toLicenseExpression(licenseId), null, null, null, 14, null));
                continue;
            }
            throw (Throwable)new GradleException("Unable to identify license for " + e.getKey());
        }
    }

    @Inject
    public GatherLicenseTask(@NotNull ObjectFactory objectFactory, @NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkParameterIsNotNull((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkParameterIsNotNull((Object)workerExecutor, (String)"workerExecutor");
        this.workerExecutor = workerExecutor;
        this.getOutputs().upToDateWhen((Spec)new Spec<Task>(){

            public final boolean isSatisfiedBy(Task it) {
                return licenseOverrides.isEmpty();
            }
        });
        ObjectFactory $this$setProperty$iv = objectFactory;
        boolean $i$f$setProperty = false;
        SetProperty setProperty = $this$setProperty$iv.setProperty(Configuration.class);
        Intrinsics.checkNotNullExpressionValue((Object)setProperty, (String)"setProperty(T::class.java)");
        this.configurations = setProperty;
        $this$setProperty$iv = objectFactory;
        $i$f$setProperty = false;
        SetProperty setProperty2 = $this$setProperty$iv.setProperty(Configuration.class);
        Intrinsics.checkNotNullExpressionValue((Object)setProperty2, (String)"setProperty(T::class.java)");
        this.nonResolvableConfigurations = setProperty2;
        ObjectFactory $this$property$iv = objectFactory;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(Integer.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        Property property2 = property.convention((Object)42);
        Intrinsics.checkExpressionValueIsNotNull((Object)property2, (String)"objectFactory.property<Int>().convention(42)");
        this.similarityThreshold = property2;
        ObjectFactory $this$mapProperty$iv = objectFactory;
        boolean $i$f$mapProperty = false;
        MapProperty mapProperty = $this$mapProperty$iv.mapProperty(String.class, String.class);
        Intrinsics.checkNotNullExpressionValue((Object)mapProperty, (String)"mapProperty(K::class.java, V::class.java)");
        this.expectedLicenses = mapProperty;
        $this$mapProperty$iv = objectFactory;
        $i$f$mapProperty = false;
        MapProperty mapProperty2 = $this$mapProperty$iv.mapProperty(String.class, String.class);
        Intrinsics.checkNotNullExpressionValue((Object)mapProperty2, (String)"mapProperty(K::class.java, V::class.java)");
        this.effectiveLicenses = mapProperty2;
        $this$property$iv = objectFactory;
        $i$f$property = false;
        Property property3 = $this$property$iv.property(ErrorLanguage.class);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"property(T::class.java)");
        Property property4 = property3.convention((Object)ErrorLanguage.KOTLIN);
        Intrinsics.checkExpressionValueIsNotNull((Object)property4, (String)"objectFactory.property<E\u2026ion(ErrorLanguage.KOTLIN)");
        this.errorLanguage = property4;
        $this$setProperty$iv = objectFactory;
        $i$f$setProperty = false;
        SetProperty setProperty3 = $this$setProperty$iv.setProperty(LicenseExpression.class);
        Intrinsics.checkNotNullExpressionValue((Object)setProperty3, (String)"setProperty(T::class.java)");
        SetProperty setProperty4 = setProperty3.convention((Iterable)CollectionsKt.listOf((Object[])new JustLicense[]{SpdxLicense.Apache_2_0.getExpression(), SpdxLicense.MPL_2_0.getExpression()}));
        Intrinsics.checkExpressionValueIsNotNull((Object)setProperty4, (String)"objectFactory.setPropert\u2026          )\n            )");
        this.defaultTextFor = setProperty4;
        $this$setProperty$iv = objectFactory;
        $i$f$setProperty = false;
        SetProperty setProperty5 = $this$setProperty$iv.setProperty(LicenseExpression.class);
        Intrinsics.checkNotNullExpressionValue((Object)setProperty5, (String)"setProperty(T::class.java)");
        this.ignoreMissingLicenseFor = setProperty5;
        this.licenseOverrides = new LicenseOverrides();
        DirectoryProperty directoryProperty = objectFactory.directoryProperty();
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        ProjectLayout projectLayout = project.getLayout();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectLayout, (String)"project.layout");
        DirectoryProperty directoryProperty2 = directoryProperty.convention(projectLayout.getBuildDirectory().dir("licenses/" + this.getName()));
        Intrinsics.checkExpressionValueIsNotNull((Object)directoryProperty2, (String)"objectFactory.directoryP\u2026r(\"licenses/$name\")\n    )");
        this.licenseDir = directoryProperty2;
        DirectoryProperty directoryProperty3 = objectFactory.directoryProperty();
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        ProjectLayout projectLayout2 = project2.getLayout();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectLayout2, (String)"project.layout");
        DirectoryProperty directoryProperty4 = directoryProperty3.convention(projectLayout2.getProjectDirectory().dir("licenses"));
        Intrinsics.checkExpressionValueIsNotNull((Object)directoryProperty4, (String)"objectFactory.directoryP\u2026ory.dir(\"licenses\")\n    )");
        this.extraLicenseDir = directoryProperty4;
        this.extraDeps$delegate = (Lazy)NamedDomainObjectCollectionExtensionsKt.provideDelegate((Object)LazyKt.lazy((Function0)((Function0)new Function0<Configuration>(this){
            final /* synthetic */ GatherLicenseTask this$0;

            @NotNull
            public final Configuration invoke() {
                Project project = this.this$0.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                Object object = project.getConfigurations().create(this.this$0.getName() + "_dependencies", (Action)extraDeps.1.INSTANCE);
                boolean bl = false;
                boolean bl2 = false;
                Configuration it = (Configuration)object;
                boolean bl3 = false;
                Configuration configuration = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"it");
                this.this$0.configuration(configuration);
                Object object2 = object;
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"project.configurations.c\u2026lso { configuration(it) }");
                return (Configuration)object2;
            }
            {
                this.this$0 = gatherLicenseTask;
                super(0);
            }
        })), (Object)((Object)this), (KProperty)$$delegatedProperties[0]);
        this.licenseExpressionParser = new LicenseExpressionParser(null, 1, null);
    }

    public static final /* synthetic */ Configuration access$getExtraDeps$p(GatherLicenseTask $this) {
        return $this.getExtraDeps();
    }
}

