/*
 * Decompiled with CFR 0.152.
 */
package com.github.vlsi.gradle.license.api;

import com.github.vlsi.gradle.license.api.ConjunctionLicenseExpression;
import com.github.vlsi.gradle.license.api.DisjunctionLicenseExpression;
import com.github.vlsi.gradle.license.api.JustLicense;
import com.github.vlsi.gradle.license.api.License;
import com.github.vlsi.gradle.license.api.LicenseException;
import com.github.vlsi.gradle.license.api.LicenseExpression;
import com.github.vlsi.gradle.license.api.LicenseExpressionNormalizer;
import com.github.vlsi.gradle.license.api.OrLaterLicense;
import com.github.vlsi.gradle.license.api.SimpleLicense;
import com.github.vlsi.gradle.license.api.SimpleLicenseExpression;
import com.github.vlsi.gradle.license.api.WithException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u000e\u0010\u0003\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J8\u0010\u0003\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0018\u0010\n\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\t\u0012\u0004\u0012\u00020\u00060\u000bH\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J1\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000f2\u0017\u0010\n\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\u0002\b\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/github/vlsi/gradle/license/api/LicenseExpressionNormalizer;", "", "()V", "normalize", "Lcom/github/vlsi/gradle/license/api/LicenseException;", "exception", "Lcom/github/vlsi/gradle/license/api/LicenseExpression;", "expression", "set", "", "action", "Lkotlin/Function1;", "license", "Lcom/github/vlsi/gradle/license/api/SimpleLicense;", "normalizeLicense", "Lcom/github/vlsi/gradle/license/api/License;", "Lkotlin/ExtensionFunctionType;", "license-gather-plugin"})
public abstract class LicenseExpressionNormalizer {
    @Nullable
    public LicenseExpression normalize(@NotNull SimpleLicense license) {
        Intrinsics.checkParameterIsNotNull((Object)license, (String)"license");
        return null;
    }

    @NotNull
    public LicenseException normalize(@NotNull LicenseException exception) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        return exception;
    }

    private final LicenseExpression normalizeLicense(LicenseExpression expression, License license, Function1<? super License, ? extends LicenseExpression> action) {
        LicenseExpression licenseExpression;
        License license2 = license;
        if (license2 instanceof SimpleLicense) {
            LicenseExpression next = this.normalize((SimpleLicense)license);
            if (next instanceof SimpleLicenseExpression) {
                licenseExpression = (LicenseExpression)action.invoke((Object)((SimpleLicenseExpression)next).getLicense());
            } else {
                licenseExpression = next;
                if (licenseExpression == null) {
                    licenseExpression = expression;
                }
            }
        } else {
            licenseExpression = expression;
        }
        return licenseExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final LicenseExpression normalize(LicenseExpression expression, Set<? extends LicenseExpression> set, Function1<? super Set<? extends LicenseExpression>, ? extends LicenseExpression> action) {
        void $this$mapTo$iv$iv;
        boolean same = true;
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LicenseExpression licenseExpression = (LicenseExpression)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            LicenseExpression res2 = this.normalize((LicenseExpression)it);
            same = same && res2 == it;
            LicenseExpression licenseExpression2 = res2;
            collection.add(licenseExpression2);
        }
        List res3 = (List)destination$iv$iv;
        return same ? expression : (LicenseExpression)action.invoke((Object)CollectionsKt.toSet((Iterable)res3));
    }

    @NotNull
    public final LicenseExpression normalize(@NotNull LicenseExpression expression) {
        LicenseExpression licenseExpression;
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        LicenseExpression licenseExpression2 = expression;
        if (licenseExpression2 instanceof JustLicense) {
            licenseExpression = this.normalizeLicense(expression, ((JustLicense)expression).getLicense(), (Function1<? super License, ? extends LicenseExpression>)((Function1)normalize.1.INSTANCE));
        } else if (licenseExpression2 instanceof OrLaterLicense) {
            licenseExpression = this.normalizeLicense(expression, ((OrLaterLicense)expression).getLicense(), (Function1<? super License, ? extends LicenseExpression>)((Function1)normalize.2.INSTANCE));
        } else if (licenseExpression2 instanceof WithException) {
            LicenseExpression licenseExpression3 = this.normalize(((WithException)expression).getLicense());
            if (licenseExpression3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.github.vlsi.gradle.license.api.SimpleLicenseExpression");
            }
            SimpleLicenseExpression license = (SimpleLicenseExpression)licenseExpression3;
            LicenseException exception = this.normalize(((WithException)expression).getException());
            licenseExpression = license == ((WithException)expression).getLicense() && exception == ((WithException)expression).getException() ? (WithException)expression : new WithException(license, ((WithException)expression).getException());
        } else {
            licenseExpression = licenseExpression2 instanceof ConjunctionLicenseExpression ? this.normalize(expression, ((ConjunctionLicenseExpression)expression).getUnordered(), (Function1<? super Set<? extends LicenseExpression>, ? extends LicenseExpression>)((Function1)normalize.3.INSTANCE)) : (licenseExpression2 instanceof DisjunctionLicenseExpression ? this.normalize(expression, ((DisjunctionLicenseExpression)expression).getUnordered(), (Function1<? super Set<? extends LicenseExpression>, ? extends LicenseExpression>)((Function1)normalize.4.INSTANCE)) : expression);
        }
        return licenseExpression;
    }
}

