/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames;

import java.util.Optional;
import java.util.UUID;

public interface Assertion {
    public Optional<String> explanation();

    public static class Empty
    implements Assertion {
        @Override
        public Optional<String> explanation() {
            return Optional.empty();
        }
    }

    public static class Fake
    implements Assertion {
        private final String message;

        public Fake() {
            this(UUID.randomUUID().toString());
        }

        public Fake(String msg) {
            this.message = msg;
        }

        @Override
        public Optional<String> explanation() {
            return Optional.ofNullable(this.message);
        }
    }
}

