/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames;

import com.github.lombrozo.testnames.Complaint;
import com.github.lombrozo.testnames.Project;
import com.github.lombrozo.testnames.Rule;
import com.github.lombrozo.testnames.TestClass;
import com.github.lombrozo.testnames.rules.RuleAllTestsHaveProductionClass;
import com.github.lombrozo.testnames.rules.RuleAllTestsInPresentSimple;
import com.github.lombrozo.testnames.rules.RuleCorrectTestName;
import com.github.lombrozo.testnames.rules.RuleSuppressed;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class Cop {
    private final Project project;

    Cop(Project proj) {
        this.project = proj;
    }

    Collection<Complaint> inspection() {
        return Stream.concat(new RuleAllTestsHaveProductionClass(this.project).complaints().stream(), this.project.testClasses().stream().flatMap(Cop::classLevelRules).map(Rule::complaints).flatMap(Collection::stream)).collect(Collectors.toList());
    }

    private static Stream<Rule> classLevelRules(TestClass klass) {
        return Stream.of(new RuleSuppressed((Rule)new RuleAllTestsInPresentSimple(klass), klass), new RuleSuppressed((Rule)new RuleCorrectTestName(klass), klass));
    }
}

