/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames;

import com.github.lombrozo.testnames.ProductionClass;
import com.github.lombrozo.testnames.TestClass;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;

public interface Project {
    public Collection<ProductionClass> productionClasses();

    public Collection<TestClass> testClasses();

    public static class Combined
    implements Project {
        private final Collection<? extends Project> projects;

        public Combined(Project ... projects) {
            this(Arrays.asList(projects));
        }

        Combined(Collection<? extends Project> projects) {
            this.projects = projects;
        }

        @Override
        public Collection<ProductionClass> productionClasses() {
            return this.projects.stream().map(Project::productionClasses).flatMap(Collection::stream).collect(Collectors.toList());
        }

        @Override
        public Collection<TestClass> testClasses() {
            return this.projects.stream().map(Project::testClasses).flatMap(Collection::stream).collect(Collectors.toList());
        }
    }

    public static final class Fake
    implements Project {
        private final Collection<? extends ProductionClass> classes;
        private final Collection<? extends TestClass> tests;

        public Fake() {
            this(new ProductionClass.Fake());
        }

        public Fake(ProductionClass ... classes) {
            this(Arrays.asList(classes), Collections.emptyList());
        }

        public Fake(TestClass ... tests) {
            this(Collections.emptyList(), Arrays.asList(tests));
        }

        public Fake(ProductionClass clazz, TestClass test) {
            this(Collections.singleton(clazz), Collections.singleton(test));
        }

        public Fake(Collection<? extends ProductionClass> classes, Collection<? extends TestClass> tests) {
            this.classes = classes;
            this.tests = tests;
        }

        @Override
        public Collection<ProductionClass> productionClasses() {
            return Collections.unmodifiableCollection(this.classes);
        }

        @Override
        public Collection<TestClass> testClasses() {
            return Collections.unmodifiableCollection(this.tests);
        }
    }
}

