/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames;

import com.github.lombrozo.testnames.ProductionClass;
import com.github.lombrozo.testnames.Project;
import com.github.lombrozo.testnames.TestClass;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;

final class ProjectWithoutJUnitExtensions
implements Project {
    private final Project original;

    ProjectWithoutJUnitExtensions(Project original) {
        this.original = original;
    }

    @Override
    public Collection<ProductionClass> productionClasses() {
        return this.original.productionClasses();
    }

    @Override
    public Collection<TestClass> testClasses() {
        return Collections.unmodifiableCollection(this.original.testClasses().stream().filter(ProjectWithoutJUnitExtensions::isNotJUnitExtension).collect(Collectors.toList()));
    }

    private static boolean isNotJUnitExtension(TestClass klass) {
        return !klass.isJUnitExtension();
    }
}

