/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames;

import com.github.lombrozo.testnames.Assertion;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public interface TestCase {
    public String name();

    public Collection<String> suppressed();

    public Collection<Assertion> assertions();

    public static final class Fake
    implements TestCase {
        private static final String FAKE_NAME = "FakeCase";
        private final String name;
        private final Collection<String> suppressed;
        private final Collection<Assertion> assertions;

        public Fake() {
            this(FAKE_NAME);
        }

        public Fake(String name) {
            this(name, Collections.emptyList());
        }

        public Fake(Assertion ... asserts) {
            this(FAKE_NAME, Collections.emptyList(), Arrays.asList(asserts));
        }

        public Fake(String name, Assertion ... asserts) {
            this(name, Collections.emptyList(), Arrays.asList(asserts));
        }

        public Fake(String name, Collection<String> suppressed) {
            this(name, suppressed, Collections.emptyList());
        }

        public Fake(String name, Collection<String> suppressed, Collection<Assertion> assertions) {
            this.name = name;
            this.suppressed = suppressed;
            this.assertions = assertions;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Collection<String> suppressed() {
            return Collections.unmodifiableCollection(this.suppressed);
        }

        @Override
        public Collection<Assertion> assertions() {
            return Collections.unmodifiableCollection(this.assertions);
        }

        public String getName() {
            return this.name;
        }

        public Collection<String> getSuppressed() {
            return this.suppressed;
        }

        public Collection<Assertion> getAssertions() {
            return this.assertions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Fake)) {
                return false;
            }
            Fake other = (Fake)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Collection<String> this$suppressed = this.getSuppressed();
            Collection<String> other$suppressed = other.getSuppressed();
            if (this$suppressed == null ? other$suppressed != null : !((Object)this$suppressed).equals(other$suppressed)) {
                return false;
            }
            Collection<Assertion> this$assertions = this.getAssertions();
            Collection<Assertion> other$assertions = other.getAssertions();
            return !(this$assertions == null ? other$assertions != null : !((Object)this$assertions).equals(other$assertions));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Collection<String> $suppressed = this.getSuppressed();
            result = result * 59 + ($suppressed == null ? 43 : ((Object)$suppressed).hashCode());
            Collection<Assertion> $assertions = this.getAssertions();
            result = result * 59 + ($assertions == null ? 43 : ((Object)$assertions).hashCode());
            return result;
        }

        public String toString() {
            return "TestCase.Fake(name=" + this.getName() + ", suppressed=" + this.getSuppressed() + ", assertions=" + this.getAssertions() + ")";
        }
    }
}

