/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames;

import com.github.lombrozo.testnames.TestCase;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public interface TestClass {
    public String name();

    public Collection<TestCase> all();

    public Path path();

    public Collection<String> suppressed();

    public boolean isJUnitExtension();

    public static final class Fake
    implements TestClass {
        private static final String DEFAULT_NAME = "FakeClassTest";
        private final String name;
        private final Collection<? extends TestCase> all;
        private final List<String> suppressed;
        private final boolean extension;

        public Fake() {
            this(DEFAULT_NAME, Collections.emptyList(), Collections.emptyList());
        }

        public Fake(TestCase ... all) {
            this(DEFAULT_NAME, all);
        }

        public Fake(boolean extension) {
            this(DEFAULT_NAME, Collections.emptyList(), Collections.emptyList(), extension);
        }

        public Fake(String name, TestCase ... all) {
            this(name, Arrays.asList(all), Collections.emptyList());
        }

        public Fake(List<String> suppressed) {
            this(DEFAULT_NAME, Collections.emptyList(), suppressed);
        }

        public Fake(List<String> suppressed, TestCase ... all) {
            this(DEFAULT_NAME, Arrays.asList(all), suppressed);
        }

        Fake(String name, Collection<? extends TestCase> all, List<String> suppressed) {
            this(name, all, suppressed, false);
        }

        Fake(String name, Collection<? extends TestCase> all, List<String> suppressed, boolean extension) {
            this.name = name;
            this.all = all;
            this.suppressed = suppressed;
            this.extension = extension;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Collection<TestCase> all() {
            return Collections.unmodifiableCollection(this.all);
        }

        @Override
        public Path path() {
            return Paths.get(this.name, new String[0]);
        }

        @Override
        public Collection<String> suppressed() {
            return Collections.unmodifiableList(this.suppressed);
        }

        @Override
        public boolean isJUnitExtension() {
            return this.extension;
        }

        public String getName() {
            return this.name;
        }

        public Collection<? extends TestCase> getAll() {
            return this.all;
        }

        public List<String> getSuppressed() {
            return this.suppressed;
        }

        public boolean isExtension() {
            return this.extension;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Fake)) {
                return false;
            }
            Fake other = (Fake)o;
            if (this.isExtension() != other.isExtension()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Collection<? extends TestCase> this$all = this.getAll();
            Collection<? extends TestCase> other$all = other.getAll();
            if (this$all == null ? other$all != null : !((Object)this$all).equals(other$all)) {
                return false;
            }
            List<String> this$suppressed = this.getSuppressed();
            List<String> other$suppressed = other.getSuppressed();
            return !(this$suppressed == null ? other$suppressed != null : !((Object)this$suppressed).equals(other$suppressed));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isExtension() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Collection<? extends TestCase> $all = this.getAll();
            result = result * 59 + ($all == null ? 43 : ((Object)$all).hashCode());
            List<String> $suppressed = this.getSuppressed();
            result = result * 59 + ($suppressed == null ? 43 : ((Object)$suppressed).hashCode());
            return result;
        }

        public String toString() {
            return "TestClass.Fake(name=" + this.getName() + ", all=" + this.getAll() + ", suppressed=" + this.getSuppressed() + ", extension=" + this.isExtension() + ")";
        }
    }
}

