/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames;

import com.github.lombrozo.testnames.Complaint;
import com.github.lombrozo.testnames.Cop;
import com.github.lombrozo.testnames.Project;
import com.github.lombrozo.testnames.ProjectWithoutJUnitExtensions;
import com.github.lombrozo.testnames.RuleName;
import com.github.lombrozo.testnames.bytecode.BytecodeProject;
import com.github.lombrozo.testnames.complaints.ComplaintCompound;
import com.github.lombrozo.testnames.javaparser.ProjectJavaParser;
import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="check", defaultPhase=LifecyclePhase.VALIDATE)
public final class ValidateMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    private MavenProject project;
    @Parameter(defaultValue="true")
    private boolean failOnError = true;
    @Parameter(property="exclusions")
    private String[] exclusions;
    @Parameter(defaultValue="${project.build.directory}/generated-sources")
    private File sources;
    @Parameter(defaultValue="${project.build.directory}/generated-test-sources")
    private File tests;

    public void execute() throws MojoFailureException {
        Collection<Complaint> complaints = new Cop(new ProjectWithoutJUnitExtensions(new Project.Combined(new BytecodeProject(this.sources, this.tests), new ProjectJavaParser(Paths.get((String)this.project.getCompileSourceRoots().get(0), new String[0]), Paths.get((String)this.project.getTestCompileSourceRoots().get(0), new String[0]), Arrays.stream(this.exclusions).map(RuleName::new).map(RuleName::withoutPrefix).collect(Collectors.toSet()))))).inspection();
        if (!complaints.isEmpty() && this.failOnError) {
            throw new MojoFailureException(new ComplaintCompound(complaints).message());
        }
        if (!complaints.isEmpty()) {
            complaints.forEach(complaint -> this.getLog().warn((CharSequence)complaint.message()));
        }
    }
}

