/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames.bytecode;

import com.github.lombrozo.testnames.ProductionClass;
import com.github.lombrozo.testnames.bytecode.BytecodeProductionClass;
import com.github.lombrozo.testnames.bytecode.BytecodeTestClass;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.bytecode.ClassFile;

final class BytecodeClass {
    private final Path path;

    BytecodeClass(Path bytecode) {
        this.path = bytecode;
    }

    boolean isClass() {
        return this.path.getFileName().toString().endsWith(".class");
    }

    BytecodeTestClass toTest() {
        return new BytecodeTestClass(this.path, this.parse());
    }

    ProductionClass toProductionClass() {
        return new BytecodeProductionClass(this.parse());
    }

    private CtClass parse() {
        try {
            return ClassPool.getDefault().makeClass(new ClassFile(new DataInputStream(Files.newInputStream(this.path.toFile().toPath(), new OpenOption[0]))));
        }
        catch (IOException ex) {
            throw new IllegalStateException(String.format("Can't parse class %s", this.path), ex);
        }
    }
}

