/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames.bytecode;

import com.github.lombrozo.testnames.ProductionClass;
import com.github.lombrozo.testnames.Project;
import com.github.lombrozo.testnames.TestClass;
import com.github.lombrozo.testnames.bytecode.BytecodeClass;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class BytecodeProject
implements Project {
    private final Path classes;
    private final Path tests;

    public BytecodeProject(File classes, File tests) {
        this(classes.toPath(), tests.toPath());
    }

    public BytecodeProject(Path classes, Path tests) {
        this.classes = classes;
        this.tests = tests;
    }

    @Override
    public Collection<ProductionClass> productionClasses() {
        Collection<ProductionClass> res;
        block9: {
            if (Files.exists(this.classes, new LinkOption[0])) {
                try (Stream<Path> stream = Files.walk(this.classes, new FileVisitOption[0]);){
                    res = stream.map(BytecodeClass::new).filter(BytecodeClass::isClass).map(BytecodeClass::toProductionClass).collect(Collectors.toList());
                    break block9;
                }
                catch (IOException ex) {
                    throw new IllegalStateException(String.format("Can't read production classes from %s", this.classes), ex);
                }
            }
            res = Collections.emptyList();
        }
        return res;
    }

    @Override
    public Collection<TestClass> testClasses() {
        Collection<TestClass> result;
        block9: {
            if (Files.exists(this.tests, new LinkOption[0])) {
                try (Stream<Path> stream = Files.walk(this.tests, new FileVisitOption[0]);){
                    result = stream.map(BytecodeClass::new).filter(BytecodeClass::isClass).map(BytecodeClass::toTest).collect(Collectors.toList());
                    break block9;
                }
                catch (IOException ex) {
                    throw new IllegalStateException(String.format("Can't read test classes from %s", this.tests), ex);
                }
            }
            result = Collections.emptyList();
        }
        return result;
    }
}

