/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames.bytecode;

import com.github.lombrozo.testnames.JUnitExtension;
import com.github.lombrozo.testnames.TestCase;
import com.github.lombrozo.testnames.TestClass;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Stream;
import javassist.CtClass;
import javassist.NotFoundException;

final class BytecodeTestClass
implements TestClass {
    private final Path file;
    private final CtClass klass;

    BytecodeTestClass(Path path, CtClass clazz) {
        this.file = path;
        this.klass = clazz;
    }

    @Override
    public String name() {
        return this.klass.getSimpleName();
    }

    @Override
    public Collection<TestCase> all() {
        return Collections.emptyList();
    }

    @Override
    public Path path() {
        return this.file;
    }

    @Override
    public Collection<String> suppressed() {
        return Collections.emptyList();
    }

    @Override
    public boolean isJUnitExtension() {
        try {
            return Stream.concat(Arrays.stream(this.klass.getInterfaces()), Stream.of(this.klass.getSuperclass())).map(CtClass::getName).map(JUnitExtension::new).anyMatch(JUnitExtension::isJUnitExtension);
        }
        catch (NotFoundException ex) {
            throw new IllegalStateException(String.format("Can't get interfaces or parent of class %s", this.klass.getName()), ex);
        }
    }
}

