/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames.complaints;

import com.github.lombrozo.testnames.Complaint;
import com.github.lombrozo.testnames.TestClass;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public final class ComplaintClass
implements Complaint {
    private final TestClass clazz;
    private final Collection<? extends Complaint> complaints;

    ComplaintClass(TestClass clazz, Complaint ... complaints) {
        this(clazz, Arrays.asList(complaints));
    }

    public ComplaintClass(TestClass clazz, Collection<? extends Complaint> complaints) {
        this.clazz = clazz;
        this.complaints = complaints;
    }

    @Override
    public String message() {
        AtomicInteger counter = new AtomicInteger(1);
        return String.format("The test class %s (%s:) has encountered some problems. Please review the results for more information.%s", this.clazz.name(), this.clazz.path(), this.complaints.stream().map(Complaint::message).map(message -> String.format("\n\t%d) %s", counter.getAndIncrement(), message)).collect(Collectors.joining()));
    }

    public String toString() {
        return "ComplaintClass(clazz=" + this.clazz + ", complaints=" + this.complaints + ")";
    }
}

