/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames.complaints;

import com.github.lombrozo.testnames.Complaint;
import java.net.MalformedURLException;
import java.net.URL;

public final class ComplaintLinked
implements Complaint {
    private final String complaint;
    private final String suggestion;
    private final String rule;
    private final URL link;

    public ComplaintLinked(String complaint, String suggestion, Class<?> rule, String document) {
        this(complaint, suggestion, rule.getSimpleName(), ComplaintLinked.url(document));
    }

    private ComplaintLinked(String complaint, String suggestion, String rule, URL link) {
        this.complaint = complaint;
        this.suggestion = suggestion;
        this.rule = rule;
        this.link = link;
    }

    @Override
    public String message() {
        return new Complaint.Text(String.format("%s.%n\t%s.%n\tYou can also ignore the rule by adding @SuppressWarnings(\"JTCOP.%s\") annotation.%n\tRule: %s.%n\tYou can read more about the rule here: %s", this.complaint, this.suggestion, this.rule, this.rule, this.link)).message();
    }

    private static URL url(String document) {
        try {
            return new URL(String.format("https://github.com/volodya-lombrozo/jtcop/blob/main/docs/rules/%s", document));
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(String.format("We have  problems with parsing rule documentation link %s", document), ex);
        }
    }
}

