/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames.javaparser;

import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.lombrozo.testnames.javaparser.ParsedAssertion;
import com.github.lombrozo.testnames.javaparser.StingExpression;
import com.github.lombrozo.testnames.javaparser.UnknownMessage;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;

final class AssertionOfJUnit
implements ParsedAssertion {
    private static final String[] SPECIAL = new String[]{"assertAll", "fail"};
    private final MethodCallExpr call;
    private final Map<String, Integer> allowed;

    AssertionOfJUnit(MethodCallExpr method) {
        this(method, AssertionOfJUnit.allowedJUnitNames());
    }

    private AssertionOfJUnit(MethodCallExpr method, Map<String, Integer> methods) {
        this.call = method;
        this.allowed = methods;
    }

    @Override
    public boolean isAssertion() {
        return this.allowed.containsKey(this.call.getName().toString());
    }

    @Override
    public Optional<String> explanation() {
        NodeList args = this.call.getArguments();
        Optional last = args.getLast();
        Integer min = this.allowed.get(this.call.getName().toString());
        Optional<String> result = Arrays.asList(SPECIAL).contains(this.call.getName().toString()) ? new UnknownMessage().message() : (min < args.size() && last.isPresent() ? new StingExpression((Expression)last.get()).asString() : Optional.empty());
        return result;
    }

    private static Map<String, Integer> allowedJUnitNames() {
        return Arrays.stream(Assertions.class.getMethods()).filter(AssertionOfJUnit::isAssertion).collect(Collectors.toMap(Method::getName, Method::getParameterCount, Math::min));
    }

    private static boolean isAssertion(Method method) {
        int modifiers = method.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers);
    }
}

