/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames.javaparser;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.nodeTypes.NodeWithImplements;
import com.github.javaparser.ast.nodeTypes.NodeWithMembers;
import com.github.javaparser.ast.nodeTypes.NodeWithName;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.lombrozo.testnames.javaparser.JavaParserMethod;
import com.github.lombrozo.testnames.javaparser.SuppressedAnnotations;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class JavaParserClass {
    private final Node klass;

    JavaParserClass(Path stream) {
        this(JavaParserClass.parse(stream));
    }

    JavaParserClass(InputStream stream) {
        this(StaticJavaParser.parse((InputStream)stream));
    }

    JavaParserClass(CompilationUnit unit) {
        this(JavaParserClass.fromCompilation(unit));
    }

    private JavaParserClass(Node unit) {
        this.klass = unit;
    }

    SuppressedAnnotations annotations() {
        return new SuppressedAnnotations(this.klass);
    }

    @SafeVarargs
    final Stream<JavaParserMethod> methods(Predicate<MethodDeclaration> ... filters) {
        return ((NodeWithMembers)this.klass).getMethods().stream().filter(method -> Stream.of(filters).allMatch(filter -> filter.test(method))).map(JavaParserMethod::new);
    }

    boolean isAnnotation() {
        return this.klass instanceof AnnotationDeclaration;
    }

    boolean isInterface() {
        return this.klass instanceof ClassOrInterfaceDeclaration && this.cast().isInterface();
    }

    boolean isPackageInfo() {
        return this.klass instanceof ClassOrInterfaceDeclaration && "empty".equals(this.cast().getNameAsString());
    }

    Collection<Class<?>> parents() {
        Collection<String> all = this.imports();
        return this.implement().getImplementedTypes().stream().filter(ClassOrInterfaceType::isClassOrInterfaceType).map(ClassOrInterfaceType::getNameWithScope).map(name -> all.stream().filter(s -> s.contains((CharSequence)name)).findFirst().orElse((String)name)).map(this::load).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<Class<?>> load(String name) {
        Optional<Class<Object>> res;
        try {
            res = Optional.ofNullable(Thread.currentThread().getContextClassLoader().loadClass(name));
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(this.getClass().getName()).warning(String.format("Can't find class %s in classpath", name));
            res = Optional.empty();
        }
        return res;
    }

    private Collection<String> imports() {
        return this.klass.getParentNode().map(node -> ((CompilationUnit)node).getImports().stream().map(NodeWithName::getNameAsString).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private NodeWithImplements<?> implement() {
        if (this.klass instanceof NodeWithImplements) {
            return (NodeWithImplements)this.klass;
        }
        throw new IllegalStateException(String.format("Can't cast %s to NodeWithImplements", this.klass));
    }

    private ClassOrInterfaceDeclaration cast() {
        if (this.klass instanceof ClassOrInterfaceDeclaration) {
            return (ClassOrInterfaceDeclaration)this.klass;
        }
        throw new IllegalStateException(String.format("Can't cast %s to ClassOrInterfaceDeclaration", this.klass));
    }

    private static Node fromCompilation(CompilationUnit unit) {
        Queue all = unit.getChildNodes().stream().filter(node -> node instanceof TypeDeclaration).collect(Collectors.toCollection(LinkedList::new));
        if (all.isEmpty()) {
            all.add(new ClassOrInterfaceDeclaration());
        }
        return (Node)all.element();
    }

    private static CompilationUnit parse(Path path) {
        try {
            return StaticJavaParser.parse((Path)path);
        }
        catch (IOException ex) {
            throw new IllegalStateException(String.format("Can't parse java file: %s", path.toAbsolutePath()), ex);
        }
    }
}

