/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames.javaparser;

import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.util.stream.Stream;

final class JavaParserMethod {
    private final MethodDeclaration method;

    JavaParserMethod(MethodDeclaration declaration) {
        this.method = declaration;
    }

    String name() {
        return this.method.getNameAsString();
    }

    MethodDeclaration asMethodDeclaration() {
        return this.method;
    }

    Stream<MethodCallExpr> statements() {
        return this.body().getStatements().stream().filter(Statement::isExpressionStmt).map(JavaParserMethod::toExpression).filter(Expression::isMethodCallExpr).map(MethodCallExpr.class::cast);
    }

    private BlockStmt body() {
        return (BlockStmt)this.method.getBody().orElseThrow(() -> new IllegalStateException(String.format("The method %s has to have body, otherwise it is not a method", this.method.getNameAsString())));
    }

    private static Expression toExpression(Statement statement) {
        return ((ExpressionStmt)statement.toExpressionStmt().orElseThrow(() -> {
            throw new IllegalStateException("Statement is not expression");
        })).getExpression();
    }

    public String toString() {
        return "JavaParserMethod(method=" + this.method + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaParserMethod)) {
            return false;
        }
        JavaParserMethod other = (JavaParserMethod)o;
        MethodDeclaration this$method = this.method;
        MethodDeclaration other$method = other.method;
        return !(this$method == null ? other$method != null : !this$method.equals(other$method));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MethodDeclaration $method = this.method;
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        return result;
    }
}

