/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames.javaparser;

import com.github.lombrozo.testnames.ProductionClass;
import com.github.lombrozo.testnames.Project;
import com.github.lombrozo.testnames.TestClass;
import com.github.lombrozo.testnames.javaparser.JavaParserClass;
import com.github.lombrozo.testnames.javaparser.ProductionClassJavaParser;
import com.github.lombrozo.testnames.javaparser.TestClassJavaParser;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ProjectJavaParser
implements Project {
    private final Path main;
    private final Path test;
    private final Collection<String> exclusions;

    public ProjectJavaParser(Path main, Path test, Collection<String> exclusions) {
        this.main = main;
        this.test = test;
        this.exclusions = exclusions;
    }

    ProjectJavaParser(Path main, Path test) {
        this(main, test, Collections.emptyList());
    }

    @Override
    public Collection<ProductionClass> productionClasses() {
        Collection<ProductionClass> res;
        block9: {
            if (Files.exists(this.main, new LinkOption[0])) {
                try (Stream<Path> files = Files.walk(this.main, new FileVisitOption[0]);){
                    res = files.filter(x$0 -> Files.exists(x$0, new LinkOption[0])).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".java")).map(ProductionClassJavaParser::new).collect(Collectors.toList());
                    break block9;
                }
                catch (IOException exception) {
                    throw new IllegalStateException(exception);
                }
            }
            res = Collections.emptyList();
        }
        return res;
    }

    @Override
    public Collection<TestClass> testClasses() {
        Collection<TestClass> res;
        block9: {
            if (Files.exists(this.test, new LinkOption[0])) {
                try (Stream<Path> files = Files.walk(this.test, new FileVisitOption[0]);){
                    res = files.filter(x$0 -> Files.exists(x$0, new LinkOption[0])).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".java")).filter(path -> {
                        JavaParserClass parsed = new JavaParserClass((Path)path);
                        return !parsed.isAnnotation() && !parsed.isInterface() && !parsed.isPackageInfo();
                    }).map(klass -> new TestClassJavaParser((Path)klass, this.exclusions)).collect(Collectors.toList());
                    break block9;
                }
                catch (IOException exception) {
                    throw new IllegalStateException(exception);
                }
            }
            res = Collections.emptyList();
        }
        return res;
    }
}

