/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames.javaparser;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.VarType;
import com.github.lombrozo.testnames.Assertion;
import com.github.lombrozo.testnames.TestCase;
import com.github.lombrozo.testnames.TestClass;
import com.github.lombrozo.testnames.javaparser.AssertionOfJavaParser;
import com.github.lombrozo.testnames.javaparser.JavaParserMethod;
import com.github.lombrozo.testnames.javaparser.ParsedAssertion;
import com.github.lombrozo.testnames.javaparser.SuppressedAnnotations;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class TestCaseJavaParser
implements TestCase {
    private final JavaParserMethod method;
    private final TestClass parent;

    TestCaseJavaParser(String name) {
        this(new MethodDeclaration(new NodeList(), (Type)new VarType(), name));
    }

    private TestCaseJavaParser(MethodDeclaration method) {
        this(method, (TestClass)new TestClass.Fake());
    }

    TestCaseJavaParser(MethodDeclaration method, TestClass parent) {
        this(new JavaParserMethod(method), parent);
    }

    TestCaseJavaParser(JavaParserMethod method, TestClass parent) {
        this.method = method;
        this.parent = parent;
    }

    @Override
    public String name() {
        return this.method.name();
    }

    @Override
    public Collection<String> suppressed() {
        return Stream.concat(this.parent.suppressed().stream(), new SuppressedAnnotations((Node)this.method.asMethodDeclaration()).suppressed()).collect(Collectors.toSet());
    }

    @Override
    public Collection<Assertion> assertions() {
        return this.method.statements().map(AssertionOfJavaParser::new).filter(ParsedAssertion::isAssertion).collect(Collectors.toList());
    }

    public JavaParserMethod getMethod() {
        return this.method;
    }

    public TestClass getParent() {
        return this.parent;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestCaseJavaParser)) {
            return false;
        }
        TestCaseJavaParser other = (TestCaseJavaParser)o;
        JavaParserMethod this$method = this.getMethod();
        JavaParserMethod other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
            return false;
        }
        TestClass this$parent = this.getParent();
        TestClass other$parent = other.getParent();
        return !(this$parent == null ? other$parent != null : !this$parent.equals(other$parent));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JavaParserMethod $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
        TestClass $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
        return result;
    }

    public String toString() {
        return "TestCaseJavaParser(method=" + this.getMethod() + ", parent=" + this.getParent() + ")";
    }
}

