/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames.javaparser;

import com.github.javaparser.ParseProblemException;
import com.github.javaparser.StaticJavaParser;
import com.github.lombrozo.testnames.JUnitExtension;
import com.github.lombrozo.testnames.TestCase;
import com.github.lombrozo.testnames.TestClass;
import com.github.lombrozo.testnames.javaparser.JavaParserClass;
import com.github.lombrozo.testnames.javaparser.JavaParserMethod;
import com.github.lombrozo.testnames.javaparser.TestCaseJavaParser;
import com.github.lombrozo.testnames.javaparser.TestsOnly;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cactoos.scalar.Sticky;
import org.cactoos.scalar.Unchecked;

public final class TestClassJavaParser
implements TestClass {
    private final Path path;
    private final Unchecked<JavaParserClass> unit;
    private final Collection<String> exclusions;

    TestClassJavaParser(Path klass) {
        this(klass, TestClassJavaParser.parse(klass));
    }

    TestClassJavaParser(Path klass, Collection<String> exclusions) {
        this(klass, TestClassJavaParser.parse(klass), exclusions);
    }

    TestClassJavaParser(Path klass, InputStream stream) {
        this(klass, TestClassJavaParser.parse(stream));
    }

    private TestClassJavaParser(Path klass, Sticky<JavaParserClass> parsed) {
        this(klass, (Unchecked<JavaParserClass>)new Unchecked(parsed), Collections.emptySet());
    }

    TestClassJavaParser(Path klass, InputStream stream, Collection<String> exclusions) {
        this(klass, TestClassJavaParser.parse(stream), exclusions);
    }

    TestClassJavaParser(Path klass, Sticky<JavaParserClass> parsed, Collection<String> exclusions) {
        this(klass, (Unchecked<JavaParserClass>)new Unchecked(parsed), exclusions);
    }

    TestClassJavaParser(Path path, Unchecked<JavaParserClass> unit, Collection<String> exclusions) {
        this.path = path;
        this.unit = unit;
        this.exclusions = exclusions;
    }

    @Override
    public String name() {
        return this.path.getFileName().toString();
    }

    @Override
    public Collection<TestCase> all() {
        try {
            return ((JavaParserClass)this.unit.value()).methods(new TestsOnly()).map(method -> new TestCaseJavaParser((JavaParserMethod)method, (TestClass)this)).collect(Collectors.toSet());
        }
        catch (ParseProblemException | UncheckedIOException ex) {
            throw new IllegalStateException(String.format("Failed to parse Java class by path %s", this.path), ex);
        }
    }

    @Override
    public Path path() {
        return this.path;
    }

    @Override
    public Collection<String> suppressed() {
        return Stream.concat(((JavaParserClass)this.unit.value()).annotations().suppressed(), this.exclusions.stream()).collect(Collectors.toSet());
    }

    @Override
    public boolean isJUnitExtension() {
        return ((JavaParserClass)this.unit.value()).parents().stream().map(JUnitExtension::new).anyMatch(JUnitExtension::isJUnitExtension);
    }

    private static Sticky<JavaParserClass> parse(Path path) {
        return new Sticky(() -> new JavaParserClass(StaticJavaParser.parse((Path)path)));
    }

    private static Sticky<JavaParserClass> parse(InputStream stream) {
        return new Sticky(() -> new JavaParserClass(StaticJavaParser.parse((InputStream)stream)));
    }
}

