/*
 * Decompiled with CFR 0.152.
 */
package com.github.lombrozo.testnames.rules;

import com.github.lombrozo.testnames.Complaint;
import com.github.lombrozo.testnames.ProductionClass;
import com.github.lombrozo.testnames.Project;
import com.github.lombrozo.testnames.Rule;
import com.github.lombrozo.testnames.TestClass;
import com.github.lombrozo.testnames.complaints.ComplaintLinked;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class RuleAllTestsHaveProductionClass
implements Rule {
    public static final String NAME = "RuleAllTestsHaveProductionClass";
    private static final Pattern UNDERSCORE = Pattern.compile("_");
    private static final Pattern DOLLAR = Pattern.compile("\\$");
    private final Project project;

    public RuleAllTestsHaveProductionClass(Project proj) {
        this.project = proj;
    }

    @Override
    public Collection<Complaint> complaints() {
        Map classes = this.project.productionClasses().stream().filter(clazz -> RuleAllTestsHaveProductionClass.isNotPackageInfo(clazz.name())).collect(Collectors.toMap(RuleAllTestsHaveProductionClass::correspondingTest, Function.identity(), (first, second) -> first));
        ArrayList<Complaint> complaints = new ArrayList<Complaint>(0);
        Collection tests = this.project.testClasses().stream().filter(test -> RuleAllTestsHaveProductionClass.isNotPackageInfo(test.name())).collect(Collectors.toList());
        for (TestClass test2 : tests) {
            String name = RuleAllTestsHaveProductionClass.clean(test2.name());
            if (classes.containsKey(name) || !RuleAllTestsHaveProductionClass.isNotSuppressed(test2)) continue;
            complaints.add(new ComplaintLinked(String.format("Test %s doesn't have corresponding production class", name), String.format("Either rename or move the test class %s", test2.path()), this.getClass(), "all-have-production-class.md"));
        }
        return complaints;
    }

    private static String correspondingTest(ProductionClass clazz) {
        return String.format("%sTest", RuleAllTestsHaveProductionClass.clean(clazz.name()));
    }

    private static String clean(String original) {
        String plain = original.endsWith(".java") ? original.substring(0, original.length() - 5) : (original.endsWith(".class") ? original.substring(0, original.length() - 6) : original);
        return DOLLAR.matcher(UNDERSCORE.matcher(plain).replaceAll("")).replaceAll("");
    }

    private static boolean isNotSuppressed(TestClass klass) {
        return !klass.suppressed().contains(NAME);
    }

    private static boolean isNotPackageInfo(String name) {
        return !"package-info.java".equals(name);
    }
}

